/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.reader;

import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.parquet.ParquetTimestampUtils;
import com.facebook.presto.parquet.RichColumnDescriptor;
import com.facebook.presto.parquet.reader.PrimitiveColumnReader;
import org.apache.parquet.io.api.Binary;

public class TimestampColumnReader
extends PrimitiveColumnReader {
    public TimestampColumnReader(RichColumnDescriptor descriptor) {
        super(descriptor);
    }

    @Override
    protected void readValue(BlockBuilder blockBuilder, Type type) {
        if (this.definitionLevel == this.columnDescriptor.getMaxDefinitionLevel()) {
            Binary binary = this.valuesReader.readBytes();
            type.writeLong(blockBuilder, ParquetTimestampUtils.getTimestampMillis(binary));
        } else if (this.isValueNull()) {
            blockBuilder.appendNull();
        }
    }

    @Override
    protected void skipValue() {
        if (this.definitionLevel == this.columnDescriptor.getMaxDefinitionLevel()) {
            this.valuesReader.readBytes();
        }
    }
}

