/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.writer;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.parquet.writer.ColumnChunk;
import com.facebook.presto.parquet.writer.ColumnWriter;
import com.facebook.presto.parquet.writer.ParquetCompressor;
import com.facebook.presto.parquet.writer.ParquetDataOutput;
import com.facebook.presto.parquet.writer.ParquetTypeConverter;
import com.facebook.presto.parquet.writer.levels.DefinitionLevelIterable;
import com.facebook.presto.parquet.writer.levels.DefinitionLevelIterables;
import com.facebook.presto.parquet.writer.levels.RepetitionLevelIterable;
import com.facebook.presto.parquet.writer.levels.RepetitionLevelIterables;
import com.facebook.presto.parquet.writer.valuewriter.PrimitiveValueWriter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.page.DictionaryPage;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.column.values.rle.RunLengthBitPackingHybridEncoder;
import org.apache.parquet.format.ColumnMetaData;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;

public class PrimitiveColumnWriter
implements ColumnWriter {
    private final Type type;
    private final ColumnDescriptor columnDescriptor;
    private final CompressionCodecName compressionCodec;
    private final PrimitiveValueWriter primitiveValueWriter;
    private final RunLengthBitPackingHybridEncoder definitionLevelEncoder;
    private final RunLengthBitPackingHybridEncoder repetitionLevelEncoder;
    private final ParquetMetadataConverter parquetMetadataConverter = new ParquetMetadataConverter();
    private boolean closed;
    private boolean getDataStreamsCalled;
    private int currentPageRows;
    private int currentPageNullCounts;
    private int currentPageRowCount;
    private final Set<Encoding> encodings;
    private long totalCompressedSize;
    private long totalUnCompressedSize;
    private long totalRows;
    private final int maxDefinitionLevel;
    private final List<ParquetDataOutput> pageBuffer = new ArrayList<ParquetDataOutput>();
    @Nullable
    private final ParquetCompressor compressor;
    private final int pageSizeThreshold;

    public PrimitiveColumnWriter(Type type, ColumnDescriptor columnDescriptor, PrimitiveValueWriter primitiveValueWriter, RunLengthBitPackingHybridEncoder definitionLevelEncoder, RunLengthBitPackingHybridEncoder repetitionLevelEncoder, CompressionCodecName compressionCodecName, int pageSizeThreshold) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.columnDescriptor = Objects.requireNonNull(columnDescriptor, "columnDescriptor is null");
        this.maxDefinitionLevel = columnDescriptor.getMaxDefinitionLevel();
        this.definitionLevelEncoder = Objects.requireNonNull(definitionLevelEncoder, "definitionLevelEncoder is null");
        this.repetitionLevelEncoder = Objects.requireNonNull(repetitionLevelEncoder, "repetitionLevelEncoder is null");
        this.primitiveValueWriter = Objects.requireNonNull(primitiveValueWriter, "primitiveValueWriter is null");
        this.encodings = new HashSet<Encoding>();
        this.compressionCodec = Objects.requireNonNull(compressionCodecName, "compressionCodecName is null");
        this.compressor = ParquetCompressor.getCompressor(compressionCodecName);
        this.pageSizeThreshold = pageSizeThreshold;
    }

    @Override
    public void writeBlock(ColumnChunk columnChunk) throws IOException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        ColumnChunk current = new ColumnChunk(columnChunk.getBlock(), (List<DefinitionLevelIterable>)ImmutableList.builder().addAll(columnChunk.getDefinitionLevelIterables()).add((Object)DefinitionLevelIterables.of(columnChunk.getBlock(), this.maxDefinitionLevel)).build(), (List<RepetitionLevelIterable>)ImmutableList.builder().addAll(columnChunk.getRepetitionLevelIterables()).add((Object)RepetitionLevelIterables.of(columnChunk.getBlock())).build());
        this.primitiveValueWriter.write(columnChunk.getBlock());
        this.encodings.add(this.primitiveValueWriter.getEncoding());
        Iterator<Integer> defIterator = DefinitionLevelIterables.getIterator(current.getDefinitionLevelIterables());
        while (defIterator.hasNext()) {
            int next = defIterator.next();
            this.definitionLevelEncoder.writeInt(next);
            if (next != this.maxDefinitionLevel) {
                ++this.currentPageNullCounts;
            }
            ++this.currentPageRows;
        }
        Iterator<Integer> repIterator = RepetitionLevelIterables.getIterator(current.getRepetitionLevelIterables());
        while (repIterator.hasNext()) {
            int next = repIterator.next();
            this.repetitionLevelEncoder.writeInt(next);
            if (next != 0) continue;
            ++this.currentPageRowCount;
        }
        if (this.getBufferedBytes() >= (long)this.pageSizeThreshold) {
            this.flushCurrentPageToBuffer();
        }
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public List<ColumnWriter.BufferData> getBuffer() throws IOException {
        Preconditions.checkState((boolean)this.closed);
        return ImmutableList.of((Object)new ColumnWriter.BufferData(this.getDataStreams(), this.getColumnMetaData()));
    }

    private ColumnMetaData getColumnMetaData() {
        Preconditions.checkState((boolean)this.getDataStreamsCalled);
        return new ColumnMetaData(ParquetTypeConverter.getType(this.columnDescriptor.getPrimitiveType().getPrimitiveTypeName()), (List)this.encodings.stream().map(arg_0 -> ((ParquetMetadataConverter)this.parquetMetadataConverter).getEncoding(arg_0)).collect(ImmutableList.toImmutableList()), (List)ImmutableList.copyOf((Object[])this.columnDescriptor.getPath()), this.compressionCodec.getParquetCompressionCodec(), this.totalRows, this.totalUnCompressedSize, this.totalCompressedSize, -1L);
    }

    private void flushCurrentPageToBuffer() throws IOException {
        long compressedSize;
        ParquetDataOutput data;
        ImmutableList.Builder outputDataStreams = ImmutableList.builder();
        BytesInput bytes = this.primitiveValueWriter.getBytes();
        ParquetDataOutput repetitions = ParquetDataOutput.createDataOutput(BytesInput.copy((BytesInput)this.repetitionLevelEncoder.toBytes()));
        ParquetDataOutput definitions = ParquetDataOutput.createDataOutput(BytesInput.copy((BytesInput)this.definitionLevelEncoder.toBytes()));
        long uncompressedSize = bytes.size() + repetitions.size() + definitions.size();
        if (this.compressor != null) {
            data = this.compressor.compress(bytes);
            compressedSize = data.size() + repetitions.size() + definitions.size();
        } else {
            data = ParquetDataOutput.createDataOutput(BytesInput.copy((BytesInput)bytes));
            compressedSize = uncompressedSize;
        }
        ByteArrayOutputStream pageHeaderOutputStream = new ByteArrayOutputStream();
        Statistics<?> statistics = this.primitiveValueWriter.getStatistics();
        statistics.incrementNumNulls((long)this.currentPageNullCounts);
        this.parquetMetadataConverter.writeDataPageV2Header((int)uncompressedSize, (int)compressedSize, this.currentPageRows, this.currentPageNullCounts, this.currentPageRowCount, statistics, this.primitiveValueWriter.getEncoding(), (int)repetitions.size(), (int)definitions.size(), (OutputStream)pageHeaderOutputStream);
        ParquetDataOutput pageHeader = ParquetDataOutput.createDataOutput(Slices.wrappedBuffer((byte[])pageHeaderOutputStream.toByteArray()));
        outputDataStreams.add((Object)pageHeader);
        outputDataStreams.add((Object)repetitions);
        outputDataStreams.add((Object)definitions);
        outputDataStreams.add((Object)data);
        ImmutableList dataOutputs = outputDataStreams.build();
        this.totalCompressedSize += pageHeader.size() + compressedSize;
        this.totalUnCompressedSize += pageHeader.size() + uncompressedSize;
        this.totalRows += (long)this.currentPageRows;
        this.pageBuffer.addAll((Collection<ParquetDataOutput>)dataOutputs);
        this.currentPageRows = 0;
        this.currentPageNullCounts = 0;
        this.currentPageRowCount = 0;
        this.definitionLevelEncoder.reset();
        this.repetitionLevelEncoder.reset();
        this.primitiveValueWriter.reset();
    }

    private List<ParquetDataOutput> getDataStreams() throws IOException {
        DictionaryPage dictionaryPage;
        ArrayList<ParquetDataOutput> dictPage = new ArrayList<ParquetDataOutput>();
        if (this.currentPageRows > 0) {
            this.flushCurrentPageToBuffer();
        }
        if ((dictionaryPage = this.primitiveValueWriter.toDictPageAndClose()) != null) {
            BytesInput pageBytes = BytesInput.copy((BytesInput)dictionaryPage.getBytes());
            long uncompressedSize = dictionaryPage.getUncompressedSize();
            ParquetDataOutput pageData = ParquetDataOutput.createDataOutput(pageBytes);
            if (this.compressor != null) {
                pageData = this.compressor.compress(pageBytes);
            }
            long compressedSize = pageData.size();
            ByteArrayOutputStream dictStream = new ByteArrayOutputStream();
            this.parquetMetadataConverter.writeDictionaryPageHeader(Math.toIntExact(uncompressedSize), Math.toIntExact(compressedSize), dictionaryPage.getDictionarySize(), dictionaryPage.getEncoding(), (OutputStream)dictStream);
            ParquetDataOutput pageHeader = ParquetDataOutput.createDataOutput(Slices.wrappedBuffer((byte[])dictStream.toByteArray()));
            dictPage.add(pageHeader);
            dictPage.add(pageData);
            this.totalCompressedSize += pageHeader.size() + compressedSize;
            this.totalUnCompressedSize += pageHeader.size() + uncompressedSize;
        }
        this.getDataStreamsCalled = true;
        return ImmutableList.builder().addAll(dictPage).addAll(this.pageBuffer).build();
    }

    @Override
    public long getBufferedBytes() {
        return this.pageBuffer.stream().mapToLong(ParquetDataOutput::size).sum() + this.definitionLevelEncoder.getBufferedSize() + this.repetitionLevelEncoder.getBufferedSize();
    }

    @Override
    public void reset() {
        this.primitiveValueWriter.reset();
        this.primitiveValueWriter.resetDictionary();
        this.pageBuffer.clear();
        this.closed = false;
        this.totalCompressedSize = 0L;
        this.totalUnCompressedSize = 0L;
        this.totalRows = 0L;
        this.encodings.clear();
        this.getDataStreamsCalled = false;
    }
}

