/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.batchreader.decoders.delta;

import com.facebook.presto.parquet.batchreader.decoders.ValuesDecoder;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.column.values.delta.DeltaBinaryPackingValuesReader;

public class Int64TimestampMicrosDeltaBinaryPackedValuesDecoder
implements ValuesDecoder.Int64TimestampMicrosValuesDecoder {
    private final DeltaBinaryPackingValuesReader innerReader = new DeltaBinaryPackingValuesReader();

    public Int64TimestampMicrosDeltaBinaryPackedValuesDecoder(int valueCount, ByteBufferInputStream bufferInputStream) throws IOException {
        this.innerReader.initFromPage(valueCount, bufferInputStream);
    }

    @Override
    public void readNext(long[] values, int offset, int length) {
        int endOffset = offset + length;
        for (int i = offset; i < endOffset; ++i) {
            values[i] = TimeUnit.MICROSECONDS.toMillis(this.innerReader.readLong());
        }
    }

    @Override
    public void skip(int length) {
        while (length > 0) {
            this.innerReader.skip();
            --length;
        }
    }
}

