/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.predicate;

import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.parquet.DictionaryPage;
import com.facebook.presto.parquet.ParquetCompressionUtils;
import com.facebook.presto.parquet.ParquetCorruptionException;
import com.facebook.presto.parquet.ParquetDataSource;
import com.facebook.presto.parquet.ParquetEncoding;
import com.facebook.presto.parquet.ParquetTypeUtils;
import com.facebook.presto.parquet.RichColumnDescriptor;
import com.facebook.presto.parquet.predicate.DictionaryDescriptor;
import com.facebook.presto.parquet.predicate.Predicate;
import com.facebook.presto.parquet.predicate.TupleDomainParquetPredicate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.EncodingStats;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.format.DictionaryPageHeader;
import org.apache.parquet.format.PageHeader;
import org.apache.parquet.format.PageType;
import org.apache.parquet.format.Util;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.internal.filter2.columnindex.ColumnIndexStore;
import org.apache.parquet.schema.MessageType;

public final class PredicateUtils {
    private PredicateUtils() {
    }

    public static boolean isStatisticsOverflow(Type type, long min, long max) {
        return type.equals(TinyintType.TINYINT) && (min < -128L || max > 127L) || type.equals(SmallintType.SMALLINT) && (min < -32768L || max > 32767L) || type.equals(IntegerType.INTEGER) && (min < Integer.MIN_VALUE || max > Integer.MAX_VALUE);
    }

    public static Predicate buildPredicate(MessageType requestedSchema, TupleDomain<ColumnDescriptor> parquetTupleDomain, Map<List<String>, RichColumnDescriptor> descriptorsByPath) {
        ImmutableList.Builder columnReferences = ImmutableList.builder();
        for (String[] paths : requestedSchema.getPaths()) {
            RichColumnDescriptor descriptor = descriptorsByPath.get(Arrays.asList(paths));
            if (descriptor == null) continue;
            columnReferences.add((Object)descriptor);
        }
        return new TupleDomainParquetPredicate(parquetTupleDomain, (List<RichColumnDescriptor>)columnReferences.build());
    }

    public static boolean predicateMatches(Predicate parquetPredicate, BlockMetaData block, ParquetDataSource dataSource, Map<List<String>, RichColumnDescriptor> descriptorsByPath, TupleDomain<ColumnDescriptor> parquetTupleDomain, Optional<ColumnIndexStore> columnIndexStore, boolean readColumnIndex) throws ParquetCorruptionException {
        Map<ColumnDescriptor, Statistics<?>> columnStatistics = PredicateUtils.getStatistics(block, descriptorsByPath);
        if (!parquetPredicate.matches(block.getRowCount(), columnStatistics, dataSource.getId())) {
            return false;
        }
        if (columnIndexStore.isPresent() && readColumnIndex && !parquetPredicate.matches(block.getRowCount(), columnIndexStore)) {
            return false;
        }
        return PredicateUtils.dictionaryPredicatesMatch(parquetPredicate, block, dataSource, descriptorsByPath, parquetTupleDomain);
    }

    private static Map<ColumnDescriptor, Statistics<?>> getStatistics(BlockMetaData blockMetadata, Map<List<String>, RichColumnDescriptor> descriptorsByPath) {
        ImmutableMap.Builder statistics = ImmutableMap.builder();
        for (ColumnChunkMetaData columnMetaData : blockMetadata.getColumns()) {
            RichColumnDescriptor descriptor;
            Statistics columnStatistics = columnMetaData.getStatistics();
            if (columnStatistics == null || (descriptor = descriptorsByPath.get(Arrays.asList(columnMetaData.getPath().toArray()))) == null) continue;
            statistics.put((Object)descriptor, (Object)columnStatistics);
        }
        return statistics.build();
    }

    private static boolean dictionaryPredicatesMatch(Predicate parquetPredicate, BlockMetaData blockMetadata, ParquetDataSource dataSource, Map<List<String>, RichColumnDescriptor> descriptorsByPath, TupleDomain<ColumnDescriptor> parquetTupleDomain) {
        for (ColumnChunkMetaData columnMetaData : blockMetadata.getColumns()) {
            RichColumnDescriptor descriptor = descriptorsByPath.get(Arrays.asList(columnMetaData.getPath().toArray()));
            if (descriptor == null || !PredicateUtils.isOnlyDictionaryEncodingPages(columnMetaData) || !PredicateUtils.isColumnPredicate(descriptor, parquetTupleDomain)) continue;
            byte[] buffer = new byte[Math.toIntExact(columnMetaData.getTotalSize())];
            dataSource.readFully(columnMetaData.getStartingPos(), buffer);
            if (parquetPredicate.matches(new DictionaryDescriptor(descriptor, PredicateUtils.readDictionaryPage(buffer, columnMetaData.getCodec())))) continue;
            return false;
        }
        return true;
    }

    private static Optional<DictionaryPage> readDictionaryPage(byte[] data, CompressionCodecName codecName) {
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
            PageHeader pageHeader = Util.readPageHeader((InputStream)inputStream);
            if (pageHeader.type != PageType.DICTIONARY_PAGE) {
                return Optional.empty();
            }
            Slice compressedData = Slices.wrappedBuffer((byte[])data, (int)(data.length - inputStream.available()), (int)pageHeader.getCompressed_page_size());
            DictionaryPageHeader dictHeader = pageHeader.getDictionary_page_header();
            ParquetEncoding encoding = ParquetTypeUtils.getParquetEncoding(Encoding.valueOf((String)dictHeader.getEncoding().name()));
            int dictionarySize = dictHeader.getNum_values();
            return Optional.of(new DictionaryPage(ParquetCompressionUtils.decompress(codecName, compressedData, pageHeader.getUncompressed_page_size()), dictionarySize, encoding));
        }
        catch (IOException ignored) {
            return Optional.empty();
        }
    }

    private static boolean isColumnPredicate(ColumnDescriptor columnDescriptor, TupleDomain<ColumnDescriptor> parquetTupleDomain) {
        Verify.verify((boolean)parquetTupleDomain.getDomains().isPresent(), (String)"parquetTupleDomain is empty", (Object[])new Object[0]);
        return ((Map)parquetTupleDomain.getDomains().get()).containsKey(columnDescriptor);
    }

    @VisibleForTesting
    public static boolean isOnlyDictionaryEncodingPages(ColumnChunkMetaData columnMetaData) {
        EncodingStats stats = columnMetaData.getEncodingStats();
        if (stats != null) {
            return stats.hasDictionaryPages() && !stats.hasNonDictionaryEncodedPages();
        }
        Set encodings = columnMetaData.getEncodings();
        if (encodings.contains(Encoding.PLAIN_DICTIONARY)) {
            return Sets.difference((Set)encodings, (Set)ImmutableSet.of((Object)Encoding.PLAIN_DICTIONARY, (Object)Encoding.RLE, (Object)Encoding.BIT_PACKED)).isEmpty();
        }
        return false;
    }
}

