/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.cache;

import com.facebook.presto.parquet.ParquetCorruptionException;
import com.facebook.presto.parquet.ParquetDataSource;
import com.facebook.presto.parquet.ParquetDataSourceId;
import com.facebook.presto.parquet.ParquetValidationUtils;
import com.facebook.presto.parquet.cache.ParquetFileMetadata;
import com.facebook.presto.parquet.cache.ParquetMetadataSource;
import com.google.common.base.Preconditions;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import org.apache.parquet.column.EncodingStats;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.crypto.AesCipher;
import org.apache.parquet.crypto.AesGcmEncryptor;
import org.apache.parquet.crypto.HiddenColumnChunkMetaData;
import org.apache.parquet.crypto.InternalColumnDecryptionSetup;
import org.apache.parquet.crypto.InternalFileDecryptor;
import org.apache.parquet.crypto.KeyAccessDeniedException;
import org.apache.parquet.crypto.ModuleCipherFactory;
import org.apache.parquet.crypto.ParquetCryptoRuntimeException;
import org.apache.parquet.crypto.TagVerificationException;
import org.apache.parquet.format.BlockCipher;
import org.apache.parquet.format.ColumnChunk;
import org.apache.parquet.format.ColumnCryptoMetaData;
import org.apache.parquet.format.ColumnMetaData;
import org.apache.parquet.format.CompressionCodec;
import org.apache.parquet.format.ConvertedType;
import org.apache.parquet.format.Encoding;
import org.apache.parquet.format.EncryptionWithColumnKey;
import org.apache.parquet.format.FileCryptoMetaData;
import org.apache.parquet.format.KeyValue;
import org.apache.parquet.format.RowGroup;
import org.apache.parquet.format.SchemaElement;
import org.apache.parquet.format.Type;
import org.apache.parquet.format.Util;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.internal.hadoop.metadata.IndexReference;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;

public final class MetadataReader
implements ParquetMetadataSource {
    private static final Slice MAGIC = Slices.wrappedBuffer((byte[])"PAR1".getBytes(StandardCharsets.US_ASCII));
    private static final Slice EMAGIC = Slices.wrappedBuffer((byte[])"PARE".getBytes(StandardCharsets.US_ASCII));
    private static final int POST_SCRIPT_SIZE = 4 + MAGIC.length();
    private static final int EXPECTED_FOOTER_SIZE = 16384;
    private static final ParquetMetadataConverter PARQUET_METADATA_CONVERTER = new ParquetMetadataConverter();
    private static final long MODIFICATION_TIME_NOT_SET = 0L;

    public static ParquetFileMetadata readFooter(ParquetDataSource parquetDataSource, long fileSize, Optional<InternalFileDecryptor> fileDecryptor) throws IOException {
        return MetadataReader.readFooter(parquetDataSource, fileSize, 0L, fileDecryptor);
    }

    public static ParquetFileMetadata readFooter(ParquetDataSource parquetDataSource, long fileSize, long modificationTime, Optional<InternalFileDecryptor> fileDecryptor) throws IOException {
        ParquetValidationUtils.validateParquet(fileSize >= (long)(MAGIC.length() + POST_SCRIPT_SIZE), "%s is not a valid Parquet File", parquetDataSource.getId());
        byte[] buffer = new byte[Math.toIntExact(Math.min(fileSize, 16384L))];
        parquetDataSource.readFully(fileSize - (long)buffer.length, buffer);
        Slice tailSlice = Slices.wrappedBuffer((byte[])buffer);
        Slice magic = tailSlice.slice(tailSlice.length() - MAGIC.length(), MAGIC.length());
        if (!MAGIC.equals((Object)magic) && !EMAGIC.equals((Object)magic)) {
            throw new ParquetCorruptionException(String.format("Not valid Parquet file: %s expected magic number: %s or %s, but got: %s", parquetDataSource.getId(), Arrays.toString(MAGIC.getBytes()), Arrays.toString(EMAGIC.getBytes()), Arrays.toString(magic.getBytes())));
        }
        boolean encryptedFooterMode = EMAGIC.equals((Object)magic);
        int metadataLength = tailSlice.getInt(tailSlice.length() - POST_SCRIPT_SIZE);
        int completeFooterSize = metadataLength + POST_SCRIPT_SIZE;
        long metadataFileOffset = fileSize - (long)completeFooterSize;
        ParquetValidationUtils.validateParquet(metadataFileOffset >= (long)MAGIC.length() && metadataFileOffset + (long)POST_SCRIPT_SIZE < fileSize, "Corrupted Parquet file: %s metadata index: %s out of range", parquetDataSource.getId(), metadataFileOffset);
        if (tailSlice.length() < completeFooterSize) {
            byte[] footerBuffer = new byte[completeFooterSize];
            parquetDataSource.readFully(metadataFileOffset, footerBuffer, 0, footerBuffer.length - tailSlice.length());
            tailSlice.getBytes(0, footerBuffer, footerBuffer.length - tailSlice.length(), tailSlice.length());
            tailSlice = Slices.wrappedBuffer((byte[])footerBuffer, (int)0, (int)footerBuffer.length);
        }
        return MetadataReader.readParquetMetadata(tailSlice.slice(tailSlice.length() - completeFooterSize, metadataLength).getInput(), metadataLength, modificationTime, fileDecryptor, encryptedFooterMode, parquetDataSource.getId());
    }

    private static ParquetFileMetadata readParquetMetadata(BasicSliceInput input, int metadataLength, long modificationTime, Optional<InternalFileDecryptor> fileDecryptor, boolean encryptedFooterMode, ParquetDataSourceId id) throws IOException {
        Preconditions.checkArgument((!encryptedFooterMode || fileDecryptor.isPresent() ? 1 : 0) != 0, (Object)"fileDecryptionProperties cannot be null when encryptedFooterMode is true");
        BlockCipher.Decryptor footerDecryptor = null;
        byte[] additionalAuthenticationData = null;
        if (encryptedFooterMode) {
            FileCryptoMetaData fileCryptoMetaData = Util.readFileCryptoMetaData((InputStream)input);
            fileDecryptor.get().setFileCryptoMetaData(fileCryptoMetaData.getEncryption_algorithm(), true, fileCryptoMetaData.getKey_metadata());
            footerDecryptor = fileDecryptor.get().fetchFooterDecryptor();
            additionalAuthenticationData = AesCipher.createFooterAAD((byte[])fileDecryptor.get().getFileAAD());
        }
        org.apache.parquet.format.FileMetaData fileMetaData = Util.readFileMetaData((InputStream)input, footerDecryptor, additionalAuthenticationData);
        return MetadataReader.convertToParquetMetadata(input, fileMetaData, metadataLength, modificationTime, fileDecryptor, encryptedFooterMode, id);
    }

    private static ParquetFileMetadata convertToParquetMetadata(BasicSliceInput input, org.apache.parquet.format.FileMetaData fileMetaData, int metadataLength, long modificationTime, Optional<InternalFileDecryptor> fileDecryptor, boolean encryptedFooter, ParquetDataSourceId id) throws IOException {
        List schema = fileMetaData.getSchema();
        ParquetValidationUtils.validateParquet(!schema.isEmpty(), "Empty Parquet schema in file: %s", id);
        if (!encryptedFooter && fileDecryptor.isPresent()) {
            if (!fileMetaData.isSetEncryption_algorithm()) {
                fileDecryptor.get().setPlaintextFile();
                if (!fileDecryptor.get().plaintextFilesAllowed()) {
                    throw new ParquetCryptoRuntimeException("Applying decryptor on plaintext file");
                }
            } else {
                fileDecryptor.get().setFileCryptoMetaData(fileMetaData.getEncryption_algorithm(), false, fileMetaData.getFooter_signing_key_metadata());
                if (fileDecryptor.get().checkFooterIntegrity()) {
                    MetadataReader.verifyFooterIntegrity(input, fileDecryptor.get(), metadataLength);
                }
            }
        }
        MessageType messageType = MetadataReader.readParquetSchema(schema);
        ArrayList<BlockMetaData> blocks = new ArrayList<BlockMetaData>();
        List rowGroups = fileMetaData.getRow_groups();
        if (rowGroups != null) {
            for (RowGroup rowGroup : rowGroups) {
                BlockMetaData blockMetaData = new BlockMetaData();
                blockMetaData.setRowCount(rowGroup.getNum_rows());
                blockMetaData.setTotalByteSize(rowGroup.getTotal_byte_size());
                List columns = rowGroup.getColumns();
                ParquetValidationUtils.validateParquet(!columns.isEmpty(), "No columns in row group: %s", rowGroup);
                String filePath = ((ColumnChunk)columns.get(0)).getFile_path();
                int columnOrdinal = -1;
                for (ColumnChunk columnChunk : columns) {
                    ++columnOrdinal;
                    ParquetValidationUtils.validateParquet(filePath == null && columnChunk.getFile_path() == null || filePath != null && filePath.equals(columnChunk.getFile_path()), "all column chunks of the same row group must be in the same file", new Object[0]);
                    ColumnMetaData metaData = columnChunk.meta_data;
                    ColumnCryptoMetaData cryptoMetaData = columnChunk.getCrypto_metadata();
                    ColumnPath columnPath = null;
                    boolean encryptedMetadata = false;
                    if (null == cryptoMetaData) {
                        columnPath = MetadataReader.getPath(metaData);
                        if (fileDecryptor.isPresent() && !fileDecryptor.get().plaintextFile()) {
                            fileDecryptor.get().setColumnCryptoMetadata(columnPath, false, false, (byte[])null, columnOrdinal);
                        }
                    } else if (cryptoMetaData.isSetENCRYPTION_WITH_FOOTER_KEY()) {
                        if (!encryptedFooter) {
                            throw new ParquetCryptoRuntimeException("Column encrypted with footer key in file with plaintext footer");
                        }
                        if (null == metaData) {
                            throw new ParquetCryptoRuntimeException("ColumnMetaData not set in Encryption with Footer key");
                        }
                        if (!fileDecryptor.isPresent()) {
                            throw new ParquetCryptoRuntimeException("Column encrypted with footer key: No keys available");
                        }
                        columnPath = MetadataReader.getPath(metaData);
                        fileDecryptor.get().setColumnCryptoMetadata(columnPath, true, true, (byte[])null, columnOrdinal);
                    } else {
                        try {
                            metaData = MetadataReader.decryptMetadata(rowGroup, cryptoMetaData, columnChunk, fileDecryptor.get(), columnOrdinal);
                            columnPath = MetadataReader.getPath(metaData);
                        }
                        catch (KeyAccessDeniedException e) {
                            HiddenColumnChunkMetaData column = new HiddenColumnChunkMetaData(columnPath, filePath);
                            blockMetaData.addColumn((ColumnChunkMetaData)column);
                            continue;
                        }
                    }
                    ColumnChunkMetaData column = MetadataReader.buildColumnChunkMetaData(metaData, columnPath, messageType.getType(columnPath.toArray()).asPrimitiveType());
                    column.setColumnIndexReference(MetadataReader.toColumnIndexReference(columnChunk));
                    column.setOffsetIndexReference(MetadataReader.toOffsetIndexReference(columnChunk));
                    blockMetaData.addColumn(column);
                }
                blockMetaData.setPath(filePath);
                blocks.add(blockMetaData);
            }
        }
        HashMap<String, String> keyValueMetaData = new HashMap<String, String>();
        List keyValueList = fileMetaData.getKey_value_metadata();
        if (keyValueList != null) {
            for (KeyValue keyValue : keyValueList) {
                keyValueMetaData.put(keyValue.key, keyValue.value);
            }
        }
        ParquetMetadata parquetMetadata = new ParquetMetadata(new FileMetaData(messageType, keyValueMetaData, fileMetaData.getCreated_by()), blocks);
        return new ParquetFileMetadata(parquetMetadata, Math.toIntExact(metadataLength), modificationTime);
    }

    private static ColumnMetaData decryptMetadata(RowGroup rowGroup, ColumnCryptoMetaData cryptoMetaData, ColumnChunk columnChunk, InternalFileDecryptor fileDecryptor, int columnOrdinal) {
        EncryptionWithColumnKey columnKeyStruct = cryptoMetaData.getENCRYPTION_WITH_COLUMN_KEY();
        List pathList = columnKeyStruct.getPath_in_schema();
        byte[] columnKeyMetadata = columnKeyStruct.getKey_metadata();
        ColumnPath columnPath = ColumnPath.get((String[])pathList.toArray(new String[pathList.size()]));
        byte[] encryptedMetadataBuffer = columnChunk.getEncrypted_column_metadata();
        InternalColumnDecryptionSetup columnDecryptionSetup = fileDecryptor.setColumnCryptoMetadata(columnPath, true, false, columnKeyMetadata, columnOrdinal);
        ByteArrayInputStream tempInputStream = new ByteArrayInputStream(encryptedMetadataBuffer);
        byte[] columnMetaDataAAD = AesCipher.createModuleAAD((byte[])fileDecryptor.getFileAAD(), (ModuleCipherFactory.ModuleType)ModuleCipherFactory.ModuleType.ColumnMetaData, (int)rowGroup.ordinal, (int)columnOrdinal, (int)-1);
        try {
            return Util.readColumnMetaData((InputStream)tempInputStream, (BlockCipher.Decryptor)columnDecryptionSetup.getMetaDataDecryptor(), (byte[])columnMetaDataAAD);
        }
        catch (IOException e) {
            throw new ParquetCryptoRuntimeException(columnPath + ". Failed to decrypt column metadata", (Throwable)e);
        }
    }

    public static ColumnChunkMetaData buildColumnChunkMetaData(ColumnMetaData metaData, ColumnPath columnPath, PrimitiveType type) {
        return ColumnChunkMetaData.get((ColumnPath)columnPath, (PrimitiveType)type, (CompressionCodecName)CompressionCodecName.fromParquet((CompressionCodec)metaData.codec), (EncodingStats)PARQUET_METADATA_CONVERTER.convertEncodingStats(metaData.encoding_stats), MetadataReader.readEncodings(metaData.encodings), MetadataReader.readStats(metaData.statistics, type.getPrimitiveTypeName()), (long)metaData.data_page_offset, (long)metaData.dictionary_page_offset, (long)metaData.num_values, (long)metaData.total_compressed_size, (long)metaData.total_uncompressed_size);
    }

    private static ColumnPath getPath(ColumnMetaData metaData) {
        String[] path = (String[])metaData.path_in_schema.stream().map(value -> value.toLowerCase(Locale.ENGLISH)).toArray(String[]::new);
        return ColumnPath.get((String[])path);
    }

    private static void verifyFooterIntegrity(BasicSliceInput from, InternalFileDecryptor fileDecryptor, int combinedFooterLength) {
        byte[] nonce = new byte[12];
        from.read(nonce);
        byte[] gcmTag = new byte[16];
        from.read(gcmTag);
        AesGcmEncryptor footerSigner = fileDecryptor.createSignedFooterEncryptor();
        int footerSignatureLength = 28;
        byte[] serializedFooter = new byte[combinedFooterLength - footerSignatureLength];
        from.setPosition(0L);
        from.read(serializedFooter, 0, serializedFooter.length);
        byte[] signedFooterAuthenticationData = AesCipher.createFooterAAD((byte[])fileDecryptor.getFileAAD());
        byte[] encryptedFooterBytes = footerSigner.encrypt(false, serializedFooter, nonce, signedFooterAuthenticationData);
        byte[] calculatedTag = new byte[16];
        System.arraycopy(encryptedFooterBytes, encryptedFooterBytes.length - 16, calculatedTag, 0, 16);
        if (!Arrays.equals(gcmTag, calculatedTag)) {
            throw new TagVerificationException("Signature mismatch in plaintext footer");
        }
    }

    private static MessageType readParquetSchema(List<SchemaElement> schema) {
        Iterator<SchemaElement> schemaIterator = schema.iterator();
        SchemaElement rootSchema = schemaIterator.next();
        Types.MessageTypeBuilder builder = Types.buildMessage();
        MetadataReader.readTypeSchema(builder, schemaIterator, rootSchema.getNum_children());
        return builder.named(rootSchema.name);
    }

    private static void readTypeSchema(Types.GroupBuilder<?> builder, Iterator<SchemaElement> schemaIterator, int typeCount) {
        for (int i = 0; i < typeCount; ++i) {
            Types.GroupBuilder typeBuilder;
            SchemaElement element = schemaIterator.next();
            if (element.type == null) {
                typeBuilder = builder.group(Type.Repetition.valueOf((String)element.repetition_type.name()));
                MetadataReader.readTypeSchema(typeBuilder, schemaIterator, element.num_children);
            } else {
                Types.PrimitiveBuilder primitiveBuilder = builder.primitive(MetadataReader.getTypeName(element.type), Type.Repetition.valueOf((String)element.repetition_type.name()));
                if (element.isSetType_length()) {
                    primitiveBuilder.length(element.type_length);
                }
                if (element.isSetPrecision()) {
                    primitiveBuilder.precision(element.precision);
                }
                if (element.isSetScale()) {
                    primitiveBuilder.scale(element.scale);
                }
                typeBuilder = primitiveBuilder;
            }
            if (element.isSetConverted_type()) {
                typeBuilder.as(MetadataReader.getOriginalType(element.converted_type));
            }
            if (element.isSetField_id()) {
                typeBuilder.id(element.field_id);
            }
            typeBuilder.named(element.name.toLowerCase(Locale.ENGLISH));
        }
    }

    public static Statistics<?> readStats(org.apache.parquet.format.Statistics statistics, PrimitiveType.PrimitiveTypeName type) {
        Statistics stats = Statistics.getStatsBasedOnType((PrimitiveType.PrimitiveTypeName)type);
        stats.setNumNulls(-1L);
        if (statistics != null) {
            if (statistics.isSetMax() && statistics.isSetMin()) {
                stats.setMinMaxFromBytes(statistics.min.array(), statistics.max.array());
            }
            if (statistics.isSetNull_count()) {
                stats.setNumNulls(statistics.null_count);
            }
        }
        return stats;
    }

    private static Set<org.apache.parquet.column.Encoding> readEncodings(List<Encoding> encodings) {
        HashSet<org.apache.parquet.column.Encoding> columnEncodings = new HashSet<org.apache.parquet.column.Encoding>();
        for (Encoding encoding : encodings) {
            columnEncodings.add(org.apache.parquet.column.Encoding.valueOf((String)encoding.name()));
        }
        return Collections.unmodifiableSet(columnEncodings);
    }

    private static PrimitiveType.PrimitiveTypeName getTypeName(Type type) {
        switch (type) {
            case BYTE_ARRAY: {
                return PrimitiveType.PrimitiveTypeName.BINARY;
            }
            case INT64: {
                return PrimitiveType.PrimitiveTypeName.INT64;
            }
            case INT32: {
                return PrimitiveType.PrimitiveTypeName.INT32;
            }
            case BOOLEAN: {
                return PrimitiveType.PrimitiveTypeName.BOOLEAN;
            }
            case FLOAT: {
                return PrimitiveType.PrimitiveTypeName.FLOAT;
            }
            case DOUBLE: {
                return PrimitiveType.PrimitiveTypeName.DOUBLE;
            }
            case INT96: {
                return PrimitiveType.PrimitiveTypeName.INT96;
            }
            case FIXED_LEN_BYTE_ARRAY: {
                return PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY;
            }
        }
        throw new IllegalArgumentException("Unknown type " + type);
    }

    private static OriginalType getOriginalType(ConvertedType type) {
        switch (type) {
            case UTF8: {
                return OriginalType.UTF8;
            }
            case MAP: {
                return OriginalType.MAP;
            }
            case MAP_KEY_VALUE: {
                return OriginalType.MAP_KEY_VALUE;
            }
            case LIST: {
                return OriginalType.LIST;
            }
            case ENUM: {
                return OriginalType.ENUM;
            }
            case DECIMAL: {
                return OriginalType.DECIMAL;
            }
            case DATE: {
                return OriginalType.DATE;
            }
            case TIME_MILLIS: {
                return OriginalType.TIME_MILLIS;
            }
            case TIMESTAMP_MICROS: {
                return OriginalType.TIMESTAMP_MICROS;
            }
            case TIMESTAMP_MILLIS: {
                return OriginalType.TIMESTAMP_MILLIS;
            }
            case INTERVAL: {
                return OriginalType.INTERVAL;
            }
            case INT_8: {
                return OriginalType.INT_8;
            }
            case INT_16: {
                return OriginalType.INT_16;
            }
            case INT_32: {
                return OriginalType.INT_32;
            }
            case INT_64: {
                return OriginalType.INT_64;
            }
            case UINT_8: {
                return OriginalType.UINT_8;
            }
            case UINT_16: {
                return OriginalType.UINT_16;
            }
            case UINT_32: {
                return OriginalType.UINT_32;
            }
            case UINT_64: {
                return OriginalType.UINT_64;
            }
            case JSON: {
                return OriginalType.JSON;
            }
            case BSON: {
                return OriginalType.BSON;
            }
        }
        throw new IllegalArgumentException("Unknown converted type " + type);
    }

    @Override
    public ParquetFileMetadata getParquetMetadata(ParquetDataSource parquetDataSource, long fileSize, boolean cacheable, long modificationTime, Optional<InternalFileDecryptor> fileDecryptor) throws IOException {
        return MetadataReader.readFooter(parquetDataSource, fileSize, modificationTime, fileDecryptor);
    }

    private static IndexReference toColumnIndexReference(ColumnChunk columnChunk) {
        if (columnChunk.isSetColumn_index_offset() && columnChunk.isSetColumn_index_length()) {
            return new IndexReference(columnChunk.getColumn_index_offset(), columnChunk.getColumn_index_length());
        }
        return null;
    }

    private static IndexReference toOffsetIndexReference(ColumnChunk columnChunk) {
        if (columnChunk.isSetOffset_index_offset() && columnChunk.isSetOffset_index_length()) {
            return new IndexReference(columnChunk.getOffset_index_offset(), columnChunk.getOffset_index_length());
        }
        return null;
    }

    public static Optional<Integer> findFirstNonHiddenColumnId(BlockMetaData block) {
        List columns = block.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            if (HiddenColumnChunkMetaData.isHiddenColumn((ColumnChunkMetaData)columns.get(i))) continue;
            return Optional.of(i);
        }
        return Optional.empty();
    }
}

