/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.rule;

import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.expressions.DefaultRowExpressionTraversalVisitor;
import com.facebook.presto.expressions.RowExpressionRewriter;
import com.facebook.presto.expressions.RowExpressionTreeRewriter;
import com.facebook.presto.parquet.ParquetTypeUtils;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorPlanOptimizer;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.TableHandle;
import com.facebook.presto.spi.VariableAllocator;
import com.facebook.presto.spi.plan.Assignments;
import com.facebook.presto.spi.plan.PlanNode;
import com.facebook.presto.spi.plan.PlanNodeIdAllocator;
import com.facebook.presto.spi.plan.PlanVisitor;
import com.facebook.presto.spi.plan.ProjectNode;
import com.facebook.presto.spi.plan.TableScanNode;
import com.facebook.presto.spi.relation.ConstantExpression;
import com.facebook.presto.spi.relation.ExpressionOptimizer;
import com.facebook.presto.spi.relation.RowExpression;
import com.facebook.presto.spi.relation.RowExpressionService;
import com.facebook.presto.spi.relation.RowExpressionVisitor;
import com.facebook.presto.spi.relation.SpecialFormExpression;
import com.facebook.presto.spi.relation.VariableReferenceExpression;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class ParquetDereferencePushDown
implements ConnectorPlanOptimizer {
    private final RowExpressionService rowExpressionService;

    public ParquetDereferencePushDown(RowExpressionService rowExpressionService) {
        this.rowExpressionService = Objects.requireNonNull(rowExpressionService, "rowExpressionService is null");
    }

    public PlanNode optimize(PlanNode maxSubplan, ConnectorSession session, VariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator) {
        return (PlanNode)maxSubplan.accept((PlanVisitor)new Visitor(session, variableAllocator, idAllocator), null);
    }

    protected abstract boolean isParquetDereferenceEnabled(ConnectorSession var1, TableHandle var2);

    protected abstract String getColumnName(ColumnHandle var1);

    protected abstract ColumnHandle createSubfieldColumnHandle(ColumnHandle var1, Subfield var2, Type var3, String var4);

    private Map<RowExpression, Subfield> extractDereferences(Map<String, ColumnHandle> baseColumnHandles, ConnectorSession session, ExpressionOptimizer expressionOptimizer, Set<RowExpression> expressions) {
        HashSet dereferenceAndVariableExpressions = new HashSet();
        expressions.forEach(e -> {
            Void cfr_ignored_0 = (Void)e.accept((RowExpressionVisitor)new ExtractDereferenceAndVariables(session, expressionOptimizer), (Object)dereferenceAndVariableExpressions);
        });
        List dereferences = dereferenceAndVariableExpressions.stream().filter(expression -> !ParquetDereferencePushDown.prefixExists(expression, dereferenceAndVariableExpressions)).filter(expression -> expression instanceof SpecialFormExpression && ((SpecialFormExpression)expression).getForm() == SpecialFormExpression.Form.DEREFERENCE).collect(Collectors.toList());
        return dereferences.stream().collect(Collectors.toMap(Function.identity(), dereference -> this.createNestedColumn(baseColumnHandles, (RowExpression)dereference, expressionOptimizer, session)));
    }

    private static boolean prefixExists(RowExpression expression, final Set<RowExpression> allExpressions) {
        final int[] referenceCount = new int[]{0};
        expression.accept((RowExpressionVisitor)new DefaultRowExpressionTraversalVisitor<int[]>(){

            public Void visitSpecialForm(SpecialFormExpression specialForm, int[] context) {
                if (specialForm.getForm() != SpecialFormExpression.Form.DEREFERENCE) {
                    return super.visitSpecialForm(specialForm, (Object)context);
                }
                if (allExpressions.contains(specialForm)) {
                    referenceCount[0] = referenceCount[0] + 1;
                }
                RowExpression base = (RowExpression)specialForm.getArguments().get(0);
                base.accept((RowExpressionVisitor)this, (Object)context);
                return null;
            }

            public Void visitVariableReference(VariableReferenceExpression reference, int[] context) {
                if (allExpressions.contains(reference)) {
                    referenceCount[0] = referenceCount[0] + 1;
                }
                return null;
            }
        }, (Object)referenceCount);
        return referenceCount[0] > 1;
    }

    private Subfield createNestedColumn(Map<String, ColumnHandle> baseColumnHandles, RowExpression rowExpression, ExpressionOptimizer expressionOptimizer, ConnectorSession session) {
        if (!(rowExpression instanceof SpecialFormExpression) || ((SpecialFormExpression)rowExpression).getForm() != SpecialFormExpression.Form.DEREFERENCE) {
            throw new IllegalArgumentException("expecting SpecialFormExpression(DEREFERENCE), but got: " + rowExpression);
        }
        RowExpression currentRowExpression = rowExpression;
        ArrayList<Subfield.NestedField> elements = new ArrayList<Subfield.NestedField>();
        while (true) {
            Optional fieldName;
            Object index;
            if (currentRowExpression instanceof VariableReferenceExpression) {
                Collections.reverse(elements);
                String name = ((VariableReferenceExpression)currentRowExpression).getName();
                ColumnHandle handle = baseColumnHandles.get(name);
                Preconditions.checkArgument((handle != null ? 1 : 0) != 0, (Object)("Missing Column handle: " + name));
                String originalColumnName = this.getColumnName(handle);
                return new Subfield(originalColumnName, Collections.unmodifiableList(elements));
            }
            if (!(currentRowExpression instanceof SpecialFormExpression) || ((SpecialFormExpression)currentRowExpression).getForm() != SpecialFormExpression.Form.DEREFERENCE) break;
            SpecialFormExpression dereferenceExpression = (SpecialFormExpression)currentRowExpression;
            RowExpression base = (RowExpression)dereferenceExpression.getArguments().get(0);
            RowType baseType = (RowType)base.getType();
            RowExpression indexExpression = expressionOptimizer.optimize((RowExpression)dereferenceExpression.getArguments().get(1), ExpressionOptimizer.Level.OPTIMIZED, session);
            if (!(indexExpression instanceof ConstantExpression) || !((index = ((ConstantExpression)indexExpression).getValue()) instanceof Number) || !(fieldName = ((RowType.Field)baseType.getFields().get(((Number)index).intValue())).getName()).isPresent()) break;
            elements.add(new Subfield.NestedField((String)fieldName.get()));
            currentRowExpression = base;
        }
        throw new IllegalArgumentException("expecting SpecialFormExpression(DEREFERENCE) with constants for indices, but got: " + currentRowExpression);
    }

    private class Visitor
    extends PlanVisitor<PlanNode, Void> {
        private final ConnectorSession session;
        private final VariableAllocator variableAllocator;
        private final PlanNodeIdAllocator idAllocator;

        Visitor(ConnectorSession session, VariableAllocator variableAllocator, PlanNodeIdAllocator idAllocator) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.variableAllocator = Objects.requireNonNull(variableAllocator, "variableAllocator is null");
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
        }

        public PlanNode visitPlan(PlanNode node, Void context) {
            ImmutableList.Builder children = ImmutableList.builder();
            boolean changed = false;
            for (PlanNode child : node.getSources()) {
                PlanNode newChild = (PlanNode)child.accept((PlanVisitor)this, null);
                if (newChild != child) {
                    changed = true;
                }
                children.add((Object)newChild);
            }
            if (!changed) {
                return node;
            }
            return node.replaceChildren((List)children.build());
        }

        public PlanNode visitProject(ProjectNode project, Void context) {
            if (!(project.getSource() instanceof TableScanNode)) {
                return this.visitPlan((PlanNode)project, context);
            }
            TableScanNode tableScan = (TableScanNode)project.getSource();
            if (!ParquetDereferencePushDown.this.isParquetDereferenceEnabled(this.session, tableScan.getTable())) {
                return this.visitPlan((PlanNode)project, context);
            }
            HashMap baseColumnHandles = new HashMap();
            tableScan.getAssignments().entrySet().forEach(assignment -> {
                baseColumnHandles.put(((VariableReferenceExpression)assignment.getKey()).getName(), assignment.getValue());
                baseColumnHandles.put(ParquetDereferencePushDown.this.getColumnName((ColumnHandle)assignment.getValue()), assignment.getValue());
            });
            Map dereferenceToNestedColumnMap = ParquetDereferencePushDown.this.extractDereferences(baseColumnHandles, this.session, ParquetDereferencePushDown.this.rowExpressionService.getExpressionOptimizer(), new HashSet(project.getAssignments().getExpressions()));
            if (dereferenceToNestedColumnMap.isEmpty()) {
                return this.visitPlan((PlanNode)project, context);
            }
            ArrayList<VariableReferenceExpression> newOutputVariables = new ArrayList<VariableReferenceExpression>(tableScan.getOutputVariables());
            HashMap<VariableReferenceExpression, ColumnHandle> newAssignments = new HashMap<VariableReferenceExpression, ColumnHandle>(tableScan.getAssignments());
            HashMap<RowExpression, VariableReferenceExpression> dereferenceToVariableMap = new HashMap<RowExpression, VariableReferenceExpression>();
            for (Map.Entry dereference : dereferenceToNestedColumnMap.entrySet()) {
                Subfield subfield = (Subfield)dereference.getValue();
                RowExpression dereferenceExpression = (RowExpression)dereference.getKey();
                ColumnHandle baseColumnHandle = (ColumnHandle)baseColumnHandles.get(subfield.getRootName());
                if (baseColumnHandle == null) {
                    throw new IllegalArgumentException("Subfield column [" + subfield + "]'s base column " + subfield.getRootName() + " is not present in table scan output");
                }
                String subfieldColumnName = ParquetTypeUtils.pushdownColumnNameForSubfield(subfield);
                ColumnHandle nestedColumnHandle = ParquetDereferencePushDown.this.createSubfieldColumnHandle(baseColumnHandle, subfield, dereferenceExpression.getType(), subfieldColumnName);
                VariableReferenceExpression newOutputVariable = this.variableAllocator.newVariable(subfieldColumnName, dereferenceExpression.getType());
                newOutputVariables.add(newOutputVariable);
                newAssignments.put(newOutputVariable, nestedColumnHandle);
                dereferenceToVariableMap.put(dereferenceExpression, newOutputVariable);
            }
            TableScanNode newTableScan = new TableScanNode(tableScan.getSourceLocation(), this.idAllocator.getNextId(), tableScan.getTable(), newOutputVariables, newAssignments, tableScan.getTableConstraints(), tableScan.getCurrentConstraint(), tableScan.getEnforcedConstraint());
            Assignments.Builder newProjectAssignmentBuilder = Assignments.builder();
            for (Map.Entry entry : project.getAssignments().entrySet()) {
                RowExpression newExpression = RowExpressionTreeRewriter.rewriteWith((RowExpressionRewriter)new DereferenceExpressionRewriter(dereferenceToVariableMap), (RowExpression)((RowExpression)entry.getValue()));
                newProjectAssignmentBuilder.put((VariableReferenceExpression)entry.getKey(), newExpression);
            }
            return new ProjectNode(tableScan.getSourceLocation(), this.idAllocator.getNextId(), (PlanNode)newTableScan, newProjectAssignmentBuilder.build(), project.getLocality());
        }
    }

    private static class DereferenceExpressionRewriter
    extends RowExpressionRewriter<Void> {
        private final Map<RowExpression, VariableReferenceExpression> dereferenceMap;

        public DereferenceExpressionRewriter(Map<RowExpression, VariableReferenceExpression> dereferenceMap) {
            this.dereferenceMap = dereferenceMap;
        }

        public RowExpression rewriteSpecialForm(SpecialFormExpression node, Void context, RowExpressionTreeRewriter<Void> treeRewriter) {
            return (RowExpression)this.dereferenceMap.get(node);
        }
    }

    private static class ExtractDereferenceAndVariables
    extends DefaultRowExpressionTraversalVisitor<Set<RowExpression>> {
        private final ConnectorSession connectorSession;
        private final ExpressionOptimizer expressionOptimizer;

        public ExtractDereferenceAndVariables(ConnectorSession connectorSession, ExpressionOptimizer expressionOptimizer) {
            this.connectorSession = connectorSession;
            this.expressionOptimizer = expressionOptimizer;
        }

        public Void visitSpecialForm(SpecialFormExpression specialForm, Set<RowExpression> context) {
            if (specialForm.getForm() != SpecialFormExpression.Form.DEREFERENCE) {
                return super.visitSpecialForm(specialForm, context);
            }
            SpecialFormExpression expression = specialForm;
            while (true) {
                Optional fieldName;
                Object index;
                if (expression instanceof VariableReferenceExpression) {
                    context.add((RowExpression)specialForm);
                    return null;
                }
                if (!(expression instanceof SpecialFormExpression) || expression.getForm() != SpecialFormExpression.Form.DEREFERENCE) break;
                SpecialFormExpression dereferenceExpression = expression;
                RowExpression base = (RowExpression)dereferenceExpression.getArguments().get(0);
                RowType baseType = (RowType)base.getType();
                RowExpression indexExpression = this.expressionOptimizer.optimize((RowExpression)dereferenceExpression.getArguments().get(1), ExpressionOptimizer.Level.OPTIMIZED, this.connectorSession);
                if (!(indexExpression instanceof ConstantExpression) || !((index = ((ConstantExpression)indexExpression).getValue()) instanceof Number) || !(fieldName = ((RowType.Field)baseType.getFields().get(((Number)index).intValue())).getName()).isPresent()) break;
                expression = base;
            }
            return super.visitSpecialForm(specialForm, context);
        }

        public Void visitVariableReference(VariableReferenceExpression reference, Set<RowExpression> context) {
            context.add((RowExpression)reference);
            return null;
        }
    }
}

