/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.writer;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.ColumnarArray;
import com.facebook.presto.parquet.writer.ColumnChunk;
import com.facebook.presto.parquet.writer.ColumnWriter;
import com.facebook.presto.parquet.writer.levels.DefinitionLevelIterable;
import com.facebook.presto.parquet.writer.levels.DefinitionLevelIterables;
import com.facebook.presto.parquet.writer.levels.RepetitionLevelIterable;
import com.facebook.presto.parquet.writer.levels.RepetitionLevelIterables;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class ArrayColumnWriter
implements ColumnWriter {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(ArrayColumnWriter.class).instanceSize();
    private final ColumnWriter elementWriter;
    private final int maxDefinitionLevel;
    private final int maxRepetitionLevel;

    public ArrayColumnWriter(ColumnWriter elementWriter, int maxDefinitionLevel, int maxRepetitionLevel) {
        this.elementWriter = Objects.requireNonNull(elementWriter, "elementWriter is null");
        this.maxDefinitionLevel = maxDefinitionLevel;
        this.maxRepetitionLevel = maxRepetitionLevel;
    }

    @Override
    public void writeBlock(ColumnChunk columnChunk) throws IOException {
        ColumnarArray columnarArray = ColumnarArray.toColumnarArray((Block)columnChunk.getBlock());
        this.elementWriter.writeBlock(new ColumnChunk(columnarArray.getElementsBlock(), (List<DefinitionLevelIterable>)ImmutableList.builder().addAll(columnChunk.getDefinitionLevelIterables()).add((Object)DefinitionLevelIterables.of(columnarArray, this.maxDefinitionLevel)).build(), (List<RepetitionLevelIterable>)ImmutableList.builder().addAll(columnChunk.getRepetitionLevelIterables()).add((Object)RepetitionLevelIterables.of(columnarArray, this.maxRepetitionLevel)).build()));
    }

    @Override
    public void close() {
        this.elementWriter.close();
    }

    @Override
    public List<ColumnWriter.BufferData> getBuffer() throws IOException {
        return ImmutableList.copyOf(this.elementWriter.getBuffer());
    }

    @Override
    public long getBufferedBytes() {
        return this.elementWriter.getBufferedBytes();
    }

    @Override
    public long getRetainedBytes() {
        return (long)INSTANCE_SIZE + this.elementWriter.getRetainedBytes();
    }

    @Override
    public void reset() {
        this.elementWriter.reset();
    }
}

