/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.batchreader.decoders.rle;

import com.facebook.presto.parquet.batchreader.decoders.ValuesDecoder;
import com.facebook.presto.parquet.batchreader.decoders.rle.BaseRLEBitPackedDecoder;
import com.facebook.presto.parquet.batchreader.dictionary.BinaryBatchDictionary;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import org.apache.parquet.io.ParquetDecodingException;

public class BinaryRLEDictionaryValuesDecoder
extends BaseRLEBitPackedDecoder
implements ValuesDecoder.BinaryValuesDecoder {
    private final BinaryBatchDictionary dictionary;

    public BinaryRLEDictionaryValuesDecoder(int bitWidth, InputStream inputStream, BinaryBatchDictionary dictionary) {
        super(Integer.MAX_VALUE, bitWidth, inputStream);
        this.dictionary = dictionary;
    }

    @Override
    public ValuesDecoder.BinaryValuesDecoder.ValueBuffer readNext(int length) throws IOException {
        int remainingToCopy;
        int numEntriesToFill;
        int[] dictionaries = new int[length];
        int destinationIndex = 0;
        int bufferSize = 0;
        for (remainingToCopy = length; remainingToCopy > 0 && (this.currentCount != 0 || this.decode()); remainingToCopy -= numEntriesToFill) {
            numEntriesToFill = Math.min(remainingToCopy, this.currentCount);
            int endIndex = destinationIndex + numEntriesToFill;
            switch (this.mode) {
                case RLE: {
                    int rleValue = this.currentValue;
                    int rleValueLength = this.dictionary.getLength(rleValue);
                    while (destinationIndex < endIndex) {
                        dictionaries[destinationIndex++] = rleValue;
                    }
                    bufferSize += rleValueLength * numEntriesToFill;
                    break;
                }
                case PACKED: {
                    int[] localBuffer = this.currentBuffer;
                    BinaryBatchDictionary localDictionary = this.dictionary;
                    int srcIndex = this.currentBuffer.length - this.currentCount;
                    while (destinationIndex < endIndex) {
                        int dictionaryId;
                        dictionaries[destinationIndex] = dictionaryId = localBuffer[srcIndex];
                        bufferSize += localDictionary.getLength(dictionaryId);
                        ++srcIndex;
                        ++destinationIndex;
                    }
                    break;
                }
                default: {
                    throw new ParquetDecodingException("not a valid mode " + (Object)((Object)this.mode));
                }
            }
            this.currentCount -= numEntriesToFill;
        }
        Preconditions.checkState((remainingToCopy == 0 ? 1 : 0) != 0, (Object)"Invalid read size request");
        return new RLEValueBuffer(bufferSize, dictionaries);
    }

    @Override
    public int readIntoBuffer(byte[] byteBuffer, int bufferIndex, int[] offsets, int offsetIndex, ValuesDecoder.BinaryValuesDecoder.ValueBuffer valueBuffer) {
        Preconditions.checkArgument((byteBuffer.length - bufferIndex >= valueBuffer.getBufferSize() ? 1 : 0) != 0, (Object)"not enough space in the input buffer");
        RLEValueBuffer rleValueBuffer = (RLEValueBuffer)valueBuffer;
        int[] dictionaryIds = rleValueBuffer.getDictionaryIds();
        int numEntries = dictionaryIds.length;
        for (int i = 0; i < numEntries; ++i) {
            offsets[offsetIndex++] = bufferIndex;
            bufferIndex += this.dictionary.copyTo(byteBuffer, bufferIndex, dictionaryIds[i]);
        }
        offsets[offsetIndex] = bufferIndex;
        return bufferIndex;
    }

    @Override
    public void skip(int length) throws IOException {
        int remaining;
        int chunkSize;
        for (remaining = length; remaining > 0 && (this.currentCount != 0 || this.decode()); remaining -= chunkSize) {
            chunkSize = Math.min(remaining, this.currentCount);
            this.currentCount -= chunkSize;
        }
        Preconditions.checkState((remaining == 0 ? 1 : 0) != 0, (Object)"Invalid read size request");
    }

    public static class RLEValueBuffer
    implements ValuesDecoder.BinaryValuesDecoder.ValueBuffer {
        private final int bufferSize;
        private final int[] dictionaryIds;

        public RLEValueBuffer(int bufferSize, int[] dictionaryIds) {
            this.bufferSize = bufferSize;
            this.dictionaryIds = dictionaryIds;
        }

        @Override
        public int getBufferSize() {
            return this.bufferSize;
        }

        public int[] getDictionaryIds() {
            return this.dictionaryIds;
        }
    }
}

