/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.reader;

import com.facebook.presto.parquet.ParquetDataSource;
import com.facebook.presto.parquet.RichColumnDescriptor;
import com.facebook.presto.parquet.predicate.Predicate;
import com.facebook.presto.parquet.predicate.TupleDomainParquetPredicate;
import com.facebook.presto.parquet.reader.ParquetColumnIndexStore;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.internal.column.columnindex.OffsetIndex;
import org.apache.parquet.internal.filter2.columnindex.ColumnIndexStore;
import org.apache.parquet.internal.filter2.columnindex.RowRanges;

public class ColumnIndexFilterUtils {
    private ColumnIndexFilterUtils() {
    }

    static OffsetIndex filterOffsetIndex(OffsetIndex offsetIndex, RowRanges rowRanges, long totalRowCount) {
        IntArrayList indices = new IntArrayList();
        for (int i = 0; i < offsetIndex.getPageCount(); ++i) {
            long from = offsetIndex.getFirstRowIndex(i);
            if (!rowRanges.isOverlapping(from, offsetIndex.getLastRowIndex(i, totalRowCount))) continue;
            indices.add(i);
        }
        return new FilteredOffsetIndex(offsetIndex, indices.toIntArray());
    }

    static List<OffsetRange> calculateOffsetRanges(OffsetIndex offsetIndex, ColumnChunkMetaData columnChunkMetadata, long firstPageOffset, long startingPosition) {
        ArrayList<OffsetRange> ranges = new ArrayList<OffsetRange>();
        int pageCount = offsetIndex.getPageCount();
        if (pageCount > 0) {
            OffsetRange currentRange = null;
            long rowGroupOffset = columnChunkMetadata.getStartingPos();
            if (rowGroupOffset < firstPageOffset) {
                currentRange = new OffsetRange(rowGroupOffset - startingPosition, (int)(firstPageOffset - rowGroupOffset));
                ranges.add(currentRange);
            }
            for (int i = 0; i < pageCount; ++i) {
                long offset = offsetIndex.getOffset(i);
                int length = offsetIndex.getCompressedPageSize(i);
                if (currentRange != null && currentRange.extendWithCheck(offset - startingPosition, length)) continue;
                currentRange = new OffsetRange(offset - startingPosition, length);
                ranges.add(currentRange);
            }
        }
        return ranges;
    }

    public static Optional<ColumnIndexStore> getColumnIndexStore(Predicate parquetPredicate, ParquetDataSource dataSource, BlockMetaData blockMetadata, Map<List<String>, RichColumnDescriptor> descriptorsByPath, boolean columnIndexFilterEnabled) {
        if (!columnIndexFilterEnabled || parquetPredicate == null || !(parquetPredicate instanceof TupleDomainParquetPredicate)) {
            return Optional.empty();
        }
        for (ColumnChunkMetaData column : blockMetadata.getColumns()) {
            if (column.getColumnIndexReference() == null || column.getOffsetIndexReference() == null) continue;
            HashSet<ColumnPath> paths = new HashSet<ColumnPath>();
            for (List<String> path : descriptorsByPath.keySet()) {
                paths.add(ColumnPath.get((String[])path.toArray(new String[0])));
            }
            return Optional.of(ParquetColumnIndexStore.create(dataSource, blockMetadata, paths));
        }
        return Optional.empty();
    }

    private static class FilteredOffsetIndex
    implements OffsetIndex {
        private final OffsetIndex offsetIndex;
        private final int[] indices;

        private FilteredOffsetIndex(OffsetIndex offsetIndex, int[] indices) {
            this.offsetIndex = offsetIndex;
            this.indices = indices;
        }

        public int getPageCount() {
            return this.indices.length;
        }

        public long getOffset(int pageIndex) {
            return this.offsetIndex.getOffset(this.indices[pageIndex]);
        }

        public int getCompressedPageSize(int pageIndex) {
            return this.offsetIndex.getCompressedPageSize(this.indices[pageIndex]);
        }

        public long getFirstRowIndex(int pageIndex) {
            return this.offsetIndex.getFirstRowIndex(this.indices[pageIndex]);
        }

        public long getLastRowIndex(int pageIndex, long totalRowCount) {
            int nextIndex = this.indices[pageIndex] + 1;
            return (nextIndex >= this.offsetIndex.getPageCount() ? totalRowCount : this.offsetIndex.getFirstRowIndex(nextIndex)) - 1L;
        }

        public String toString() {
            try (Formatter formatter = new Formatter();){
                formatter.format("%-12s  %20s  %16s  %20s%n", "", "offset", "compressed size", "first row index");
                int n = this.offsetIndex.getPageCount();
                for (int i = 0; i < n; ++i) {
                    int index = Arrays.binarySearch(this.indices, i);
                    boolean isHidden = index < 0;
                    formatter.format("%spage-%-5d  %20d  %16d  %20d%n", isHidden ? "- " : "  ", isHidden ? i : index, this.offsetIndex.getOffset(i), this.offsetIndex.getCompressedPageSize(i), this.offsetIndex.getFirstRowIndex(i));
                }
                String string = formatter.toString();
                return string;
            }
        }
    }

    static class OffsetRange {
        private final long offset;
        private long length;

        public OffsetRange(long offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        long getOffset() {
            return this.offset;
        }

        long getLength() {
            return this.length;
        }

        private boolean extendWithCheck(long offset, int length) {
            if (this.offset + this.length == offset) {
                this.length += (long)length;
                return true;
            }
            return false;
        }

        public void extendLength(long length) {
            this.length += length;
        }

        public long endPos() {
            return this.offset + this.length;
        }
    }
}

