/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.reader;

import com.facebook.presto.parquet.DataPage;
import com.facebook.presto.parquet.DataPageV1;
import com.facebook.presto.parquet.DataPageV2;
import com.facebook.presto.parquet.DictionaryPage;
import com.facebook.presto.parquet.ParquetCompressionUtils;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Optional;
import org.apache.parquet.crypto.AesCipher;
import org.apache.parquet.crypto.ModuleCipherFactory;
import org.apache.parquet.format.BlockCipher;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.internal.column.columnindex.OffsetIndex;

public class PageReader {
    private final long valueCount;
    private final LinkedList<DataPage> compressedPages;
    private final DictionaryPage compressedDictionaryPage;
    private final OffsetIndex offsetIndex;
    private final Optional<BlockCipher.Decryptor> blockDecryptor;
    private int pageIndex;
    private byte[] dataPageAdditionalAuthenticationData;
    private byte[] dictionaryPageAdditionalAuthenticationData;
    protected final CompressionCodecName codec;

    public PageReader(CompressionCodecName codec, LinkedList<DataPage> compressedPages, DictionaryPage compressedDictionaryPage) throws IOException {
        this(codec, compressedPages, compressedDictionaryPage, null, Optional.empty(), null, -1, -1);
    }

    public PageReader(CompressionCodecName codec, LinkedList<DataPage> compressedPages, DictionaryPage compressedDictionaryPage, OffsetIndex offsetIndex, Optional<BlockCipher.Decryptor> blockDecryptor, byte[] fileAdditionalAuthenticationData, int rowGroupOrdinal, int columnOrdinal) {
        this.codec = codec;
        this.compressedPages = compressedPages;
        this.compressedDictionaryPage = compressedDictionaryPage;
        int count = 0;
        for (DataPage page : compressedPages) {
            count += page.getValueCount();
        }
        this.valueCount = count;
        this.offsetIndex = offsetIndex;
        this.pageIndex = 0;
        this.blockDecryptor = blockDecryptor;
        if (blockDecryptor.isPresent()) {
            this.dataPageAdditionalAuthenticationData = AesCipher.createModuleAAD((byte[])fileAdditionalAuthenticationData, (ModuleCipherFactory.ModuleType)ModuleCipherFactory.ModuleType.DataPage, (int)rowGroupOrdinal, (int)columnOrdinal, (int)0);
            this.dictionaryPageAdditionalAuthenticationData = AesCipher.createModuleAAD((byte[])fileAdditionalAuthenticationData, (ModuleCipherFactory.ModuleType)ModuleCipherFactory.ModuleType.DictionaryPage, (int)rowGroupOrdinal, (int)columnOrdinal, (int)-1);
        }
    }

    public long getTotalValueCount() {
        return this.valueCount;
    }

    public DataPage readPage() {
        if (this.compressedPages.isEmpty()) {
            return null;
        }
        if (this.blockDecryptor.isPresent()) {
            AesCipher.quickUpdatePageAAD((byte[])this.dataPageAdditionalAuthenticationData, (int)this.pageIndex);
        }
        DataPage compressedPage = this.compressedPages.remove(0);
        try {
            Slice slice = this.decryptSliceIfNeeded(compressedPage.getSlice(), this.dataPageAdditionalAuthenticationData);
            long firstRowIndex = PageReader.getFirstRowIndex(this.pageIndex, this.offsetIndex);
            ++this.pageIndex;
            if (compressedPage instanceof DataPageV1) {
                DataPageV1 dataPageV1 = (DataPageV1)compressedPage;
                slice = ParquetCompressionUtils.decompress(this.codec, slice, dataPageV1.getUncompressedSize());
                return new DataPageV1(slice, dataPageV1.getValueCount(), dataPageV1.getUncompressedSize(), firstRowIndex, dataPageV1.getStatistics(), dataPageV1.getRepetitionLevelEncoding(), dataPageV1.getDefinitionLevelEncoding(), dataPageV1.getValueEncoding());
            }
            DataPageV2 dataPageV2 = (DataPageV2)compressedPage;
            if (!dataPageV2.isCompressed()) {
                return dataPageV2;
            }
            int uncompressedSize = Math.toIntExact(dataPageV2.getUncompressedSize() - dataPageV2.getDefinitionLevels().length() - dataPageV2.getRepetitionLevels().length());
            slice = ParquetCompressionUtils.decompress(this.codec, slice, uncompressedSize);
            return new DataPageV2(dataPageV2.getRowCount(), dataPageV2.getNullCount(), dataPageV2.getValueCount(), firstRowIndex, dataPageV2.getRepetitionLevels(), dataPageV2.getDefinitionLevels(), dataPageV2.getDataEncoding(), slice, dataPageV2.getUncompressedSize(), dataPageV2.getStatistics(), false);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not decompress page", e);
        }
    }

    public DictionaryPage readDictionaryPage() {
        if (this.compressedDictionaryPage == null) {
            return null;
        }
        try {
            Slice slice = this.decryptSliceIfNeeded(this.compressedDictionaryPage.getSlice(), this.dictionaryPageAdditionalAuthenticationData);
            return new DictionaryPage(ParquetCompressionUtils.decompress(this.codec, slice, this.compressedDictionaryPage.getUncompressedSize()), this.compressedDictionaryPage.getDictionarySize(), this.compressedDictionaryPage.getEncoding());
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading dictionary page", e);
        }
    }

    public static long getFirstRowIndex(int pageIndex, OffsetIndex offsetIndex) {
        return offsetIndex == null ? -1L : offsetIndex.getFirstRowIndex(pageIndex);
    }

    private Slice decryptSliceIfNeeded(Slice slice, byte[] additionalAuthenticationData) throws IOException {
        if (!this.blockDecryptor.isPresent()) {
            return slice;
        }
        byte[] plainText = this.blockDecryptor.get().decrypt(slice.getBytes(), additionalAuthenticationData);
        return Slices.wrappedBuffer((byte[])plainText);
    }
}

