/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.reader;

import com.facebook.presto.parquet.DataPage;
import com.facebook.presto.parquet.DataPageV1;
import com.facebook.presto.parquet.DataPageV2;
import com.facebook.presto.parquet.DictionaryPage;
import com.facebook.presto.parquet.ParquetCorruptionException;
import com.facebook.presto.parquet.ParquetTypeUtils;
import com.facebook.presto.parquet.cache.MetadataReader;
import com.facebook.presto.parquet.reader.ColumnChunkDescriptor;
import com.facebook.presto.parquet.reader.PageReader;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.EncodingStats;
import org.apache.parquet.crypto.AesCipher;
import org.apache.parquet.crypto.InternalColumnDecryptionSetup;
import org.apache.parquet.crypto.InternalFileDecryptor;
import org.apache.parquet.crypto.ModuleCipherFactory;
import org.apache.parquet.format.BlockCipher;
import org.apache.parquet.format.DataPageHeader;
import org.apache.parquet.format.DataPageHeaderV2;
import org.apache.parquet.format.DictionaryPageHeader;
import org.apache.parquet.format.PageHeader;
import org.apache.parquet.format.Util;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.internal.column.columnindex.OffsetIndex;

public class ParquetColumnChunk {
    private final ColumnChunkDescriptor descriptor;
    private final ByteBufferInputStream stream;
    private final OffsetIndex offsetIndex;

    public ParquetColumnChunk(ColumnChunkDescriptor descriptor, byte[] data, int offset) {
        this.stream = ByteBufferInputStream.wrap((ByteBuffer[])new ByteBuffer[]{ByteBuffer.wrap(data, offset, data.length - offset)});
        this.descriptor = descriptor;
        this.offsetIndex = null;
    }

    public ParquetColumnChunk(ColumnChunkDescriptor descriptor, List<ByteBuffer> data, OffsetIndex offsetIndex) {
        this.stream = ByteBufferInputStream.wrap(data);
        this.descriptor = descriptor;
        this.offsetIndex = offsetIndex;
    }

    public ColumnChunkDescriptor getDescriptor() {
        return this.descriptor;
    }

    protected PageHeader readPageHeader(BlockCipher.Decryptor headerBlockDecryptor, byte[] pageHeaderAadditionalAuthenticationData) throws IOException {
        return Util.readPageHeader((InputStream)this.stream, (BlockCipher.Decryptor)headerBlockDecryptor, (byte[])pageHeaderAadditionalAuthenticationData);
    }

    public PageReader readAllPages(Optional<InternalFileDecryptor> fileDecryptor, int rowGroupOrdinal, int columnOrdinal) throws IOException {
        LinkedList<DataPage> pages = new LinkedList<DataPage>();
        DictionaryPage dictionaryPage = null;
        long valueCount = 0L;
        int dataPageCount = 0;
        int pageOrdinal = 0;
        byte[] dataPageHeaderAdditionalAuthenticationData = null;
        BlockCipher.Decryptor headerBlockDecryptor = null;
        InternalColumnDecryptionSetup columnDecryptionSetup = null;
        if (fileDecryptor.isPresent()) {
            ColumnPath columnPath = ColumnPath.get((String[])this.descriptor.getColumnDescriptor().getPath());
            columnDecryptionSetup = fileDecryptor.get().getColumnSetup(columnPath);
            headerBlockDecryptor = columnDecryptionSetup.getMetaDataDecryptor();
            if (headerBlockDecryptor != null) {
                dataPageHeaderAdditionalAuthenticationData = AesCipher.createModuleAAD((byte[])fileDecryptor.get().getFileAAD(), (ModuleCipherFactory.ModuleType)ModuleCipherFactory.ModuleType.DataPageHeader, (int)rowGroupOrdinal, (int)columnOrdinal, (int)pageOrdinal);
            }
        }
        block5: while (this.hasMorePages(valueCount, dataPageCount)) {
            byte[] pageHeaderAadditionalAuthenticationData = dataPageHeaderAdditionalAuthenticationData;
            if (headerBlockDecryptor != null) {
                if (dictionaryPage == null && this.hasDictionaryPage(this.descriptor.getColumnChunkMetaData())) {
                    pageHeaderAadditionalAuthenticationData = AesCipher.createModuleAAD((byte[])fileDecryptor.get().getFileAAD(), (ModuleCipherFactory.ModuleType)ModuleCipherFactory.ModuleType.DictionaryPageHeader, (int)rowGroupOrdinal, (int)columnOrdinal, (int)-1);
                } else {
                    AesCipher.quickUpdatePageAAD(dataPageHeaderAdditionalAuthenticationData, (int)pageOrdinal);
                }
            }
            PageHeader pageHeader = this.readPageHeader(headerBlockDecryptor, pageHeaderAadditionalAuthenticationData);
            int uncompressedPageSize = pageHeader.getUncompressed_page_size();
            int compressedPageSize = pageHeader.getCompressed_page_size();
            long firstRowIndex = -1L;
            switch (pageHeader.type) {
                case DICTIONARY_PAGE: {
                    if (dictionaryPage != null) {
                        throw new ParquetCorruptionException("%s has more than one dictionary page in column chunk", this.descriptor.getColumnDescriptor());
                    }
                    dictionaryPage = this.readDictionaryPage(pageHeader, uncompressedPageSize, compressedPageSize);
                    continue block5;
                }
                case DATA_PAGE: {
                    firstRowIndex = PageReader.getFirstRowIndex(dataPageCount, this.offsetIndex);
                    valueCount += this.readDataPageV1(pageHeader, uncompressedPageSize, compressedPageSize, firstRowIndex, pages);
                    ++dataPageCount;
                    ++pageOrdinal;
                    continue block5;
                }
                case DATA_PAGE_V2: {
                    firstRowIndex = PageReader.getFirstRowIndex(dataPageCount, this.offsetIndex);
                    valueCount += this.readDataPageV2(pageHeader, uncompressedPageSize, compressedPageSize, firstRowIndex, pages);
                    ++dataPageCount;
                    ++pageOrdinal;
                    continue block5;
                }
            }
            this.stream.skipFully((long)compressedPageSize);
        }
        byte[] fileAdditionalAuthenticationData = fileDecryptor.isPresent() ? fileDecryptor.get().getFileAAD() : null;
        Optional<BlockCipher.Decryptor> dataDecryptor = this.getDataDecryptor(columnDecryptionSetup);
        return new PageReader(this.descriptor.getColumnChunkMetaData().getCodec(), pages, dictionaryPage, this.offsetIndex, dataDecryptor, fileAdditionalAuthenticationData, rowGroupOrdinal, columnOrdinal);
    }

    private Optional<BlockCipher.Decryptor> getDataDecryptor(InternalColumnDecryptionSetup columnDecryptionSetup) {
        if (columnDecryptionSetup == null || columnDecryptionSetup.getDataDecryptor() == null) {
            return Optional.empty();
        }
        return Optional.of(columnDecryptionSetup.getDataDecryptor());
    }

    private Slice getSlice(int size) throws IOException {
        ByteBuffer buffer = this.stream.slice(size);
        return Slices.wrappedBuffer((byte[])buffer.array(), (int)buffer.position(), (int)size);
    }

    private DictionaryPage readDictionaryPage(PageHeader pageHeader, int uncompressedPageSize, int compressedPageSize) throws IOException {
        DictionaryPageHeader dictHeader = pageHeader.getDictionary_page_header();
        return new DictionaryPage(this.getSlice(compressedPageSize), uncompressedPageSize, dictHeader.getNum_values(), ParquetTypeUtils.getParquetEncoding(Encoding.valueOf((String)dictHeader.getEncoding().name())));
    }

    private long readDataPageV1(PageHeader pageHeader, int uncompressedPageSize, int compressedPageSize, long firstRowIndex, List<DataPage> pages) throws IOException {
        DataPageHeader dataHeaderV1 = pageHeader.getData_page_header();
        pages.add(new DataPageV1(this.getSlice(compressedPageSize), dataHeaderV1.getNum_values(), uncompressedPageSize, firstRowIndex, MetadataReader.readStats(dataHeaderV1.getStatistics(), this.descriptor.getColumnDescriptor().getType()), ParquetTypeUtils.getParquetEncoding(Encoding.valueOf((String)dataHeaderV1.getRepetition_level_encoding().name())), ParquetTypeUtils.getParquetEncoding(Encoding.valueOf((String)dataHeaderV1.getDefinition_level_encoding().name())), ParquetTypeUtils.getParquetEncoding(Encoding.valueOf((String)dataHeaderV1.getEncoding().name()))));
        return dataHeaderV1.getNum_values();
    }

    private long readDataPageV2(PageHeader pageHeader, int uncompressedPageSize, int compressedPageSize, long firstRowIndex, List<DataPage> pages) throws IOException {
        DataPageHeaderV2 dataHeaderV2 = pageHeader.getData_page_header_v2();
        int dataSize = compressedPageSize - dataHeaderV2.getRepetition_levels_byte_length() - dataHeaderV2.getDefinition_levels_byte_length();
        pages.add(new DataPageV2(dataHeaderV2.getNum_rows(), dataHeaderV2.getNum_nulls(), dataHeaderV2.getNum_values(), firstRowIndex, this.getSlice(dataHeaderV2.getRepetition_levels_byte_length()), this.getSlice(dataHeaderV2.getDefinition_levels_byte_length()), ParquetTypeUtils.getParquetEncoding(Encoding.valueOf((String)dataHeaderV2.getEncoding().name())), this.getSlice(dataSize), uncompressedPageSize, MetadataReader.readStats(dataHeaderV2.getStatistics(), this.descriptor.getColumnDescriptor().getType()), dataHeaderV2.isIs_compressed()));
        return dataHeaderV2.getNum_values();
    }

    private boolean hasMorePages(long valuesCount, int pagesCount) {
        return this.offsetIndex == null ? valuesCount < this.descriptor.getColumnChunkMetaData().getValueCount() : pagesCount < this.offsetIndex.getPageCount();
    }

    private boolean hasDictionaryPage(ColumnChunkMetaData columnChunkMetaData) {
        EncodingStats stats = columnChunkMetaData.getEncodingStats();
        if (stats != null) {
            return stats.hasDictionaryPages() && stats.hasDictionaryEncodedPages();
        }
        Set encodings = columnChunkMetaData.getEncodings();
        return encodings.contains(Encoding.PLAIN_DICTIONARY) || encodings.contains(Encoding.RLE_DICTIONARY);
    }
}

