/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.batchreader.decoders.rle;

import com.google.common.base.Preconditions;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.column.values.bitpacking.BytePacker;
import org.apache.parquet.column.values.bitpacking.Packer;
import org.apache.parquet.io.ParquetDecodingException;

public abstract class BaseRLEBitPackedDecoder {
    private final boolean rleOnlyMode;
    private final int bitWidth;
    private final BytePacker packer;
    private final InputStream inputStream;
    protected Mode mode;
    protected int currentCount;
    protected int currentValue;
    protected int[] currentBuffer;

    public BaseRLEBitPackedDecoder(int valueCount, int bitWidth, InputStream inputStream) {
        Preconditions.checkArgument((bitWidth >= 0 && bitWidth <= 32 ? 1 : 0) != 0, (Object)"bitWidth must be >= 0 and <= 32");
        this.bitWidth = bitWidth;
        if (bitWidth != 0) {
            this.packer = Packer.LITTLE_ENDIAN.newBytePacker(bitWidth);
            this.inputStream = inputStream;
            this.rleOnlyMode = false;
        } else {
            this.rleOnlyMode = true;
            this.packer = null;
            this.inputStream = null;
            this.mode = Mode.RLE;
            this.currentValue = 0;
            this.currentCount = valueCount;
        }
    }

    public BaseRLEBitPackedDecoder(int rleValue, int rleValueCount) {
        this.rleOnlyMode = true;
        this.bitWidth = 0;
        this.packer = null;
        this.inputStream = null;
        this.mode = Mode.RLE;
        this.currentValue = rleValue;
        this.currentCount = rleValueCount;
    }

    protected boolean decode() throws IOException {
        if (this.rleOnlyMode) {
            return false;
        }
        if (this.inputStream.available() <= 0) {
            this.currentCount = 0;
            return false;
        }
        int header = BytesUtils.readUnsignedVarInt((InputStream)this.inputStream);
        this.mode = (header & 1) == 0 ? Mode.RLE : Mode.PACKED;
        switch (this.mode) {
            case RLE: {
                this.currentCount = header >>> 1;
                this.currentValue = BytesUtils.readIntLittleEndianPaddedOnBitWidth((InputStream)this.inputStream, (int)this.bitWidth);
                return true;
            }
            case PACKED: {
                int numGroups = header >>> 1;
                this.currentCount = numGroups * 8;
                this.currentBuffer = new int[this.currentCount];
                byte[] bytes = new byte[numGroups * this.bitWidth];
                int bytesToRead = (int)Math.ceil((double)(this.currentCount * this.bitWidth) / 8.0);
                bytesToRead = Math.min(bytesToRead, this.inputStream.available());
                DataInputStream dataInputStream = new DataInputStream(this.inputStream);
                dataInputStream.readFully(bytes, 0, bytesToRead);
                int valueIndex = 0;
                int byteIndex = 0;
                while (valueIndex < this.currentCount) {
                    this.packer.unpack8Values(bytes, byteIndex, this.currentBuffer, valueIndex);
                    valueIndex += 8;
                    byteIndex += this.bitWidth;
                }
                return true;
            }
        }
        throw new ParquetDecodingException("not a valid mode " + (Object)((Object)this.mode));
    }

    public static enum Mode {
        RLE,
        PACKED;

    }
}

