/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.crypto;

import java.util.Objects;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.crypto.HiddenColumnException;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;

public class HiddenColumnChunkMetaData
extends ColumnChunkMetaData {
    private final ColumnPath path;
    private final String filePath;

    public HiddenColumnChunkMetaData(ColumnPath path, String filePath) {
        super(null, null);
        this.path = Objects.requireNonNull(path, "path should not be null");
        this.filePath = Objects.requireNonNull(filePath, "filePath should not be null");
    }

    public long getFirstDataPageOffset() {
        throw new HiddenColumnException(this.path.toArray(), this.filePath);
    }

    public long getDictionaryPageOffset() {
        throw new HiddenColumnException(this.path.toArray(), this.filePath);
    }

    public long getValueCount() {
        throw new HiddenColumnException(this.path.toArray(), this.filePath);
    }

    public long getTotalUncompressedSize() {
        throw new HiddenColumnException(this.path.toArray(), this.filePath);
    }

    public long getTotalSize() {
        throw new HiddenColumnException(this.path.toArray(), this.filePath);
    }

    public Statistics getStatistics() {
        throw new HiddenColumnException(this.path.toArray(), this.filePath);
    }

    public static boolean isHiddenColumn(ColumnChunkMetaData column) {
        return column instanceof HiddenColumnChunkMetaData;
    }
}

