/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.parquet.Field;
import com.facebook.presto.parquet.FileParquetDataSource;
import com.facebook.presto.parquet.ParquetDataSource;
import com.facebook.presto.parquet.ParquetTestUtils;
import com.facebook.presto.parquet.ParquetTypeUtils;
import com.facebook.presto.parquet.cache.MetadataReader;
import com.facebook.presto.parquet.reader.ParquetReader;
import com.google.common.base.Strings;
import com.google.common.io.Files;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.airlift.units.DataSize;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.ColumnIO;
import org.apache.parquet.io.ColumnIOConverter;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.schema.MessageType;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=3)
@Warmup(iterations=30, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=20, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
@OperationsPerInvocation(value=10000000)
public class BenchmarkParquetReader {
    public static final int ROWS = 10000000;
    private static final boolean enableOptimizedReader = true;
    private static final boolean enableVerification = false;

    public static void main(String[] args) throws Throwable {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkParquetReader.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    private static Object read(BenchmarkData data) throws Exception {
        try (ParquetReader recordReader = data.createRecordReader();){
            ArrayList<Block> blocks = new ArrayList<Block>();
            while (recordReader.nextBatch() > 0) {
                Block block = recordReader.readBlock(data.getField());
                blocks.add(block);
            }
            ArrayList<Block> arrayList = blocks;
            return arrayList;
        }
    }

    @Benchmark
    public Object readBooleanNoNull(BooleanNoNullBenchmarkData data) throws Throwable {
        return BenchmarkParquetReader.read(data);
    }

    @Benchmark
    public Object readBooleanWithNull(BooleanWithNullBenchmarkData data) throws Throwable {
        return BenchmarkParquetReader.read(data);
    }

    @Benchmark
    public Object readInt32NoNull(Int32NoNullBenchmarkData data) throws Throwable {
        return BenchmarkParquetReader.read(data);
    }

    @Benchmark
    public Object readInt32WithNull(Int32WithNullBenchmarkData data) throws Throwable {
        return BenchmarkParquetReader.read(data);
    }

    @Benchmark
    public Object readInt64NoNull(Int64NoNullBenchmarkData data) throws Throwable {
        return BenchmarkParquetReader.read(data);
    }

    @Benchmark
    public Object readInt64WithNull(Int64WithNullBenchmarkData data) throws Throwable {
        return BenchmarkParquetReader.read(data);
    }

    @Benchmark
    public Object readInt96NoNull(Int96NoNullBenchmarkData data) throws Throwable {
        return BenchmarkParquetReader.read(data);
    }

    @Benchmark
    public Object readInt96WithNull(Int96WithNullBenchmarkData data) throws Throwable {
        return BenchmarkParquetReader.read(data);
    }

    @Benchmark
    public Object readSliceDictionaryNoNull(VarcharNoNullBenchmarkData data) throws Throwable {
        return BenchmarkParquetReader.read(data);
    }

    @Benchmark
    public Object readSliceDictionaryWithNull(VarcharWithNullBenchmarkData data) throws Throwable {
        return BenchmarkParquetReader.read(data);
    }

    @Benchmark
    public Object readListBooleanWithNull(ListBooleanWithNullBenchmarkData data) throws Throwable {
        return BenchmarkParquetReader.read(data);
    }

    @Benchmark
    public Object readListInt32WithNull(ListInt32WithNullBenchmarkData data) throws Throwable {
        return BenchmarkParquetReader.read(data);
    }

    @Benchmark
    public Object readListInt64WithNull(ListInt64WithNullBenchmarkData data) throws Throwable {
        return BenchmarkParquetReader.read(data);
    }

    @Benchmark
    public Object readListInt96WithNull(ListInt96WithNullBenchmarkData data) throws Throwable {
        return BenchmarkParquetReader.read(data);
    }

    @Benchmark
    public Object readListSliceDictionaryWithNull(ListVarcharWithNullBenchmarkData data) throws Throwable {
        return BenchmarkParquetReader.read(data);
    }

    @Benchmark
    public Object readStructBooleanWithNull(StructBooleanWithNullBenchmarkData data) throws Throwable {
        return BenchmarkParquetReader.read(data);
    }

    @Benchmark
    public Object readStructInt32WithNull(StructInt32WithNullBenchmarkData data) throws Throwable {
        return BenchmarkParquetReader.read(data);
    }

    @Benchmark
    public Object readStructInt64WithNull(StructInt64WithNullBenchmarkData data) throws Throwable {
        return BenchmarkParquetReader.read(data);
    }

    @Benchmark
    public Object readStructInt96WithNull(StructInt96WithNullBenchmarkData data) throws Throwable {
        return BenchmarkParquetReader.read(data);
    }

    @Benchmark
    public Object readStructSliceDictionaryWithNull(StructVarcharWithNullBenchmarkData data) throws Throwable {
        return BenchmarkParquetReader.read(data);
    }

    static {
        try {
            BenchmarkParquetReader benchmark = new BenchmarkParquetReader();
            BooleanNoNullBenchmarkData dataBoolNoNull = new BooleanNoNullBenchmarkData();
            dataBoolNoNull.setup();
            benchmark.readBooleanNoNull(dataBoolNoNull);
            BooleanWithNullBenchmarkData dataBoolWithNull = new BooleanWithNullBenchmarkData();
            dataBoolWithNull.setup();
            benchmark.readBooleanWithNull(dataBoolWithNull);
            Int32NoNullBenchmarkData dataIntNoNull = new Int32NoNullBenchmarkData();
            dataIntNoNull.setup();
            benchmark.readInt32NoNull(dataIntNoNull);
            Int32WithNullBenchmarkData dataIntWithNull = new Int32WithNullBenchmarkData();
            dataIntWithNull.setup();
            benchmark.readInt32WithNull(dataIntWithNull);
            Int64NoNullBenchmarkData dataInt64NoNull = new Int64NoNullBenchmarkData();
            dataInt64NoNull.setup();
            benchmark.readInt64NoNull(dataInt64NoNull);
            Int64WithNullBenchmarkData dataInt64WithNull = new Int64WithNullBenchmarkData();
            dataInt64WithNull.setup();
            benchmark.readInt64WithNull(dataInt64WithNull);
            Int96NoNullBenchmarkData dataInt96NoNull = new Int96NoNullBenchmarkData();
            dataInt96NoNull.setup();
            benchmark.readInt96NoNull(dataInt96NoNull);
            Int96WithNullBenchmarkData dataInt96WithNull = new Int96WithNullBenchmarkData();
            dataInt96WithNull.setup();
            benchmark.readInt96WithNull(dataInt96WithNull);
            VarcharNoNullBenchmarkData dataVarcharNoNull = new VarcharNoNullBenchmarkData();
            dataVarcharNoNull.setup();
            benchmark.readSliceDictionaryNoNull(dataVarcharNoNull);
            VarcharWithNullBenchmarkData dataVarcharWithNull = new VarcharWithNullBenchmarkData();
            dataVarcharWithNull.setup();
            benchmark.readSliceDictionaryWithNull(dataVarcharWithNull);
            ListBooleanWithNullBenchmarkData dataListBoolWithNull = new ListBooleanWithNullBenchmarkData();
            dataListBoolWithNull.setup();
            benchmark.readListBooleanWithNull(dataListBoolWithNull);
            ListInt32WithNullBenchmarkData dataListIntWithNull = new ListInt32WithNullBenchmarkData();
            dataListIntWithNull.setup();
            benchmark.readListInt32WithNull(dataListIntWithNull);
            ListInt64WithNullBenchmarkData dataListInt64WithNull = new ListInt64WithNullBenchmarkData();
            dataListInt64WithNull.setup();
            benchmark.readListInt64WithNull(dataListInt64WithNull);
            ListInt96WithNullBenchmarkData dataListInt96WithNull = new ListInt96WithNullBenchmarkData();
            dataListInt96WithNull.setup();
            benchmark.readListInt96WithNull(dataListInt96WithNull);
            ListVarcharWithNullBenchmarkData dataListVarcharWithNull = new ListVarcharWithNullBenchmarkData();
            dataListVarcharWithNull.setup();
            benchmark.readListSliceDictionaryWithNull(dataListVarcharWithNull);
            StructBooleanWithNullBenchmarkData dataStructBoolWithNull = new StructBooleanWithNullBenchmarkData();
            dataStructBoolWithNull.setup();
            benchmark.readStructBooleanWithNull(dataStructBoolWithNull);
            StructInt32WithNullBenchmarkData dataStructInt32WithNull = new StructInt32WithNullBenchmarkData();
            dataStructInt32WithNull.setup();
            benchmark.readStructInt32WithNull(dataStructInt32WithNull);
            StructInt64WithNullBenchmarkData dataStructInt64WithNull = new StructInt64WithNullBenchmarkData();
            dataStructInt64WithNull.setup();
            benchmark.readStructInt64WithNull(dataStructInt64WithNull);
            StructInt96WithNullBenchmarkData dataStructInt96WithNull = new StructInt96WithNullBenchmarkData();
            dataStructInt96WithNull.setup();
            benchmark.readStructInt96WithNull(dataStructInt96WithNull);
            StructVarcharWithNullBenchmarkData dataStructVarcharWithNull = new StructVarcharWithNullBenchmarkData();
            dataStructVarcharWithNull.setup();
            benchmark.readStructSliceDictionaryWithNull(dataStructVarcharWithNull);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    @State(value=Scope.Thread)
    public static class ListInt96WithNullBenchmarkData
    extends BenchmarkData {
        @Override
        protected List<?> generateValues() {
            Random random = new Random(0L);
            ArrayList values = new ArrayList();
            for (int i = 0; i < 10000000; ++i) {
                if (random.nextBoolean()) {
                    values.add(null);
                    continue;
                }
                int size = random.nextInt(5) + 1;
                ArrayList<Long> entry = new ArrayList<Long>();
                for (int j = 0; j < size; ++j) {
                    if (random.nextBoolean()) {
                        entry.add(Long.valueOf(random.nextInt(1572281176) * 1000));
                        continue;
                    }
                    entry.add(null);
                }
                values.add(entry);
            }
            return values;
        }

        @Override
        protected Type getType() {
            return new ArrayType((Type)TimestampType.TIMESTAMP);
        }
    }

    @State(value=Scope.Thread)
    public static class ListInt64WithNullBenchmarkData
    extends BenchmarkData {
        @Override
        protected List<?> generateValues() {
            Random random = new Random(0L);
            ArrayList values = new ArrayList();
            for (int i = 0; i < 10000000; ++i) {
                if (random.nextBoolean()) {
                    values.add(null);
                    continue;
                }
                int size = random.nextInt(5) + 1;
                ArrayList<Long> entry = new ArrayList<Long>();
                for (int j = 0; j < size; ++j) {
                    if (random.nextBoolean()) {
                        entry.add(random.nextLong());
                        continue;
                    }
                    entry.add(null);
                }
                values.add(entry);
            }
            return values;
        }

        @Override
        protected Type getType() {
            return new ArrayType((Type)BigintType.BIGINT);
        }
    }

    @State(value=Scope.Thread)
    public static class ListInt32WithNullBenchmarkData
    extends BenchmarkData {
        @Override
        protected List<?> generateValues() {
            Random random = new Random(0L);
            ArrayList values = new ArrayList();
            for (int i = 0; i < 10000000; ++i) {
                if (random.nextBoolean()) {
                    values.add(null);
                    continue;
                }
                int size = random.nextInt(5) + 1;
                ArrayList<Integer> entry = new ArrayList<Integer>();
                for (int j = 0; j < size; ++j) {
                    if (random.nextBoolean()) {
                        entry.add(random.nextInt());
                        continue;
                    }
                    entry.add(null);
                }
                values.add(entry);
            }
            return values;
        }

        @Override
        protected Type getType() {
            return new ArrayType((Type)IntegerType.INTEGER);
        }
    }

    @State(value=Scope.Thread)
    public static class ListBooleanWithNullBenchmarkData
    extends BenchmarkData {
        @Override
        protected List<?> generateValues() {
            Random random = new Random(0L);
            ArrayList values = new ArrayList();
            for (int i = 0; i < 10000000; ++i) {
                if (random.nextBoolean()) {
                    values.add(null);
                    continue;
                }
                int size = random.nextInt(5) + 1;
                ArrayList<Boolean> entry = new ArrayList<Boolean>();
                for (int j = 0; j < size; ++j) {
                    if (random.nextBoolean()) {
                        entry.add(random.nextBoolean());
                        continue;
                    }
                    entry.add(null);
                }
                values.add(entry);
            }
            return values;
        }

        @Override
        protected Type getType() {
            return new ArrayType((Type)BooleanType.BOOLEAN);
        }
    }

    @State(value=Scope.Thread)
    public static class ListVarcharWithNullBenchmarkData
    extends BenchmarkData {
        @Override
        protected List<?> generateValues() {
            Random random = new Random(0L);
            ArrayList values = new ArrayList();
            for (int i = 0; i < 10000000; ++i) {
                if (random.nextBoolean()) {
                    values.add(null);
                    continue;
                }
                int size = random.nextInt(5) + 1;
                ArrayList<String> entry = new ArrayList<String>();
                for (int j = 0; j < size; ++j) {
                    if (random.nextBoolean()) {
                        entry.add(Strings.repeat((String)"0", (int)4));
                        continue;
                    }
                    entry.add(null);
                }
                values.add(entry);
            }
            return values;
        }

        @Override
        protected Type getType() {
            return new ArrayType((Type)VarcharType.createVarcharType((int)400));
        }
    }

    @State(value=Scope.Thread)
    public static class StructVarcharWithNullBenchmarkData
    extends BenchmarkData {
        @Override
        protected List<?> generateValues() {
            Random random = new Random(0L);
            ArrayList<List<String>> values = new ArrayList<List<String>>();
            for (int i = 0; i < 10000000; ++i) {
                if (random.nextBoolean()) {
                    values.add(Collections.singletonList(Strings.repeat((String)"0", (int)4)));
                    continue;
                }
                values.add(null);
            }
            return values;
        }

        @Override
        protected Type getType() {
            RowType.Field field = RowType.field((String)"struct", (Type)VarcharType.createVarcharType((int)400));
            return RowType.from(Collections.singletonList(field));
        }
    }

    @State(value=Scope.Thread)
    public static class StructInt96WithNullBenchmarkData
    extends BenchmarkData {
        @Override
        protected List<?> generateValues() {
            ArrayList<List<Long>> values = new ArrayList<List<Long>>();
            for (int i = 0; i < 10000000; ++i) {
                if (this.random.nextBoolean()) {
                    values.add(Collections.singletonList(Long.valueOf(this.random.nextInt(1572281176) * 1000)));
                    continue;
                }
                values.add(null);
            }
            return values;
        }

        @Override
        protected Type getType() {
            RowType.Field field = RowType.field((String)"struct", (Type)TimestampType.TIMESTAMP);
            return RowType.from(Collections.singletonList(field));
        }
    }

    @State(value=Scope.Thread)
    public static class StructInt64WithNullBenchmarkData
    extends BenchmarkData {
        @Override
        protected List<?> generateValues() {
            ArrayList<List<Long>> values = new ArrayList<List<Long>>();
            for (int i = 0; i < 10000000; ++i) {
                if (this.random.nextBoolean()) {
                    values.add(Collections.singletonList(this.random.nextLong()));
                    continue;
                }
                values.add(null);
            }
            return values;
        }

        @Override
        protected Type getType() {
            RowType.Field field = RowType.field((String)"struct", (Type)BigintType.BIGINT);
            return RowType.from(Collections.singletonList(field));
        }
    }

    @State(value=Scope.Thread)
    public static class StructInt32WithNullBenchmarkData
    extends BenchmarkData {
        @Override
        protected List<?> generateValues() {
            ArrayList<List<Integer>> values = new ArrayList<List<Integer>>();
            for (int i = 0; i < 10000000; ++i) {
                if (this.random.nextBoolean()) {
                    values.add(Collections.singletonList(this.random.nextInt()));
                    continue;
                }
                values.add(null);
            }
            return values;
        }

        @Override
        protected Type getType() {
            RowType.Field field = RowType.field((String)"struct", (Type)IntegerType.INTEGER);
            return RowType.from(Collections.singletonList(field));
        }
    }

    @State(value=Scope.Thread)
    public static class StructBooleanWithNullBenchmarkData
    extends BenchmarkData {
        @Override
        protected List<?> generateValues() {
            ArrayList<List<Object>> values = new ArrayList<List<Object>>();
            for (int i = 0; i < 10000000; ++i) {
                values.add(Collections.singletonList(this.random.nextBoolean() ? Boolean.valueOf(this.random.nextBoolean()) : null));
            }
            return values;
        }

        @Override
        protected Type getType() {
            RowType.Field field = RowType.field((String)"struct", (Type)BooleanType.BOOLEAN);
            return RowType.from(Collections.singletonList(field));
        }
    }

    @State(value=Scope.Thread)
    public static class VarcharWithNullBenchmarkData
    extends BenchmarkData {
        @Override
        protected List<?> generateValues() {
            Random random = new Random(0L);
            ArrayList<String> values = new ArrayList<String>();
            for (int i = 0; i < 10000000; ++i) {
                if (random.nextBoolean()) {
                    values.add(Strings.repeat((String)"0", (int)4));
                    continue;
                }
                values.add(null);
            }
            return values;
        }

        @Override
        protected Type getType() {
            return VarcharType.createVarcharType((int)400);
        }
    }

    @State(value=Scope.Thread)
    public static class VarcharNoNullBenchmarkData
    extends BenchmarkData {
        @Override
        protected List<?> generateValues() {
            ArrayList<String> values = new ArrayList<String>();
            for (int i = 0; i < 10000000; ++i) {
                values.add(Strings.repeat((String)"0", (int)4));
            }
            return values;
        }

        @Override
        protected Type getType() {
            return VarcharType.createVarcharType((int)400);
        }

        @Override
        protected boolean getNullability() {
            return false;
        }
    }

    @State(value=Scope.Thread)
    public static class Int96WithNullBenchmarkData
    extends BenchmarkData {
        @Override
        protected List<?> generateValues() {
            ArrayList<Long> values = new ArrayList<Long>();
            for (int i = 0; i < 10000000; ++i) {
                if (this.random.nextBoolean()) {
                    values.add(Long.valueOf(this.random.nextInt(1572281176) * 1000));
                    continue;
                }
                values.add(null);
            }
            return values;
        }

        @Override
        protected Type getType() {
            return TimestampType.TIMESTAMP;
        }
    }

    @State(value=Scope.Thread)
    public static class Int96NoNullBenchmarkData
    extends BenchmarkData {
        @Override
        protected List<?> generateValues() {
            ArrayList<Long> values = new ArrayList<Long>();
            for (int i = 0; i < 10000000; ++i) {
                values.add(Long.valueOf(this.random.nextInt(1572281176) * 1000));
            }
            return values;
        }

        @Override
        protected Type getType() {
            return TimestampType.TIMESTAMP;
        }

        @Override
        protected boolean getNullability() {
            return false;
        }
    }

    @State(value=Scope.Thread)
    public static class Int64WithNullBenchmarkData
    extends BenchmarkData {
        @Override
        protected List<?> generateValues() {
            ArrayList<Long> values = new ArrayList<Long>();
            for (int i = 0; i < 10000000; ++i) {
                if (this.random.nextBoolean()) {
                    values.add(this.random.nextLong());
                    continue;
                }
                values.add(null);
            }
            return values;
        }

        @Override
        protected Type getType() {
            return BigintType.BIGINT;
        }
    }

    @State(value=Scope.Thread)
    public static class Int64NoNullBenchmarkData
    extends BenchmarkData {
        @Override
        protected List<?> generateValues() {
            ArrayList<Long> values = new ArrayList<Long>();
            for (int i = 0; i < 10000000; ++i) {
                values.add(this.random.nextLong());
            }
            return values;
        }

        @Override
        protected Type getType() {
            return BigintType.BIGINT;
        }

        @Override
        protected boolean getNullability() {
            return false;
        }
    }

    @State(value=Scope.Thread)
    public static class Int32WithNullBenchmarkData
    extends BenchmarkData {
        @Override
        protected List<?> generateValues() {
            ArrayList<Integer> values = new ArrayList<Integer>();
            for (int i = 0; i < 10000000; ++i) {
                if (this.random.nextBoolean()) {
                    values.add(this.random.nextInt());
                    continue;
                }
                values.add(null);
            }
            return values;
        }

        @Override
        protected Type getType() {
            return IntegerType.INTEGER;
        }
    }

    @State(value=Scope.Thread)
    public static class Int32NoNullBenchmarkData
    extends BenchmarkData {
        @Override
        protected List<?> generateValues() {
            ArrayList<Integer> values = new ArrayList<Integer>();
            for (int i = 0; i < 10000000; ++i) {
                values.add(this.random.nextInt());
            }
            return values;
        }

        @Override
        protected Type getType() {
            return IntegerType.INTEGER;
        }

        @Override
        protected boolean getNullability() {
            return false;
        }
    }

    @State(value=Scope.Thread)
    public static class BooleanWithNullBenchmarkData
    extends BenchmarkData {
        @Override
        protected List<?> generateValues() {
            ArrayList<Boolean> values = new ArrayList<Boolean>();
            for (int i = 0; i < 10000000; ++i) {
                values.add(this.random.nextBoolean() ? Boolean.valueOf(this.random.nextBoolean()) : null);
            }
            return values;
        }

        @Override
        protected Type getType() {
            return BooleanType.BOOLEAN;
        }
    }

    @State(value=Scope.Thread)
    public static class BooleanNoNullBenchmarkData
    extends BenchmarkData {
        @Override
        protected Type getType() {
            return BooleanType.BOOLEAN;
        }

        protected List<Boolean> generateValues() {
            ArrayList<Boolean> values = new ArrayList<Boolean>();
            for (int i = 0; i < 10000000; ++i) {
                values.add(this.random.nextBoolean());
            }
            return values;
        }

        @Override
        protected boolean getNullability() {
            return false;
        }
    }

    private static abstract class BenchmarkData {
        protected File temporaryDirectory;
        protected File file;
        protected Random random;
        private Field field;

        private BenchmarkData() {
        }

        @Setup
        public void setup() throws Exception {
            this.random = new Random(0L);
            this.temporaryDirectory = Files.createTempDir();
            this.file = new File(this.temporaryDirectory, UUID.randomUUID().toString());
            ParquetTestUtils.writeParquetColumnHive(this.file, "column", this.getNullability(), this.getType(), this.generateValues().iterator());
        }

        @TearDown
        public void tearDown() throws IOException {
            MoreFiles.deleteRecursively((Path)this.temporaryDirectory.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        }

        ParquetReader createRecordReader() throws IOException {
            FileParquetDataSource dataSource = new FileParquetDataSource(this.file);
            ParquetMetadata parquetMetadata = MetadataReader.readFooter((ParquetDataSource)dataSource, (long)this.file.length(), Optional.empty(), (boolean)false).getParquetMetadata();
            MessageType schema = parquetMetadata.getFileMetaData().getSchema();
            MessageColumnIO messageColumnIO = ParquetTypeUtils.getColumnIO((MessageType)schema, (MessageType)schema);
            this.field = (Field)ColumnIOConverter.constructField((Type)this.getType(), (ColumnIO)messageColumnIO.getChild(0)).get();
            return new ParquetReader(messageColumnIO, parquetMetadata.getBlocks(), Optional.empty(), (ParquetDataSource)dataSource, AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), new DataSize(16.0, DataSize.Unit.MEGABYTE), true, false, null, null, false, Optional.empty());
        }

        protected boolean getNullability() {
            return true;
        }

        Field getField() {
            return this.field;
        }

        protected abstract List<?> generateValues();

        protected abstract Type getType();
    }
}

