/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet;

import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.CharType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.SqlDecimal;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat;
import org.apache.hadoop.hive.ql.io.parquet.convert.HiveSchemaConverter;
import org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe;
import org.apache.hadoop.hive.ql.io.parquet.write.DataWritableWriteSupport;
import org.apache.hadoop.hive.serde2.Serializer;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.SettableStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.ShortWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;

public class ParquetTestUtils {
    private ParquetTestUtils() {
    }

    static void writeParquetColumnHive(File file, String columnName, boolean nullable, com.facebook.presto.common.type.Type type, Iterator<?> values) throws Exception {
        JobConf jobConf = new JobConf();
        jobConf.set("fs.file.impl", LocalFileSystem.class.getCanonicalName());
        jobConf.setLong("parquet.block.size", new DataSize(256.0, DataSize.Unit.MEGABYTE).toBytes());
        jobConf.setLong("parquet.page.size", new DataSize(100.0, DataSize.Unit.KILOBYTE).toBytes());
        jobConf.set("parquet.compression", "snappy");
        Properties properties = new Properties();
        properties.setProperty("columns", columnName);
        properties.setProperty("columns.types", ParquetTestUtils.getHiveType(type));
        FileSinkOperator.RecordWriter recordWriter = ParquetTestUtils.createParquetWriter(nullable, new Path(file.getAbsolutePath()), jobConf, properties, true);
        List<ObjectInspector> objectInspectors = ParquetTestUtils.getRowObjectInspectors(type);
        StandardStructObjectInspector tableObjectInspector = ObjectInspectorFactory.getStandardStructObjectInspector((List)ImmutableList.of((Object)columnName), objectInspectors);
        Object row = tableObjectInspector.create();
        StructField structField = tableObjectInspector.getStructFieldRef(columnName);
        Setter setter = ParquetTestUtils.getSetter(type, (SettableStructObjectInspector)tableObjectInspector, row, structField);
        Serializer serializer = ParquetTestUtils.initializeSerializer((Configuration)jobConf, properties);
        while (values.hasNext()) {
            Object value = values.next();
            if (value == null) {
                tableObjectInspector.setStructFieldData(row, structField, null);
            } else {
                setter.set(value);
            }
            recordWriter.write(serializer.serialize(row, (ObjectInspector)tableObjectInspector));
        }
        recordWriter.close(false);
    }

    private static String getHiveType(com.facebook.presto.common.type.Type type) {
        if (type.equals(BooleanType.BOOLEAN) || type.equals(BigintType.BIGINT) || type.equals(SmallintType.SMALLINT) || type.equals(TinyintType.TINYINT) || type.equals(DoubleType.DOUBLE)) {
            return type.getTypeSignature().toString();
        }
        if (type.equals(IntegerType.INTEGER)) {
            return "int";
        }
        if (type.equals(RealType.REAL)) {
            return "float";
        }
        if (type.equals(TimestampType.TIMESTAMP)) {
            return "timestamp";
        }
        if (type instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)type;
            int varcharLength = varcharType.getLength();
            return "varchar(" + varcharLength + ")";
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            return String.format("decimal(%d,%d)", decimalType.getPrecision(), decimalType.getScale());
        }
        if (type instanceof ArrayType) {
            return "array<" + ParquetTestUtils.getHiveType(((ArrayType)type).getElementType()) + ">";
        }
        if (type instanceof RowType) {
            return "struct<" + Joiner.on((String)",").join((Iterable)((RowType)type).getFields().stream().map(t -> (String)t.getName().get() + ":" + ParquetTestUtils.getHiveType(t.getType())).collect(Collectors.toList())) + ">";
        }
        throw new IllegalArgumentException("unsupported type: " + type);
    }

    private static Serializer initializeSerializer(Configuration conf, Properties properties) {
        try {
            Serializer result = (Serializer)ParquetHiveSerDe.class.getConstructor(new Class[0]).newInstance(new Object[0]);
            result.initialize(conf, properties);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static List<ObjectInspector> getRowObjectInspectors(com.facebook.presto.common.type.Type ... types) {
        return Arrays.stream(types).map(t -> ParquetTestUtils.getObjectInspector(t)).collect(Collectors.toList());
    }

    private static ObjectInspector getObjectInspector(com.facebook.presto.common.type.Type type) {
        if (type.equals(BooleanType.BOOLEAN)) {
            return PrimitiveObjectInspectorFactory.writableBooleanObjectInspector;
        }
        if (type.equals(BigintType.BIGINT)) {
            return PrimitiveObjectInspectorFactory.writableLongObjectInspector;
        }
        if (type.equals(IntegerType.INTEGER)) {
            return PrimitiveObjectInspectorFactory.writableIntObjectInspector;
        }
        if (type.equals(SmallintType.SMALLINT)) {
            return PrimitiveObjectInspectorFactory.writableShortObjectInspector;
        }
        if (type.equals(TinyintType.TINYINT)) {
            return PrimitiveObjectInspectorFactory.writableByteObjectInspector;
        }
        if (type.equals(DoubleType.DOUBLE)) {
            return PrimitiveObjectInspectorFactory.writableDoubleObjectInspector;
        }
        if (type.equals(RealType.REAL)) {
            return PrimitiveObjectInspectorFactory.writableFloatObjectInspector;
        }
        if (type.equals(TimestampType.TIMESTAMP)) {
            return PrimitiveObjectInspectorFactory.writableTimestampObjectInspector;
        }
        if (type instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)type;
            int varcharLength = varcharType.getLength();
            return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.getVarcharTypeInfo((int)varcharLength));
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            return PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)new DecimalTypeInfo(decimalType.getPrecision(), decimalType.getScale()));
        }
        if (type instanceof ArrayType || type instanceof RowType) {
            return ParquetTestUtils.getJavaObjectInspector(type);
        }
        throw new IllegalArgumentException("unsupported type: " + type);
    }

    private static Setter getSetter(com.facebook.presto.common.type.Type type, SettableStructObjectInspector tableObjectInspector, Object row, StructField structField) {
        if (type.equals(BooleanType.BOOLEAN)) {
            return new BooleanSetter(tableObjectInspector, row, structField);
        }
        if (type.equals(BigintType.BIGINT)) {
            return new BigIntSetter(tableObjectInspector, row, structField);
        }
        if (type.equals(IntegerType.INTEGER)) {
            return new IntegerSetter(tableObjectInspector, row, structField);
        }
        if (type.equals(SmallintType.SMALLINT)) {
            return new ShortSetter(tableObjectInspector, row, structField);
        }
        if (type.equals(TinyintType.TINYINT)) {
            return new TinyIntSetter(tableObjectInspector, row, structField);
        }
        if (type.equals(DoubleType.DOUBLE)) {
            return new DoubleSetter(tableObjectInspector, row, structField);
        }
        if (type.equals(RealType.REAL)) {
            return new FloatSetter(tableObjectInspector, row, structField);
        }
        if (type.equals(TimestampType.TIMESTAMP)) {
            return new TimestampSetter(tableObjectInspector, row, structField);
        }
        if (type instanceof VarcharType) {
            return new VarcharSetter(tableObjectInspector, row, structField);
        }
        if (type instanceof DecimalType) {
            return new DecimalSetter(tableObjectInspector, row, structField);
        }
        if (type instanceof ArrayType) {
            return new ArrayFieldSetter(tableObjectInspector, row, structField, (com.facebook.presto.common.type.Type)type.getTypeParameters().get(0));
        }
        if (type instanceof RowType) {
            return new RowFieldSetter(tableObjectInspector, row, structField, type.getTypeParameters());
        }
        throw new IllegalArgumentException("unsupported type: " + type);
    }

    public static ObjectInspector getJavaObjectInspector(com.facebook.presto.common.type.Type type) {
        if (type.equals(BooleanType.BOOLEAN)) {
            return PrimitiveObjectInspectorFactory.javaBooleanObjectInspector;
        }
        if (type.equals(BigintType.BIGINT)) {
            return PrimitiveObjectInspectorFactory.javaLongObjectInspector;
        }
        if (type.equals(IntegerType.INTEGER)) {
            return PrimitiveObjectInspectorFactory.javaIntObjectInspector;
        }
        if (type.equals(SmallintType.SMALLINT)) {
            return PrimitiveObjectInspectorFactory.javaShortObjectInspector;
        }
        if (type.equals(TinyintType.TINYINT)) {
            return PrimitiveObjectInspectorFactory.javaByteObjectInspector;
        }
        if (type.equals(RealType.REAL)) {
            return PrimitiveObjectInspectorFactory.javaFloatObjectInspector;
        }
        if (type.equals(DoubleType.DOUBLE)) {
            return PrimitiveObjectInspectorFactory.javaDoubleObjectInspector;
        }
        if (type instanceof VarcharType) {
            return PrimitiveObjectInspectorFactory.writableStringObjectInspector;
        }
        if (type instanceof CharType) {
            return PrimitiveObjectInspectorFactory.writableHiveCharObjectInspector;
        }
        if (type.equals(VarbinaryType.VARBINARY)) {
            return PrimitiveObjectInspectorFactory.javaByteArrayObjectInspector;
        }
        if (type.equals(DateType.DATE)) {
            return PrimitiveObjectInspectorFactory.javaDateObjectInspector;
        }
        if (type.equals(TimestampType.TIMESTAMP)) {
            return PrimitiveObjectInspectorFactory.javaTimestampObjectInspector;
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            return PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)new DecimalTypeInfo(decimalType.getPrecision(), decimalType.getScale()));
        }
        if (type instanceof ArrayType) {
            return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ParquetTestUtils.getJavaObjectInspector((com.facebook.presto.common.type.Type)type.getTypeParameters().get(0)));
        }
        if (type instanceof RowType) {
            return ObjectInspectorFactory.getStandardStructObjectInspector(type.getTypeSignature().getParameters().stream().map(parameter -> (String)parameter.getNamedTypeSignature().getName().get()).collect(Collectors.toList()), type.getTypeParameters().stream().map(ParquetTestUtils::getJavaObjectInspector).collect(Collectors.toList()));
        }
        throw new IllegalArgumentException("unsupported type: " + type);
    }

    private static FileSinkOperator.RecordWriter createParquetWriter(final boolean nullable, Path target, JobConf conf, Properties properties, boolean compress) throws IOException {
        return new MapredParquetOutputFormat(){

            public FileSinkOperator.RecordWriter getHiveRecordWriter(JobConf jobConf, Path finalOutPath, Class<? extends Writable> valueClass, boolean isCompressed, Properties tableProperties, Progressable progress) throws IOException {
                String columnNameProperty = tableProperties.getProperty("columns");
                String columnTypeProperty = tableProperties.getProperty("columns.types");
                List<String> columnNames = Arrays.asList(columnNameProperty.split(","));
                ArrayList columnTypes = TypeInfoUtils.getTypeInfosFromTypeString((String)columnTypeProperty);
                MessageType messageType = HiveSchemaConverter.convert(columnNames, (List)columnTypes);
                if (!nullable) {
                    List types = messageType.getFields();
                    ArrayList<Type> newTypes = new ArrayList<Type>();
                    for (Type type : types) {
                        newTypes.add(ParquetTestUtils.convertToRequiredType(type));
                    }
                    messageType = new MessageType("hive_schema", newTypes);
                }
                DataWritableWriteSupport.setSchema((MessageType)messageType, (Configuration)jobConf);
                return this.getParquerRecordWriterWrapper(this.realOutputFormat, jobConf, finalOutPath.toString(), progress, tableProperties);
            }
        }.getHiveRecordWriter(conf, target, Text.class, compress, properties, (Progressable)Reporter.NULL);
    }

    private static Type convertToRequiredType(Type type) {
        if (type instanceof GroupType) {
            GroupType groupType = (GroupType)type;
            List fields = groupType.getFields();
            ArrayList<Type> newFields = new ArrayList<Type>();
            for (Type field : fields) {
                newFields.add(ParquetTestUtils.convertToRequiredType(field));
            }
            return new GroupType(Type.Repetition.REPEATED, groupType.getName(), newFields);
        }
        if (type instanceof PrimitiveType) {
            PrimitiveType primitiveType = (PrimitiveType)type;
            Types.PrimitiveBuilder builder = Types.primitive((PrimitiveType.PrimitiveTypeName)primitiveType.getPrimitiveTypeName(), (Type.Repetition)Type.Repetition.REQUIRED);
            if (primitiveType.getDecimalMetadata() != null) {
                builder = (Types.PrimitiveBuilder)((Types.PrimitiveBuilder)builder.scale(primitiveType.getDecimalMetadata().getScale())).precision(primitiveType.getDecimalMetadata().getPrecision());
            }
            return ((PrimitiveType)((Types.PrimitiveBuilder)builder.length(primitiveType.getTypeLength())).named(primitiveType.getName())).asPrimitiveType();
        }
        throw new UnsupportedOperationException();
    }

    public static Object getField(com.facebook.presto.common.type.Type type, Object value) {
        if (value == null) {
            return null;
        }
        if (BooleanType.BOOLEAN.equals((Object)type) || BigintType.BIGINT.equals((Object)type) || IntegerType.INTEGER.equals((Object)type) || DoubleType.DOUBLE.equals((Object)type) || type.equals(RealType.REAL)) {
            return value;
        }
        if (type.equals(TimestampType.TIMESTAMP)) {
            return new Timestamp((Long)value);
        }
        if (type instanceof VarcharType) {
            return new Text(((String)value).getBytes());
        }
        if (type instanceof ArrayType) {
            List valueList = (List)value;
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < valueList.size(); ++i) {
                Object element = ParquetTestUtils.getField(((ArrayType)type).getElementType(), valueList.get(i));
                list.add(element);
            }
            return Collections.unmodifiableList(list);
        }
        if (type instanceof RowType) {
            List fieldTypes = type.getTypeParameters();
            List valueList = (List)value;
            ArrayList<Object> row = new ArrayList<Object>();
            for (int i = 0; i < valueList.size(); ++i) {
                Object element = ParquetTestUtils.getField((com.facebook.presto.common.type.Type)fieldTypes.get(i), valueList.get(i));
                row.add(element);
            }
            return Collections.unmodifiableList(row);
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "unsupported type: " + type);
    }

    private static class VarcharSetter
    extends Setter {
        private final HiveVarcharWritable writable = new HiveVarcharWritable();

        VarcharSetter(SettableStructObjectInspector tableObjectInspector, Object row, StructField structField) {
            super(tableObjectInspector, row, structField);
        }

        @Override
        void set(Object value) {
            this.writable.set((String)value);
            this.tableObjectInspector.setStructFieldData(this.row, this.structField, (Object)this.writable);
        }
    }

    private static class DecimalSetter
    extends Setter {
        private final HiveDecimalWritable writable = new HiveDecimalWritable();

        DecimalSetter(SettableStructObjectInspector tableObjectInspector, Object row, StructField structField) {
            super(tableObjectInspector, row, structField);
        }

        @Override
        void set(Object value) {
            this.writable.set(HiveDecimal.create((BigDecimal)((SqlDecimal)value).toBigDecimal()));
            this.tableObjectInspector.setStructFieldData(this.row, this.structField, (Object)this.writable);
        }
    }

    private static class TimestampSetter
    extends Setter {
        private final TimestampWritable writable = new TimestampWritable();

        TimestampSetter(SettableStructObjectInspector tableObjectInspector, Object row, StructField structField) {
            super(tableObjectInspector, row, structField);
        }

        @Override
        void set(Object value) {
            this.writable.setTime(((Long)value).longValue());
            this.tableObjectInspector.setStructFieldData(this.row, this.structField, (Object)this.writable);
        }
    }

    private static class DoubleSetter
    extends Setter {
        private final DoubleWritable writable = new DoubleWritable();

        DoubleSetter(SettableStructObjectInspector tableObjectInspector, Object row, StructField structField) {
            super(tableObjectInspector, row, structField);
        }

        @Override
        void set(Object value) {
            this.writable.set(((Double)value).doubleValue());
            this.tableObjectInspector.setStructFieldData(this.row, this.structField, (Object)this.writable);
        }
    }

    private static class FloatSetter
    extends Setter {
        private final FloatWritable writable = new FloatWritable();

        FloatSetter(SettableStructObjectInspector tableObjectInspector, Object row, StructField structField) {
            super(tableObjectInspector, row, structField);
        }

        @Override
        void set(Object value) {
            this.writable.set(((Float)value).floatValue());
            this.tableObjectInspector.setStructFieldData(this.row, this.structField, (Object)this.writable);
        }
    }

    private static class BigIntSetter
    extends Setter {
        private final LongWritable writable = new LongWritable();

        BigIntSetter(SettableStructObjectInspector tableObjectInspector, Object row, StructField structField) {
            super(tableObjectInspector, row, structField);
        }

        @Override
        void set(Object value) {
            this.writable.set(((Long)value).longValue());
            this.tableObjectInspector.setStructFieldData(this.row, this.structField, (Object)this.writable);
        }
    }

    private static class IntegerSetter
    extends Setter {
        private final IntWritable writable = new IntWritable();

        IntegerSetter(SettableStructObjectInspector tableObjectInspector, Object row, StructField structField) {
            super(tableObjectInspector, row, structField);
        }

        @Override
        void set(Object value) {
            this.writable.set(((Integer)value).intValue());
            this.tableObjectInspector.setStructFieldData(this.row, this.structField, (Object)this.writable);
        }
    }

    private static class ShortSetter
    extends Setter {
        private final ShortWritable writable = new ShortWritable();

        ShortSetter(SettableStructObjectInspector tableObjectInspector, Object row, StructField structField) {
            super(tableObjectInspector, row, structField);
        }

        @Override
        void set(Object value) {
            this.writable.set(((Short)value).shortValue());
            this.tableObjectInspector.setStructFieldData(this.row, this.structField, (Object)this.writable);
        }
    }

    private static class TinyIntSetter
    extends Setter {
        private final ByteWritable writable = new ByteWritable();

        TinyIntSetter(SettableStructObjectInspector tableObjectInspector, Object row, StructField structField) {
            super(tableObjectInspector, row, structField);
        }

        @Override
        void set(Object value) {
            this.writable.set(((Byte)value).byteValue());
            this.tableObjectInspector.setStructFieldData(this.row, this.structField, (Object)this.writable);
        }
    }

    private static class BooleanSetter
    extends Setter {
        private final BooleanWritable writable = new BooleanWritable();

        BooleanSetter(SettableStructObjectInspector tableObjectInspector, Object row, StructField structField) {
            super(tableObjectInspector, row, structField);
        }

        @Override
        void set(Object value) {
            this.writable.set(((Boolean)value).booleanValue());
            this.tableObjectInspector.setStructFieldData(this.row, this.structField, (Object)this.writable);
        }
    }

    private static class RowFieldSetter
    extends Setter {
        private final List<com.facebook.presto.common.type.Type> fieldTypes;

        public RowFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field, List<com.facebook.presto.common.type.Type> fieldTypes) {
            super(rowInspector, row, field);
            this.fieldTypes = ImmutableList.copyOf(fieldTypes);
        }

        @Override
        public void set(Object value) {
            List valueList = (List)value;
            ArrayList<Object> valueObjects = new ArrayList<Object>(this.fieldTypes.size());
            for (int i = 0; i < this.fieldTypes.size(); ++i) {
                Object element = ParquetTestUtils.getField(this.fieldTypes.get(i), valueList.get(i));
                valueObjects.add(element);
            }
            this.tableObjectInspector.setStructFieldData(this.row, this.structField, valueObjects);
        }
    }

    private static class ArrayFieldSetter
    extends Setter {
        private final com.facebook.presto.common.type.Type elementType;

        public ArrayFieldSetter(SettableStructObjectInspector rowInspector, Object row, StructField field, com.facebook.presto.common.type.Type elementType) {
            super(rowInspector, row, field);
            this.elementType = Objects.requireNonNull(elementType, "elementType is null");
        }

        @Override
        public void set(Object value) {
            List valueList = (List)value;
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i = 0; i < valueList.size(); ++i) {
                Object element = ParquetTestUtils.getField(this.elementType, valueList.get(i));
                list.add(element);
            }
            this.tableObjectInspector.setStructFieldData(this.row, this.structField, list);
        }
    }

    private static abstract class Setter {
        protected final SettableStructObjectInspector tableObjectInspector;
        protected final Object row;
        protected final StructField structField;

        Setter(SettableStructObjectInspector tableObjectInspector, Object row, StructField structField) {
            this.tableObjectInspector = tableObjectInspector;
            this.row = row;
            this.structField = structField;
        }

        abstract void set(Object var1);
    }
}

