/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet;

import com.facebook.presto.parquet.ParquetCompressionUtils;
import io.airlift.compress.Compressor;
import io.airlift.compress.lz4.Lz4Compressor;
import io.airlift.compress.zstd.ZstdCompressor;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestParquetCompressionUtils {
    @Test
    public void testDecompressZSTD() throws IOException {
        this.performTest(CompressionCodecName.ZSTD, 0);
        this.performTest(CompressionCodecName.ZSTD, 1);
        this.performTest(CompressionCodecName.ZSTD, 100);
        this.performTest(CompressionCodecName.ZSTD, 256);
        this.performTest(CompressionCodecName.ZSTD, 512);
        this.performTest(CompressionCodecName.ZSTD, 1024);
    }

    @Test
    public void testDecompressLZ4() throws IOException {
        this.performTest(CompressionCodecName.LZ4, 0);
        this.performTest(CompressionCodecName.LZ4, 1);
        this.performTest(CompressionCodecName.LZ4, 100);
        this.performTest(CompressionCodecName.LZ4, 256);
        this.performTest(CompressionCodecName.LZ4, 512);
        this.performTest(CompressionCodecName.LZ4, 1024);
    }

    private void performTest(CompressionCodecName codec, int inputLength) throws IOException {
        ZstdCompressor compressor = null;
        if (codec.equals((Object)CompressionCodecName.ZSTD)) {
            compressor = new ZstdCompressor();
        } else if (codec.equals((Object)CompressionCodecName.LZ4)) {
            compressor = new Lz4Compressor();
        }
        byte[] input = this.createArray(inputLength);
        byte[] output = new byte[inputLength + 512];
        int retLength = TestParquetCompressionUtils.compress((Compressor)compressor, input, inputLength, output, 0);
        Slice decompressedSlice = ParquetCompressionUtils.decompress((CompressionCodecName)codec, (Slice)Slices.wrappedBuffer((byte[])output, (int)0, (int)retLength), (int)inputLength);
        Assert.assertEquals((Object)decompressedSlice, (Object)Slices.wrappedBuffer((byte[])input));
    }

    private byte[] createArray(int length) {
        byte[] data = new byte[length];
        for (int i = 0; i < length; ++i) {
            data[i] = (byte)(i % 256);
        }
        return data;
    }

    private static int compress(Compressor compressor, byte[] byteArray, int inputLength, byte[] output, int outputOffset) {
        return compressor.compress(byteArray, 0, inputLength, output, outputOffset, output.length - outputOffset);
    }
}

