/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet;

import com.facebook.presto.parquet.ParquetTimestampUtils;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import org.apache.hadoop.hive.ql.io.parquet.timestamp.NanoTime;
import org.apache.hadoop.hive.ql.io.parquet.timestamp.NanoTimeUtils;
import org.apache.parquet.io.api.Binary;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestParquetTimestampUtils {
    @Test
    public void testGetTimestampMillis() {
        TestParquetTimestampUtils.assertTimestampCorrect("2011-01-01 00:00:00.000000000");
        TestParquetTimestampUtils.assertTimestampCorrect("2001-01-01 01:01:01.000000001");
        TestParquetTimestampUtils.assertTimestampCorrect("2015-12-31 23:59:59.999999999");
    }

    @Test
    public void testInvalidBinaryLength() {
        try {
            byte[] invalidLengthBinaryTimestamp = new byte[8];
            ParquetTimestampUtils.getTimestampMillis((Binary)Binary.fromByteArray((byte[])invalidLengthBinaryTimestamp));
        }
        catch (PrestoException e) {
            Assert.assertEquals((Object)e.getErrorCode(), (Object)StandardErrorCode.NOT_SUPPORTED.toErrorCode());
            Assert.assertEquals((String)e.getMessage(), (String)"Parquet timestamp must be 12 bytes, actual 8");
        }
    }

    private static void assertTimestampCorrect(String timestampString) {
        Timestamp timestamp = Timestamp.valueOf(timestampString);
        NanoTime nanoTime = NanoTimeUtils.getNanoTime((Timestamp)timestamp, (boolean)false);
        ByteBuffer buffer = ByteBuffer.wrap(nanoTime.toBinary().getBytes());
        long decodedTimestampMillis = ParquetTimestampUtils.getTimestampMillis((Binary)Binary.fromConstantByteBuffer((ByteBuffer)buffer));
        Assert.assertEquals((long)decodedTimestampMillis, (long)timestamp.getTime());
    }
}

