/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet;

import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.Range;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.predicate.ValueSet;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.execution.warnings.WarningCollectorConfig;
import com.facebook.presto.hive.HiveWarningCode;
import com.facebook.presto.parquet.DictionaryPage;
import com.facebook.presto.parquet.ParquetDataSourceId;
import com.facebook.presto.parquet.ParquetEncoding;
import com.facebook.presto.parquet.RichColumnDescriptor;
import com.facebook.presto.parquet.predicate.DictionaryDescriptor;
import com.facebook.presto.parquet.predicate.TupleDomainParquetPredicate;
import com.facebook.presto.spi.PrestoWarning;
import com.facebook.presto.testing.TestingWarningCollector;
import com.facebook.presto.testing.TestingWarningCollectorConfig;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.parquet.bytes.LittleEndianDataOutputStream;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.statistics.BooleanStatistics;
import org.apache.parquet.column.statistics.DoubleStatistics;
import org.apache.parquet.column.statistics.FloatStatistics;
import org.apache.parquet.column.statistics.IntStatistics;
import org.apache.parquet.column.statistics.LongStatistics;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestTupleDomainParquetPredicate {
    private static final ParquetDataSourceId ID = new ParquetDataSourceId("testFile");

    private static BooleanStatistics booleanColumnStats(boolean minimum, boolean maximum) {
        BooleanStatistics statistics = new BooleanStatistics();
        statistics.setMinMax(minimum, maximum);
        return statistics;
    }

    private static Statistics stringColumnStats(String minimum, String maximum) {
        Statistics.Builder builder = Statistics.getBuilderForReading((PrimitiveType)new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "testFile", OriginalType.UTF8));
        builder.withMin(minimum.getBytes()).withMax(maximum.getBytes()).withNumNulls(0L);
        return builder.build();
    }

    private static DoubleStatistics doubleColumnStats(double minimum, double maximum) {
        return TestTupleDomainParquetPredicate.doubleColumnStats(minimum, maximum, false);
    }

    private static DoubleStatistics doubleColumnStats(double minimum, double maximum, boolean hasNulls) {
        DoubleStatistics statistics = new DoubleStatistics();
        statistics.setMinMax(minimum, maximum);
        if (hasNulls) {
            statistics.setNumNulls(1L);
        }
        return statistics;
    }

    private static FloatStatistics floatColumnStats(float minimum, float maximum) {
        return TestTupleDomainParquetPredicate.floatColumnStats(minimum, maximum, false);
    }

    private static FloatStatistics floatColumnStats(float minimum, float maximum, boolean hasNulls) {
        FloatStatistics statistics = new FloatStatistics();
        statistics.setMinMax(minimum, maximum);
        if (hasNulls) {
            statistics.setNumNulls(1L);
        }
        return statistics;
    }

    private static IntStatistics intColumnStats(int minimum, int maximum) {
        IntStatistics statistics = new IntStatistics();
        statistics.setMinMax(minimum, maximum);
        return statistics;
    }

    private static Statistics<Long> longColumnStats(long minimum, long maximum) {
        LongStatistics statistics = new LongStatistics();
        statistics.setMinMax(minimum, maximum);
        return statistics;
    }

    private static LongStatistics longOnlyNullsStats(long numNulls) {
        LongStatistics statistics = new LongStatistics();
        statistics.setNumNulls(numNulls);
        return statistics;
    }

    @Test
    public void testBoolean() {
        TestingWarningCollector collector = new TestingWarningCollector(new WarningCollectorConfig(), new TestingWarningCollectorConfig().setAddWarnings(true));
        ColumnDescriptor columnDescriptor = this.createColumnDescriptor(PrimitiveType.PrimitiveTypeName.BOOLEAN, "BooleanColumn");
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((ColumnDescriptor)columnDescriptor, (Type)BooleanType.BOOLEAN, (long)0L, null, (ParquetDataSourceId)ID, Optional.of(collector)), (Object)Domain.all((Type)BooleanType.BOOLEAN));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((ColumnDescriptor)columnDescriptor, (Type)BooleanType.BOOLEAN, (long)10L, (Statistics)TestTupleDomainParquetPredicate.booleanColumnStats(true, true), (ParquetDataSourceId)ID, Optional.of(collector)), (Object)Domain.singleValue((Type)BooleanType.BOOLEAN, (Object)true));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((ColumnDescriptor)columnDescriptor, (Type)BooleanType.BOOLEAN, (long)10L, (Statistics)TestTupleDomainParquetPredicate.booleanColumnStats(false, false), (ParquetDataSourceId)ID, Optional.of(collector)), (Object)Domain.singleValue((Type)BooleanType.BOOLEAN, (Object)false));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((ColumnDescriptor)columnDescriptor, (Type)BooleanType.BOOLEAN, (long)20L, (Statistics)TestTupleDomainParquetPredicate.booleanColumnStats(false, true), (ParquetDataSourceId)ID, Optional.of(collector)), (Object)Domain.all((Type)BooleanType.BOOLEAN));
    }

    @Test
    public void testBigint() {
        TestingWarningCollector collector = new TestingWarningCollector(new WarningCollectorConfig(), new TestingWarningCollectorConfig().setAddWarnings(true));
        ColumnDescriptor columnDescriptor = this.createColumnDescriptor(PrimitiveType.PrimitiveTypeName.INT64, "BigintColumn");
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((ColumnDescriptor)columnDescriptor, (Type)BigintType.BIGINT, (long)0L, null, (ParquetDataSourceId)ID, Optional.of(collector)), (Object)Domain.all((Type)BigintType.BIGINT));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((ColumnDescriptor)columnDescriptor, (Type)BigintType.BIGINT, (long)10L, TestTupleDomainParquetPredicate.longColumnStats(100L, 100L), (ParquetDataSourceId)ID, Optional.of(collector)), (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)100L));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((ColumnDescriptor)columnDescriptor, (Type)BigintType.BIGINT, (long)10L, TestTupleDomainParquetPredicate.longColumnStats(0L, 100L), (ParquetDataSourceId)ID, Optional.of(collector)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)0L, (boolean)true, (Object)100L, (boolean)true), (Range[])new Range[0]), (boolean)false));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((ColumnDescriptor)columnDescriptor, (Type)BigintType.BIGINT, (long)20L, (Statistics)TestTupleDomainParquetPredicate.longOnlyNullsStats(10L), (ParquetDataSourceId)ID, Optional.of(collector)), (Object)Domain.create((ValueSet)ValueSet.all((Type)BigintType.BIGINT), (boolean)true));
        this.assertStatsCorruptionWarning(collector, TupleDomainParquetPredicate.getDomain((ColumnDescriptor)columnDescriptor, (Type)BigintType.BIGINT, (long)10L, TestTupleDomainParquetPredicate.longColumnStats(100L, 10L), (ParquetDataSourceId)ID, Optional.of(collector)), (Type)BigintType.BIGINT);
    }

    @Test
    public void testInteger() {
        TestingWarningCollector collector = new TestingWarningCollector(new WarningCollectorConfig(), new TestingWarningCollectorConfig().setAddWarnings(true));
        ColumnDescriptor columnDescriptor = this.createColumnDescriptor(PrimitiveType.PrimitiveTypeName.INT32, "IntegerColumn");
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((ColumnDescriptor)columnDescriptor, (Type)IntegerType.INTEGER, (long)0L, null, (ParquetDataSourceId)ID, Optional.of(collector)), (Object)Domain.all((Type)IntegerType.INTEGER));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((ColumnDescriptor)columnDescriptor, (Type)IntegerType.INTEGER, (long)10L, TestTupleDomainParquetPredicate.longColumnStats(100L, 100L), (ParquetDataSourceId)ID, Optional.of(collector)), (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)100L));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((ColumnDescriptor)columnDescriptor, (Type)IntegerType.INTEGER, (long)10L, TestTupleDomainParquetPredicate.longColumnStats(0L, 100L), (ParquetDataSourceId)ID, Optional.of(collector)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)IntegerType.INTEGER, (Object)0L, (boolean)true, (Object)100L, (boolean)true), (Range[])new Range[0]), (boolean)false));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((ColumnDescriptor)columnDescriptor, (Type)IntegerType.INTEGER, (long)20L, TestTupleDomainParquetPredicate.longColumnStats(0L, 0x80000000L), (ParquetDataSourceId)ID, Optional.of(collector)), (Object)Domain.notNull((Type)IntegerType.INTEGER));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((ColumnDescriptor)columnDescriptor, (Type)IntegerType.INTEGER, (long)20L, (Statistics)TestTupleDomainParquetPredicate.longOnlyNullsStats(10L), (ParquetDataSourceId)ID, Optional.of(collector)), (Object)Domain.create((ValueSet)ValueSet.all((Type)IntegerType.INTEGER), (boolean)true));
        this.assertStatsCorruptionWarning(collector, TupleDomainParquetPredicate.getDomain((ColumnDescriptor)columnDescriptor, (Type)IntegerType.INTEGER, (long)10L, TestTupleDomainParquetPredicate.longColumnStats(0x80000000L, 10L), (ParquetDataSourceId)ID, Optional.of(collector)), (Type)IntegerType.INTEGER);
    }

    @Test
    public void testSmallint() {
        TestingWarningCollector collector = new TestingWarningCollector(new WarningCollectorConfig(), new TestingWarningCollectorConfig().setAddWarnings(true));
        ColumnDescriptor columnDescriptor = this.createColumnDescriptor(PrimitiveType.PrimitiveTypeName.INT32, "SmallintColumn");
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((ColumnDescriptor)columnDescriptor, (Type)SmallintType.SMALLINT, (long)0L, null, (ParquetDataSourceId)ID, Optional.of(collector)), (Object)Domain.all((Type)SmallintType.SMALLINT));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((ColumnDescriptor)columnDescriptor, (Type)SmallintType.SMALLINT, (long)10L, TestTupleDomainParquetPredicate.longColumnStats(100L, 100L), (ParquetDataSourceId)ID, Optional.of(collector)), (Object)Domain.singleValue((Type)SmallintType.SMALLINT, (Object)100L));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((ColumnDescriptor)columnDescriptor, (Type)SmallintType.SMALLINT, (long)10L, TestTupleDomainParquetPredicate.longColumnStats(0L, 100L), (ParquetDataSourceId)ID, Optional.of(collector)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)SmallintType.SMALLINT, (Object)0L, (boolean)true, (Object)100L, (boolean)true), (Range[])new Range[0]), (boolean)false));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((ColumnDescriptor)columnDescriptor, (Type)SmallintType.SMALLINT, (long)20L, TestTupleDomainParquetPredicate.longColumnStats(0L, 0x80000000L), (ParquetDataSourceId)ID, Optional.of(collector)), (Object)Domain.notNull((Type)SmallintType.SMALLINT));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((ColumnDescriptor)columnDescriptor, (Type)SmallintType.SMALLINT, (long)20L, (Statistics)TestTupleDomainParquetPredicate.longOnlyNullsStats(10L), (ParquetDataSourceId)ID, Optional.of(collector)), (Object)Domain.create((ValueSet)ValueSet.all((Type)SmallintType.SMALLINT), (boolean)true));
        this.assertStatsCorruptionWarning(collector, TupleDomainParquetPredicate.getDomain((ColumnDescriptor)columnDescriptor, (Type)SmallintType.SMALLINT, (long)10L, TestTupleDomainParquetPredicate.longColumnStats(0x80000000L, 10L), (ParquetDataSourceId)ID, Optional.of(collector)), (Type)SmallintType.SMALLINT);
    }

    @Test
    public void testTinyint() {
        TestingWarningCollector collector = new TestingWarningCollector(new WarningCollectorConfig(), new TestingWarningCollectorConfig().setAddWarnings(true));
        ColumnDescriptor columnDescriptor = this.createColumnDescriptor(PrimitiveType.PrimitiveTypeName.INT32, "TinyintColumn");
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((ColumnDescriptor)columnDescriptor, (Type)TinyintType.TINYINT, (long)0L, null, (ParquetDataSourceId)ID, Optional.of(collector)), (Object)Domain.all((Type)TinyintType.TINYINT));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((ColumnDescriptor)columnDescriptor, (Type)TinyintType.TINYINT, (long)10L, TestTupleDomainParquetPredicate.longColumnStats(100L, 100L), (ParquetDataSourceId)ID, Optional.of(collector)), (Object)Domain.singleValue((Type)TinyintType.TINYINT, (Object)100L));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((ColumnDescriptor)columnDescriptor, (Type)TinyintType.TINYINT, (long)10L, TestTupleDomainParquetPredicate.longColumnStats(0L, 100L), (ParquetDataSourceId)ID, Optional.of(collector)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)TinyintType.TINYINT, (Object)0L, (boolean)true, (Object)100L, (boolean)true), (Range[])new Range[0]), (boolean)false));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((ColumnDescriptor)columnDescriptor, (Type)TinyintType.TINYINT, (long)20L, TestTupleDomainParquetPredicate.longColumnStats(0L, 0x80000000L), (ParquetDataSourceId)ID, Optional.of(collector)), (Object)Domain.notNull((Type)TinyintType.TINYINT));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((ColumnDescriptor)columnDescriptor, (Type)TinyintType.TINYINT, (long)20L, (Statistics)TestTupleDomainParquetPredicate.longOnlyNullsStats(10L), (ParquetDataSourceId)ID, Optional.of(collector)), (Object)Domain.create((ValueSet)ValueSet.all((Type)TinyintType.TINYINT), (boolean)true));
        this.assertStatsCorruptionWarning(collector, TupleDomainParquetPredicate.getDomain((ColumnDescriptor)columnDescriptor, (Type)TinyintType.TINYINT, (long)10L, TestTupleDomainParquetPredicate.longColumnStats(0x80000000L, 10L), (ParquetDataSourceId)ID, Optional.of(collector)), (Type)TinyintType.TINYINT);
    }

    @Test
    public void testDouble() throws Exception {
        TestingWarningCollector collector = new TestingWarningCollector(new WarningCollectorConfig(), new TestingWarningCollectorConfig().setAddWarnings(true));
        ColumnDescriptor columnDescriptor = this.createColumnDescriptor(PrimitiveType.PrimitiveTypeName.DOUBLE, "DoubleColumn");
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((ColumnDescriptor)columnDescriptor, (Type)DoubleType.DOUBLE, (long)0L, null, (ParquetDataSourceId)ID, Optional.of(collector)), (Object)Domain.all((Type)DoubleType.DOUBLE));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((ColumnDescriptor)columnDescriptor, (Type)DoubleType.DOUBLE, (long)10L, (Statistics)TestTupleDomainParquetPredicate.doubleColumnStats(42.24, 42.24), (ParquetDataSourceId)ID, Optional.of(collector)), (Object)Domain.singleValue((Type)DoubleType.DOUBLE, (Object)42.24));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((ColumnDescriptor)columnDescriptor, (Type)DoubleType.DOUBLE, (long)10L, (Statistics)TestTupleDomainParquetPredicate.doubleColumnStats(3.3, 42.24), (ParquetDataSourceId)ID, Optional.of(collector)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)DoubleType.DOUBLE, (Object)3.3, (boolean)true, (Object)42.24, (boolean)true), (Range[])new Range[0]), (boolean)false));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((ColumnDescriptor)columnDescriptor, (Type)DoubleType.DOUBLE, (long)10L, (Statistics)TestTupleDomainParquetPredicate.doubleColumnStats(Double.NaN, Double.NaN), (ParquetDataSourceId)ID, Optional.of(collector)), (Object)Domain.notNull((Type)DoubleType.DOUBLE));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((ColumnDescriptor)columnDescriptor, (Type)DoubleType.DOUBLE, (long)10L, (Statistics)TestTupleDomainParquetPredicate.doubleColumnStats(Double.NaN, Double.NaN, true), (ParquetDataSourceId)ID, Optional.of(collector)), (Object)Domain.all((Type)DoubleType.DOUBLE));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((ColumnDescriptor)columnDescriptor, (Type)DoubleType.DOUBLE, (long)10L, (Statistics)TestTupleDomainParquetPredicate.doubleColumnStats(3.3, Double.NaN), (ParquetDataSourceId)ID, Optional.of(collector)), (Object)Domain.notNull((Type)DoubleType.DOUBLE));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((ColumnDescriptor)columnDescriptor, (Type)DoubleType.DOUBLE, (long)10L, (Statistics)TestTupleDomainParquetPredicate.doubleColumnStats(3.3, Double.NaN, true), (ParquetDataSourceId)ID, Optional.of(collector)), (Object)Domain.all((Type)DoubleType.DOUBLE));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((Type)DoubleType.DOUBLE, (DictionaryDescriptor)this.doubleDictionaryDescriptor(Double.NaN)), (Object)Domain.all((Type)DoubleType.DOUBLE));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((Type)DoubleType.DOUBLE, (DictionaryDescriptor)this.doubleDictionaryDescriptor(3.3, Double.NaN)), (Object)Domain.all((Type)DoubleType.DOUBLE));
        this.assertStatsCorruptionWarning(collector, TupleDomainParquetPredicate.getDomain((ColumnDescriptor)columnDescriptor, (Type)DoubleType.DOUBLE, (long)10L, (Statistics)TestTupleDomainParquetPredicate.doubleColumnStats(42.24, 3.3), (ParquetDataSourceId)ID, Optional.of(collector)), (Type)DoubleType.DOUBLE);
    }

    @Test
    public void testString() {
        TestingWarningCollector collector = new TestingWarningCollector(new WarningCollectorConfig(), new TestingWarningCollectorConfig().setAddWarnings(true));
        ColumnDescriptor columnDescriptor = this.createColumnDescriptor(PrimitiveType.PrimitiveTypeName.BINARY, "StringColumn");
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((ColumnDescriptor)columnDescriptor, (Type)VarcharType.createUnboundedVarcharType(), (long)0L, null, (ParquetDataSourceId)ID, Optional.of(collector)), (Object)Domain.all((Type)VarcharType.createUnboundedVarcharType()));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((ColumnDescriptor)columnDescriptor, (Type)VarcharType.createUnboundedVarcharType(), (long)10L, (Statistics)TestTupleDomainParquetPredicate.stringColumnStats("taco", "taco"), (ParquetDataSourceId)ID, Optional.of(collector)), (Object)Domain.singleValue((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"taco")));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((ColumnDescriptor)columnDescriptor, (Type)VarcharType.createUnboundedVarcharType(), (long)10L, (Statistics)TestTupleDomainParquetPredicate.stringColumnStats("apple", "taco"), (ParquetDataSourceId)ID, Optional.of(collector)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"apple"), (boolean)true, (Object)Slices.utf8Slice((String)"taco"), (boolean)true), (Range[])new Range[0]), (boolean)false));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((ColumnDescriptor)columnDescriptor, (Type)VarcharType.createUnboundedVarcharType(), (long)10L, (Statistics)TestTupleDomainParquetPredicate.stringColumnStats("\u4e2d\u56fd", "\u7f8e\u5229\u575a"), (ParquetDataSourceId)ID, Optional.of(collector)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)VarcharType.createUnboundedVarcharType(), (Object)Slices.utf8Slice((String)"\u4e2d\u56fd"), (boolean)true, (Object)Slices.utf8Slice((String)"\u7f8e\u5229\u575a"), (boolean)true), (Range[])new Range[0]), (boolean)false));
        this.assertStatsCorruptionWarning(collector, TupleDomainParquetPredicate.getDomain((ColumnDescriptor)columnDescriptor, (Type)VarcharType.createUnboundedVarcharType(), (long)10L, (Statistics)TestTupleDomainParquetPredicate.stringColumnStats("taco", "apple"), (ParquetDataSourceId)ID, Optional.of(collector)), (Type)VarcharType.createUnboundedVarcharType());
    }

    @Test
    public void testFloat() throws Exception {
        TestingWarningCollector collector = new TestingWarningCollector(new WarningCollectorConfig(), new TestingWarningCollectorConfig().setAddWarnings(true));
        ColumnDescriptor columnDescriptor = this.createColumnDescriptor(PrimitiveType.PrimitiveTypeName.FLOAT, "FloatColumn");
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((ColumnDescriptor)columnDescriptor, (Type)RealType.REAL, (long)0L, null, (ParquetDataSourceId)ID, Optional.of(collector)), (Object)Domain.all((Type)RealType.REAL));
        float minimum = 4.3f;
        float maximum = 40.3f;
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((ColumnDescriptor)columnDescriptor, (Type)RealType.REAL, (long)10L, (Statistics)TestTupleDomainParquetPredicate.floatColumnStats(minimum, minimum), (ParquetDataSourceId)ID, Optional.of(collector)), (Object)Domain.singleValue((Type)RealType.REAL, (Object)Float.floatToRawIntBits(minimum)));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((ColumnDescriptor)columnDescriptor, (Type)RealType.REAL, (long)10L, (Statistics)TestTupleDomainParquetPredicate.floatColumnStats(minimum, maximum), (ParquetDataSourceId)ID, Optional.of(collector)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)RealType.REAL, (Object)Float.floatToRawIntBits(minimum), (boolean)true, (Object)Float.floatToRawIntBits(maximum), (boolean)true), (Range[])new Range[0]), (boolean)false));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((ColumnDescriptor)columnDescriptor, (Type)RealType.REAL, (long)10L, (Statistics)TestTupleDomainParquetPredicate.floatColumnStats(Float.NaN, Float.NaN), (ParquetDataSourceId)ID, Optional.of(collector)), (Object)Domain.notNull((Type)RealType.REAL));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((ColumnDescriptor)columnDescriptor, (Type)RealType.REAL, (long)10L, (Statistics)TestTupleDomainParquetPredicate.floatColumnStats(Float.NaN, Float.NaN, true), (ParquetDataSourceId)ID, Optional.of(collector)), (Object)Domain.all((Type)RealType.REAL));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((ColumnDescriptor)columnDescriptor, (Type)RealType.REAL, (long)10L, (Statistics)TestTupleDomainParquetPredicate.floatColumnStats(minimum, Float.NaN), (ParquetDataSourceId)ID, Optional.of(collector)), (Object)Domain.notNull((Type)RealType.REAL));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((ColumnDescriptor)columnDescriptor, (Type)RealType.REAL, (long)10L, (Statistics)TestTupleDomainParquetPredicate.floatColumnStats(minimum, Float.NaN, true), (ParquetDataSourceId)ID, Optional.of(collector)), (Object)Domain.all((Type)RealType.REAL));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((Type)RealType.REAL, (DictionaryDescriptor)this.floatDictionaryDescriptor(Float.NaN)), (Object)Domain.all((Type)RealType.REAL));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((Type)RealType.REAL, (DictionaryDescriptor)this.floatDictionaryDescriptor(minimum, Float.NaN)), (Object)Domain.all((Type)RealType.REAL));
        this.assertStatsCorruptionWarning(collector, TupleDomainParquetPredicate.getDomain((ColumnDescriptor)columnDescriptor, (Type)RealType.REAL, (long)10L, (Statistics)TestTupleDomainParquetPredicate.floatColumnStats(maximum, minimum), (ParquetDataSourceId)ID, Optional.of(collector)), (Type)RealType.REAL);
    }

    @Test
    public void testDate() {
        TestingWarningCollector collector = new TestingWarningCollector(new WarningCollectorConfig(), new TestingWarningCollectorConfig().setAddWarnings(true));
        ColumnDescriptor columnDescriptor = this.createColumnDescriptor(PrimitiveType.PrimitiveTypeName.INT32, "DateColumn");
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((ColumnDescriptor)columnDescriptor, (Type)DateType.DATE, (long)0L, null, (ParquetDataSourceId)ID, Optional.of(collector)), (Object)Domain.all((Type)DateType.DATE));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((ColumnDescriptor)columnDescriptor, (Type)DateType.DATE, (long)10L, (Statistics)TestTupleDomainParquetPredicate.intColumnStats(100, 100), (ParquetDataSourceId)ID, Optional.of(collector)), (Object)Domain.singleValue((Type)DateType.DATE, (Object)100L));
        Assert.assertEquals((Object)TupleDomainParquetPredicate.getDomain((ColumnDescriptor)columnDescriptor, (Type)DateType.DATE, (long)10L, (Statistics)TestTupleDomainParquetPredicate.intColumnStats(0, 100), (ParquetDataSourceId)ID, Optional.of(collector)), (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)DateType.DATE, (Object)0L, (boolean)true, (Object)100L, (boolean)true), (Range[])new Range[0]), (boolean)false));
        this.assertStatsCorruptionWarning(collector, TupleDomainParquetPredicate.getDomain((ColumnDescriptor)columnDescriptor, (Type)DateType.DATE, (long)10L, (Statistics)TestTupleDomainParquetPredicate.intColumnStats(200, 100), (ParquetDataSourceId)ID, Optional.of(collector)), (Type)DateType.DATE);
    }

    @Test
    public void testVarcharMatchesWithStatistics() {
        TestingWarningCollector collector = new TestingWarningCollector(new WarningCollectorConfig(), new TestingWarningCollectorConfig().setAddWarnings(true));
        String value = "Test";
        ColumnDescriptor columnDescriptor = new ColumnDescriptor(new String[]{"path"}, PrimitiveType.PrimitiveTypeName.BINARY, 0, 0);
        RichColumnDescriptor column = new RichColumnDescriptor(columnDescriptor, new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "Test column"));
        TupleDomain<ColumnDescriptor> effectivePredicate = this.getEffectivePredicate(column, VarcharType.createVarcharType((int)255), Slices.utf8Slice((String)value));
        TupleDomainParquetPredicate parquetPredicate = new TupleDomainParquetPredicate(effectivePredicate, Collections.singletonList(column));
        Statistics stats = Statistics.getStatsBasedOnType((PrimitiveType.PrimitiveTypeName)column.getType());
        stats.setNumNulls(1L);
        stats.setMinMaxFromBytes(value.getBytes(), value.getBytes());
        Assert.assertTrue((boolean)parquetPredicate.matches(2L, Collections.singletonMap(column, stats), ID, Optional.of(collector)));
    }

    @Test(dataProvider="typeForParquetInt32")
    public void testIntegerMatchesWithStatistics(Type typeForParquetInt32) {
        TestingWarningCollector collector = new TestingWarningCollector(new WarningCollectorConfig(), new TestingWarningCollectorConfig().setAddWarnings(true));
        RichColumnDescriptor column = new RichColumnDescriptor(new ColumnDescriptor(new String[]{"path"}, PrimitiveType.PrimitiveTypeName.INT32, 0, 0), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "Test column"));
        TupleDomain effectivePredicate = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)column, (Object)Domain.create((ValueSet)ValueSet.of((Type)typeForParquetInt32, (Object)42L, (Object[])new Object[]{43L, 44L, 112L}), (boolean)false)));
        TupleDomainParquetPredicate parquetPredicate = new TupleDomainParquetPredicate(effectivePredicate, Collections.singletonList(column));
        Assert.assertTrue((boolean)parquetPredicate.matches(2L, (Map)ImmutableMap.of((Object)column, (Object)TestTupleDomainParquetPredicate.intColumnStats(32, 42)), ID, Optional.of(collector)));
        Assert.assertFalse((boolean)parquetPredicate.matches(2L, (Map)ImmutableMap.of((Object)column, (Object)TestTupleDomainParquetPredicate.intColumnStats(30, 40)), ID, Optional.of(collector)));
        Assert.assertEquals((boolean)parquetPredicate.matches(2L, (Map)ImmutableMap.of((Object)column, (Object)TestTupleDomainParquetPredicate.intColumnStats(1024, 65578)), ID, Optional.of(collector)), (typeForParquetInt32 != IntegerType.INTEGER ? 1 : 0) != 0);
    }

    @DataProvider
    public Object[][] typeForParquetInt32() {
        return new Object[][]{{IntegerType.INTEGER}, {SmallintType.SMALLINT}, {TinyintType.TINYINT}};
    }

    @Test
    public void testBigintMatchesWithStatistics() {
        TestingWarningCollector collector = new TestingWarningCollector(new WarningCollectorConfig(), new TestingWarningCollectorConfig().setAddWarnings(true));
        RichColumnDescriptor column = new RichColumnDescriptor(new ColumnDescriptor(new String[]{"path"}, PrimitiveType.PrimitiveTypeName.INT64, 0, 0), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT64, "Test column"));
        TupleDomain effectivePredicate = TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)column, (Object)Domain.create((ValueSet)ValueSet.of((Type)BigintType.BIGINT, (Object)42L, (Object[])new Object[]{43L, 44L, 404L}), (boolean)false)));
        TupleDomainParquetPredicate parquetPredicate = new TupleDomainParquetPredicate(effectivePredicate, Collections.singletonList(column));
        Assert.assertTrue((boolean)parquetPredicate.matches(2L, (Map)ImmutableMap.of((Object)column, TestTupleDomainParquetPredicate.longColumnStats(32L, 42L)), ID, Optional.of(collector)));
        Assert.assertFalse((boolean)parquetPredicate.matches(2L, (Map)ImmutableMap.of((Object)column, TestTupleDomainParquetPredicate.longColumnStats(30L, 40L)), ID, Optional.of(collector)));
        Assert.assertFalse((boolean)parquetPredicate.matches(2L, (Map)ImmutableMap.of((Object)column, TestTupleDomainParquetPredicate.longColumnStats(1024L, 65578L)), ID, Optional.of(collector)));
    }

    @Test
    public void testVarcharMatchesWithDictionaryDescriptor() {
        ColumnDescriptor columnDescriptor = new ColumnDescriptor(new String[]{"path"}, new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, 0, ""), 0, 0);
        RichColumnDescriptor column = new RichColumnDescriptor(columnDescriptor, new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "Test column"));
        TupleDomain<ColumnDescriptor> effectivePredicate = this.getEffectivePredicate(column, VarcharType.createVarcharType((int)255), Slices.EMPTY_SLICE);
        TupleDomainParquetPredicate parquetPredicate = new TupleDomainParquetPredicate(effectivePredicate, Collections.singletonList(column));
        DictionaryPage page = new DictionaryPage(Slices.wrappedBuffer((byte[])new byte[]{0, 0, 0, 0}), 1, ParquetEncoding.PLAIN_DICTIONARY);
        Assert.assertTrue((boolean)parquetPredicate.matches(new DictionaryDescriptor((ColumnDescriptor)column, Optional.of(page))));
    }

    private TupleDomain<ColumnDescriptor> getEffectivePredicate(RichColumnDescriptor column, VarcharType type, Slice value) {
        ColumnDescriptor predicateColumn = new ColumnDescriptor(column.getPath(), column.getType(), 0, 0);
        Domain predicateDomain = Domain.singleValue((Type)type, (Object)value);
        Map<ColumnDescriptor, Domain> predicateColumns = Collections.singletonMap(predicateColumn, predicateDomain);
        return TupleDomain.withColumnDomains(predicateColumns);
    }

    private DictionaryDescriptor floatDictionaryDescriptor(float ... values) throws Exception {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try (LittleEndianDataOutputStream out = new LittleEndianDataOutputStream((OutputStream)buffer);){
            for (float value : values) {
                out.writeFloat(value);
            }
        }
        return new DictionaryDescriptor(new ColumnDescriptor(new String[]{"dummy"}, new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.FLOAT, 0, ""), 1, 1), Optional.of(new DictionaryPage(Slices.wrappedBuffer((byte[])buffer.toByteArray()), values.length, ParquetEncoding.PLAIN_DICTIONARY)));
    }

    private DictionaryDescriptor doubleDictionaryDescriptor(double ... values) throws Exception {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try (LittleEndianDataOutputStream out = new LittleEndianDataOutputStream((OutputStream)buffer);){
            for (double value : values) {
                out.writeDouble(value);
            }
        }
        return new DictionaryDescriptor(new ColumnDescriptor(new String[]{"dummy"}, new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.DOUBLE, 0, ""), 1, 1), Optional.of(new DictionaryPage(Slices.wrappedBuffer((byte[])buffer.toByteArray()), values.length, ParquetEncoding.PLAIN_DICTIONARY)));
    }

    private ColumnDescriptor createColumnDescriptor(PrimitiveType.PrimitiveTypeName typeName, String columnName) {
        return new ColumnDescriptor(new String[0], new PrimitiveType(Type.Repetition.REQUIRED, typeName, columnName), 0, 0);
    }

    private boolean assertStatsCorruptionWarning(TestingWarningCollector collector, Domain domain, Type type) {
        Assert.assertEquals((Object)domain, (Object)Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)false));
        Assert.assertTrue((boolean)collector.hasWarnings());
        List warnings = collector.getWarnings();
        Assert.assertEquals((int)warnings.size(), (int)2);
        Assert.assertEquals((Object)((PrestoWarning)warnings.get(0)).getWarningCode(), (Object)HiveWarningCode.HIVE_FILE_STATISTICS_CORRUPTION.toWarningCode());
        return true;
    }
}

