/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.batchreader;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.ByteArrayBlock;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.parquet.RichColumnDescriptor;
import com.facebook.presto.parquet.batchreader.AbstractNestedBatchReader;
import com.facebook.presto.parquet.batchreader.DefinitionLevelDecodingContext;
import com.facebook.presto.parquet.batchreader.RepetitionLevelDecodingContext;
import com.facebook.presto.parquet.batchreader.ValuesDecoderContext;
import com.facebook.presto.parquet.batchreader.decoders.ValuesDecoder;
import com.facebook.presto.parquet.reader.ColumnChunk;
import java.io.IOException;
import java.util.Optional;

public class BooleanNestedBatchReader
extends AbstractNestedBatchReader {
    public BooleanNestedBatchReader(RichColumnDescriptor columnDescriptor) {
        super(columnDescriptor);
    }

    protected ColumnChunk readNestedWithNull() throws IOException {
        int maxDefinitionLevel = this.columnDescriptor.getMaxDefinitionLevel();
        RepetitionLevelDecodingContext repetitionLevelDecodingContext = this.readRepetitionLevels(this.nextBatchSize);
        DefinitionLevelDecodingContext definitionLevelDecodingContext = this.readDefinitionLevels(repetitionLevelDecodingContext.getDLValuesDecoderContexts(), repetitionLevelDecodingContext.getRepetitionLevels().length);
        int[] definitionLevels = definitionLevelDecodingContext.getDefinitionLevels();
        int newBatchSize = 0;
        int batchNonNullCount = 0;
        for (ValuesDecoderContext valuesDecoderContext : definitionLevelDecodingContext.getValuesDecoderContexts()) {
            int nonNullCount = 0;
            int valueCount = 0;
            for (int i = valuesDecoderContext.getStart(); i < valuesDecoderContext.getEnd(); ++i) {
                nonNullCount += definitionLevels[i] == maxDefinitionLevel ? 1 : 0;
                valueCount += definitionLevels[i] >= maxDefinitionLevel - 1 ? 1 : 0;
            }
            batchNonNullCount += nonNullCount;
            newBatchSize += valueCount;
            valuesDecoderContext.setNonNullCount(nonNullCount);
            valuesDecoderContext.setValueCount(valueCount);
        }
        if (batchNonNullCount == 0) {
            Block block = RunLengthEncodedBlock.create((Type)this.field.getType(), null, (int)newBatchSize);
            return new ColumnChunk(block, definitionLevels, repetitionLevelDecodingContext.getRepetitionLevels());
        }
        byte[] values = new byte[newBatchSize];
        boolean[] isNull = new boolean[newBatchSize];
        int offset = 0;
        for (ValuesDecoderContext valuesDecoderContext : definitionLevelDecodingContext.getValuesDecoderContexts()) {
            ((ValuesDecoder.BooleanValuesDecoder)valuesDecoderContext.getValuesDecoder()).readNext(values, offset, valuesDecoderContext.getNonNullCount());
            int valueDestinationIndex = offset + valuesDecoderContext.getValueCount() - 1;
            int valueSourceIndex = offset + valuesDecoderContext.getNonNullCount() - 1;
            int definitionLevelIndex = valuesDecoderContext.getEnd() - 1;
            while (valueDestinationIndex >= offset) {
                if (definitionLevels[definitionLevelIndex] == maxDefinitionLevel) {
                    values[valueDestinationIndex--] = values[valueSourceIndex--];
                } else if (definitionLevels[definitionLevelIndex] == maxDefinitionLevel - 1) {
                    values[valueDestinationIndex] = 0;
                    isNull[valueDestinationIndex] = true;
                    --valueDestinationIndex;
                }
                --definitionLevelIndex;
            }
            offset += valuesDecoderContext.getValueCount();
        }
        boolean hasNoNull = batchNonNullCount == newBatchSize;
        ByteArrayBlock block = new ByteArrayBlock(newBatchSize, hasNoNull ? Optional.empty() : Optional.of(isNull), values);
        return new ColumnChunk((Block)block, definitionLevels, repetitionLevelDecodingContext.getRepetitionLevels());
    }

    protected ColumnChunk readNestedNoNull() throws IOException {
        int maxDefinitionLevel = this.columnDescriptor.getMaxDefinitionLevel();
        RepetitionLevelDecodingContext repetitionLevelDecodingContext = this.readRepetitionLevels(this.nextBatchSize);
        DefinitionLevelDecodingContext definitionLevelDecodingContext = this.readDefinitionLevels(repetitionLevelDecodingContext.getDLValuesDecoderContexts(), repetitionLevelDecodingContext.getRepetitionLevels().length);
        int[] definitionLevels = definitionLevelDecodingContext.getDefinitionLevels();
        int newBatchSize = 0;
        for (ValuesDecoderContext valuesDecoderContext : definitionLevelDecodingContext.getValuesDecoderContexts()) {
            int valueCount = 0;
            for (int i = valuesDecoderContext.getStart(); i < valuesDecoderContext.getEnd(); ++i) {
                valueCount += definitionLevels[i] == maxDefinitionLevel ? 1 : 0;
            }
            newBatchSize += valueCount;
            valuesDecoderContext.setNonNullCount(valueCount);
            valuesDecoderContext.setValueCount(valueCount);
        }
        byte[] values = new byte[newBatchSize];
        int offset = 0;
        for (ValuesDecoderContext valuesDecoderContext : definitionLevelDecodingContext.getValuesDecoderContexts()) {
            ((ValuesDecoder.BooleanValuesDecoder)valuesDecoderContext.getValuesDecoder()).readNext(values, offset, valuesDecoderContext.getNonNullCount());
            offset += valuesDecoderContext.getValueCount();
        }
        ByteArrayBlock block = new ByteArrayBlock(newBatchSize, Optional.empty(), values);
        return new ColumnChunk((Block)block, definitionLevels, repetitionLevelDecodingContext.getRepetitionLevels());
    }

    protected void seek() throws IOException {
        if (this.readOffset == 0) {
            return;
        }
        int maxDefinitionLevel = this.columnDescriptor.getMaxDefinitionLevel();
        RepetitionLevelDecodingContext repetitionLevelDecodingContext = this.readRepetitionLevels(this.readOffset);
        DefinitionLevelDecodingContext definitionLevelDecodingContext = this.readDefinitionLevels(repetitionLevelDecodingContext.getDLValuesDecoderContexts(), repetitionLevelDecodingContext.getRepetitionLevels().length);
        int[] definitionLevels = definitionLevelDecodingContext.getDefinitionLevels();
        for (ValuesDecoderContext valuesDecoderContext : definitionLevelDecodingContext.getValuesDecoderContexts()) {
            int valueCount = 0;
            for (int i = valuesDecoderContext.getStart(); i < valuesDecoderContext.getEnd(); ++i) {
                valueCount += definitionLevels[i] == maxDefinitionLevel ? 1 : 0;
            }
            ValuesDecoder.BooleanValuesDecoder intValuesDecoder = (ValuesDecoder.BooleanValuesDecoder)valuesDecoderContext.getValuesDecoder();
            intValuesDecoder.skip(valueCount);
        }
    }
}

