/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.batchreader.decoders;

import com.facebook.presto.parquet.batchreader.decoders.FlatDefinitionLevelDecoder;
import com.facebook.presto.parquet.batchreader.decoders.TestParquetUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.parquet.column.values.rle.RunLengthBitPackingHybridEncoder;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestFlatDefinitionLevelDecoder {
    private static int valueCount;
    private static int nonNullCount;
    private static byte[] pageBytes;
    private static List<Integer> expectedValues;

    @BeforeClass
    public void setup() throws IOException {
        Random random = new Random(200L);
        RunLengthBitPackingHybridEncoder encoder = TestParquetUtils.getSimpleDLEncoder();
        TestParquetUtils.addDLRLEBlock(1, 50, encoder, expectedValues);
        TestParquetUtils.addDLValues(TestParquetUtils.randomValues(random, 457, 1), encoder, expectedValues);
        TestParquetUtils.addDLRLEBlock(0, 37, encoder, expectedValues);
        TestParquetUtils.addDLValues(TestParquetUtils.randomValues(random, 186, 1), encoder, expectedValues);
        valueCount = expectedValues.size();
        for (Integer value : expectedValues) {
            nonNullCount += value.intValue();
        }
        pageBytes = encoder.toBytes().toByteArray();
    }

    @Test
    public void rleOnlyBlock() throws IOException {
        TestFlatDefinitionLevelDecoder.rleOnlyBlockHelper(true);
        TestFlatDefinitionLevelDecoder.rleOnlyBlockHelper(false);
    }

    private static void rleOnlyBlockHelper(boolean rleValue) throws IOException {
        boolean[] isNulls = new boolean[200];
        FlatDefinitionLevelDecoder dlDecoder = new FlatDefinitionLevelDecoder(rleValue ? 0 : 1, 200);
        int nonNullCount = dlDecoder.readNext(isNulls, 0, 200);
        Assert.assertEquals((int)nonNullCount, (int)(rleValue ? 0 : 200));
        for (int i = 0; i < 200; ++i) {
            Assert.assertEquals((boolean)isNulls[i], (boolean)rleValue);
        }
        dlDecoder = new FlatDefinitionLevelDecoder(rleValue ? 0 : 1, 200);
        int nonNullCount2 = 0;
        for (int offset = 0; offset < 200; offset += 29) {
            nonNullCount2 += dlDecoder.readNext(isNulls, offset, Math.min(29, 200 - offset));
        }
        Assert.assertEquals((int)nonNullCount2, (int)(rleValue ? 0 : 200));
        for (int i = 0; i < 200; ++i) {
            Assert.assertEquals((boolean)isNulls[i], (boolean)rleValue);
        }
    }

    @Test
    public void hybridReadInBatches() throws IOException {
        TestFlatDefinitionLevelDecoder.hybridReadInBatchesHelper(valueCount);
        TestFlatDefinitionLevelDecoder.hybridReadInBatchesHelper(29);
        TestFlatDefinitionLevelDecoder.hybridReadInBatchesHelper(83);
        TestFlatDefinitionLevelDecoder.hybridReadInBatchesHelper(128);
    }

    private static void hybridReadInBatchesHelper(int batchSize) throws IOException {
        boolean[] isNulls = new boolean[valueCount];
        FlatDefinitionLevelDecoder dlDecoder = new FlatDefinitionLevelDecoder(valueCount, (InputStream)new ByteArrayInputStream(pageBytes));
        int nonNullCount = 0;
        for (int offset = 0; offset < valueCount; offset += batchSize) {
            nonNullCount += dlDecoder.readNext(isNulls, offset, Math.min(batchSize, valueCount - offset));
        }
        TestFlatDefinitionLevelDecoder.compareExpectedActual(isNulls, nonNullCount);
    }

    private static void compareExpectedActual(boolean[] isNullsActual, int nonNullCountActual) {
        Assert.assertEquals((int)nonNullCountActual, (int)nonNullCount);
        for (int i = 0; i < valueCount; ++i) {
            Assert.assertEquals((boolean)isNullsActual[i], (expectedValues.get(i) == 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void tryReadingTooMany() {
        FlatDefinitionLevelDecoder dlDecoder = new FlatDefinitionLevelDecoder(valueCount, (InputStream)new ByteArrayInputStream(pageBytes));
        try {
            dlDecoder.readNext(new boolean[valueCount + 500], 0, valueCount + 500);
            Assert.fail((String)"shouldn't come here");
        }
        catch (Exception e) {
            Assert.assertEquals((String)e.getMessage(), (String)"Failed to copy the requested number of definition levels");
        }
    }

    static {
        expectedValues = new ArrayList<Integer>();
    }
}

