/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.batchreader.decoders;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hadoop.hive.ql.io.parquet.timestamp.NanoTime;
import org.apache.hadoop.hive.ql.io.parquet.timestamp.NanoTimeUtils;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.bytes.HeapByteBufferAllocator;
import org.apache.parquet.column.values.bitpacking.ByteBitPackingValuesWriter;
import org.apache.parquet.column.values.bitpacking.Packer;
import org.apache.parquet.column.values.plain.PlainValuesWriter;
import org.apache.parquet.column.values.rle.RunLengthBitPackingHybridEncoder;
import org.apache.parquet.io.api.Binary;

public class TestParquetUtils {
    private TestParquetUtils() {
    }

    public static RunLengthBitPackingHybridEncoder getSimpleDLEncoder() {
        return new RunLengthBitPackingHybridEncoder(1, 200, 1024000, (ByteBufferAllocator)new HeapByteBufferAllocator());
    }

    public static RunLengthBitPackingHybridEncoder getDictionaryDataPageEncoder(int maxValue) {
        return new RunLengthBitPackingHybridEncoder(BytesUtils.getWidthFromMaxInt((int)maxValue), 200, 1024000, (ByteBufferAllocator)new HeapByteBufferAllocator());
    }

    public static void addDLRLEBlock(int rleValue, int valueCount, RunLengthBitPackingHybridEncoder encoder, List<Integer> addedValues) {
        Preconditions.checkArgument((valueCount >= 8 ? 1 : 0) != 0, (Object)"Requires value count to be greater than 8 for RLE block");
        try {
            for (int i = 0; i < valueCount; ++i) {
                encoder.writeInt(rleValue);
                addedValues.add(rleValue);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static void addDLValues(Iterator<Integer> values, RunLengthBitPackingHybridEncoder encoder, List<Integer> addedValues) {
        try {
            while (values.hasNext()) {
                int value = values.next();
                encoder.writeInt(value);
                addedValues.add(value);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static Iterator<Integer> randomValues(Random random, int numValues, int maxValue) {
        ArrayList<Integer> values = new ArrayList<Integer>();
        for (int i = 0; i < numValues; ++i) {
            values.add(random.nextInt(maxValue + 1));
        }
        return values.iterator();
    }

    public static byte[] generatePlainValuesPage(int valueCount, int valueSizeBits, Random random, List<Object> addedValues) {
        Object writer = valueSizeBits == 1 ? new ByteBitPackingValuesWriter(1, Packer.LITTLE_ENDIAN) : new PlainValuesWriter(20, 1024000, (ByteBufferAllocator)new HeapByteBufferAllocator());
        switch (valueSizeBits) {
            case 1: {
                int i;
                for (i = 0; i < valueCount; ++i) {
                    int value = random.nextInt(2);
                    writer.writeInteger(value);
                    addedValues.add(value);
                }
                break;
            }
            case -1: {
                int i;
                for (i = 0; i < valueCount; ++i) {
                    String valueStr = RandomStringUtils.random((int)random.nextInt(10), (int)0, (int)0, (boolean)true, (boolean)true, null, (Random)random);
                    byte[] valueUtf8 = valueStr.getBytes(StandardCharsets.UTF_8);
                    writer.writeBytes(Binary.fromConstantByteArray((byte[])valueUtf8, (int)0, (int)valueUtf8.length));
                    addedValues.add(valueStr);
                }
                break;
            }
            case 32: {
                int i;
                for (i = 0; i < valueCount; ++i) {
                    int value = random.nextInt();
                    writer.writeInteger(value);
                    addedValues.add(value);
                }
                break;
            }
            case 64: {
                int i;
                for (i = 0; i < valueCount; ++i) {
                    long value = random.nextLong();
                    writer.writeLong(value);
                    addedValues.add(value);
                }
                break;
            }
            case 96: {
                int i;
                for (i = 0; i < valueCount; ++i) {
                    long millisValue = random.nextInt(1572281176) * 1000;
                    NanoTime nanoTime = NanoTimeUtils.getNanoTime((Timestamp)new Timestamp(millisValue), (boolean)false);
                    writer.writeLong(nanoTime.getTimeOfDayNanos());
                    writer.writeInteger(nanoTime.getJulianDay());
                    addedValues.add(millisValue);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid value size (expected: 4, 8 or 12)");
            }
        }
        try {
            return writer.getBytes().toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] generateDictionaryIdPage2048(int maxValue, Random random, List<Integer> addedValues) {
        RunLengthBitPackingHybridEncoder encoder = TestParquetUtils.getDictionaryDataPageEncoder(maxValue);
        TestParquetUtils.addDLRLEBlock(maxValue / 2, 50, encoder, addedValues);
        TestParquetUtils.addDLValues(TestParquetUtils.randomValues(random, 457, maxValue), encoder, addedValues);
        TestParquetUtils.addDLRLEBlock(0, 37, encoder, addedValues);
        TestParquetUtils.addDLValues(TestParquetUtils.randomValues(random, 186, maxValue), encoder, addedValues);
        TestParquetUtils.addDLValues(TestParquetUtils.randomValues(random, 289, maxValue), encoder, addedValues);
        TestParquetUtils.addDLRLEBlock(maxValue - 1, 76, encoder, addedValues);
        TestParquetUtils.addDLValues(TestParquetUtils.randomValues(random, 789, maxValue), encoder, addedValues);
        TestParquetUtils.addDLRLEBlock(maxValue - 1, 137, encoder, addedValues);
        TestParquetUtils.addDLValues(TestParquetUtils.randomValues(random, 27, maxValue), encoder, addedValues);
        Preconditions.checkState((addedValues.size() == 2048 ? 1 : 0) != 0);
        try {
            return encoder.toBytes().toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

