/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.batchreader.decoders;

import com.facebook.presto.parquet.DictionaryPage;
import com.facebook.presto.parquet.ParquetEncoding;
import com.facebook.presto.parquet.batchreader.decoders.TestParquetUtils;
import com.facebook.presto.parquet.batchreader.decoders.ValuesDecoder;
import com.facebook.presto.parquet.batchreader.decoders.plain.BinaryPlainValuesDecoder;
import com.facebook.presto.parquet.batchreader.decoders.plain.BooleanPlainValuesDecoder;
import com.facebook.presto.parquet.batchreader.decoders.plain.Int32PlainValuesDecoder;
import com.facebook.presto.parquet.batchreader.decoders.plain.Int64PlainValuesDecoder;
import com.facebook.presto.parquet.batchreader.decoders.plain.Int64TimestampMicrosPlainValuesDecoder;
import com.facebook.presto.parquet.batchreader.decoders.plain.TimestampPlainValuesDecoder;
import com.facebook.presto.parquet.batchreader.decoders.rle.BinaryRLEDictionaryValuesDecoder;
import com.facebook.presto.parquet.batchreader.decoders.rle.BooleanRLEValuesDecoder;
import com.facebook.presto.parquet.batchreader.decoders.rle.Int32RLEDictionaryValuesDecoder;
import com.facebook.presto.parquet.batchreader.decoders.rle.Int64RLEDictionaryValuesDecoder;
import com.facebook.presto.parquet.batchreader.decoders.rle.Int64TimestampMicrosRLEDictionaryValuesDecoder;
import com.facebook.presto.parquet.batchreader.decoders.rle.TimestampRLEDictionaryValuesDecoder;
import com.facebook.presto.parquet.batchreader.dictionary.BinaryBatchDictionary;
import com.facebook.presto.parquet.batchreader.dictionary.TimestampDictionary;
import com.facebook.presto.parquet.dictionary.IntegerDictionary;
import com.facebook.presto.parquet.dictionary.LongDictionary;
import io.airlift.slice.Slices;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.parquet.bytes.BytesUtils;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestValuesDecoders {
    private static ValuesDecoder.Int32ValuesDecoder int32Plain(byte[] pageBytes) {
        return new Int32PlainValuesDecoder(pageBytes, 0, pageBytes.length);
    }

    private static ValuesDecoder.Int32ValuesDecoder int32Dictionary(byte[] pageBytes, int dictionarySize, IntegerDictionary dictionary) {
        return new Int32RLEDictionaryValuesDecoder(BytesUtils.getWidthFromMaxInt((int)dictionarySize), (InputStream)new ByteArrayInputStream(pageBytes), dictionary);
    }

    private static ValuesDecoder.BinaryValuesDecoder binaryPlain(byte[] pageBytes) {
        return new BinaryPlainValuesDecoder(pageBytes, 0, pageBytes.length);
    }

    private static ValuesDecoder.BinaryValuesDecoder binaryDictionary(byte[] pageBytes, int dictionarySize, BinaryBatchDictionary dictionary) {
        return new BinaryRLEDictionaryValuesDecoder(BytesUtils.getWidthFromMaxInt((int)dictionarySize), (InputStream)new ByteArrayInputStream(pageBytes), dictionary);
    }

    private static ValuesDecoder.Int64ValuesDecoder int64Plain(byte[] pageBytes) {
        return new Int64PlainValuesDecoder(pageBytes, 0, pageBytes.length);
    }

    private static ValuesDecoder.Int64TimestampMicrosValuesDecoder int64TimestampMicrosPlain(byte[] pageBytes) {
        return new Int64TimestampMicrosPlainValuesDecoder(pageBytes, 0, pageBytes.length);
    }

    private static ValuesDecoder.Int64ValuesDecoder int64Dictionary(byte[] pageBytes, int dictionarySize, LongDictionary dictionary) {
        return new Int64RLEDictionaryValuesDecoder(BytesUtils.getWidthFromMaxInt((int)dictionarySize), (InputStream)new ByteArrayInputStream(pageBytes), dictionary);
    }

    private static ValuesDecoder.Int64TimestampMicrosValuesDecoder int64TimestampMicrosDictionary(byte[] pageBytes, int dictionarySize, LongDictionary dictionary) {
        return new Int64TimestampMicrosRLEDictionaryValuesDecoder(BytesUtils.getWidthFromMaxInt((int)dictionarySize), (InputStream)new ByteArrayInputStream(pageBytes), dictionary);
    }

    private static ValuesDecoder.TimestampValuesDecoder timestampPlain(byte[] pageBytes) {
        return new TimestampPlainValuesDecoder(pageBytes, 0, pageBytes.length);
    }

    private static ValuesDecoder.TimestampValuesDecoder timestampDictionary(byte[] pageBytes, int dictionarySize, TimestampDictionary dictionary) {
        return new TimestampRLEDictionaryValuesDecoder(BytesUtils.getWidthFromMaxInt((int)dictionarySize), (InputStream)new ByteArrayInputStream(pageBytes), dictionary);
    }

    private static ValuesDecoder.BooleanValuesDecoder booleanPlain(byte[] pageBytes) {
        return new BooleanPlainValuesDecoder(pageBytes, 0, pageBytes.length);
    }

    private static ValuesDecoder.BooleanValuesDecoder booleanRLE(byte[] pageBytes) {
        return new BooleanRLEValuesDecoder(ByteBuffer.wrap(pageBytes));
    }

    private static void int32BatchReadWithSkipHelper(int batchSize, int skipSize, int valueCount, ValuesDecoder.Int32ValuesDecoder decoder, List<Object> expectedValues) throws IOException {
        int skipBatchSize;
        int[] actualValues = new int[valueCount];
        int outputOffset = 0;
        for (int inputOffset = 0; inputOffset < valueCount; inputOffset += skipBatchSize) {
            int readBatchSize = Math.min(batchSize, valueCount - inputOffset);
            decoder.readNext(actualValues, outputOffset, readBatchSize);
            for (int i = 0; i < readBatchSize; ++i) {
                Assert.assertEquals((int)actualValues[outputOffset + i], (int)((Integer)expectedValues.get(inputOffset + i)));
            }
            outputOffset += readBatchSize;
            skipBatchSize = Math.min(skipSize, valueCount - (inputOffset += readBatchSize));
            decoder.skip(skipBatchSize);
        }
    }

    private static void binaryBatchReadWithSkipHelper(int batchSize, int skipSize, int valueCount, ValuesDecoder.BinaryValuesDecoder decoder, List<Object> expectedValues) throws IOException {
        int skipBatchSize;
        for (int inputOffset = 0; inputOffset < valueCount; inputOffset += skipBatchSize) {
            int readBatchSize = Math.min(batchSize, valueCount - inputOffset);
            ValuesDecoder.BinaryValuesDecoder.ValueBuffer valueBuffer = decoder.readNext(readBatchSize);
            byte[] byteBuffer = new byte[valueBuffer.getBufferSize()];
            int[] offsets = new int[readBatchSize + 1];
            decoder.readIntoBuffer(byteBuffer, 0, offsets, 0, valueBuffer);
            for (int i = 0; i < readBatchSize; ++i) {
                byte[] expected = ((String)expectedValues.get(inputOffset + i)).getBytes(BytesUtils.UTF8);
                byte[] actual = Arrays.copyOfRange(byteBuffer, offsets[i], offsets[i + 1]);
                Assert.assertEquals((byte[])expected, (byte[])actual);
            }
            skipBatchSize = Math.min(skipSize, valueCount - (inputOffset += readBatchSize));
            decoder.skip(skipBatchSize);
        }
    }

    private static void int64BatchReadWithSkipHelper(int batchSize, int skipSize, int valueCount, ValuesDecoder.Int64TimestampMicrosValuesDecoder decoder, List<Object> expectedValues) throws IOException {
        int skipBatchSize;
        long[] actualValues = new long[valueCount];
        int outputOffset = 0;
        for (int inputOffset = 0; inputOffset < valueCount; inputOffset += skipBatchSize) {
            int readBatchSize = Math.min(batchSize, valueCount - inputOffset);
            decoder.readNext(actualValues, outputOffset, readBatchSize);
            for (int i = 0; i < readBatchSize; ++i) {
                Assert.assertEquals((long)actualValues[outputOffset + i], (long)((Long)expectedValues.get(inputOffset + i)));
            }
            outputOffset += readBatchSize;
            skipBatchSize = Math.min(skipSize, valueCount - (inputOffset += readBatchSize));
            decoder.skip(skipBatchSize);
        }
    }

    private static void int64BatchReadWithSkipHelper(int batchSize, int skipSize, int valueCount, ValuesDecoder.Int64ValuesDecoder decoder, List<Object> expectedValues) throws IOException {
        int skipBatchSize;
        long[] actualValues = new long[valueCount];
        int outputOffset = 0;
        for (int inputOffset = 0; inputOffset < valueCount; inputOffset += skipBatchSize) {
            int readBatchSize = Math.min(batchSize, valueCount - inputOffset);
            decoder.readNext(actualValues, outputOffset, readBatchSize);
            for (int i = 0; i < readBatchSize; ++i) {
                Assert.assertEquals((long)actualValues[outputOffset + i], (long)((Long)expectedValues.get(inputOffset + i)));
            }
            outputOffset += readBatchSize;
            skipBatchSize = Math.min(skipSize, valueCount - (inputOffset += readBatchSize));
            decoder.skip(skipBatchSize);
        }
    }

    private static void timestampBatchReadWithSkipHelper(int batchSize, int skipSize, int valueCount, ValuesDecoder.TimestampValuesDecoder decoder, List<Object> expectedValues) throws IOException {
        int skipBatchSize;
        long[] actualValues = new long[valueCount];
        int outputOffset = 0;
        for (int inputOffset = 0; inputOffset < valueCount; inputOffset += skipBatchSize) {
            int readBatchSize = Math.min(batchSize, valueCount - inputOffset);
            decoder.readNext(actualValues, outputOffset, readBatchSize);
            for (int i = 0; i < readBatchSize; ++i) {
                Assert.assertEquals((long)actualValues[outputOffset + i], (long)((Long)expectedValues.get(inputOffset + i)));
            }
            outputOffset += readBatchSize;
            skipBatchSize = Math.min(skipSize, valueCount - (inputOffset += readBatchSize));
            decoder.skip(skipBatchSize);
        }
    }

    private static void booleanBatchReadWithSkipHelper(int batchSize, int skipSize, int valueCount, ValuesDecoder.BooleanValuesDecoder decoder, List<Object> expectedValues) {
        int skipBatchSize;
        byte[] actualValues = new byte[valueCount];
        int outputOffset = 0;
        for (int inputOffset = 0; inputOffset < valueCount; inputOffset += skipBatchSize) {
            int readBatchSize = Math.min(batchSize, valueCount - inputOffset);
            decoder.readNext(actualValues, outputOffset, readBatchSize);
            for (int i = 0; i < readBatchSize; ++i) {
                Assert.assertEquals((int)actualValues[outputOffset + i], (int)((Integer)expectedValues.get(inputOffset + i)));
            }
            outputOffset += readBatchSize;
            skipBatchSize = Math.min(skipSize, valueCount - (inputOffset += readBatchSize));
            decoder.skip(skipBatchSize);
        }
    }

    @Test
    public void testInt32Plain() throws IOException {
        int valueCount = 2048;
        ArrayList<Object> expectedValues = new ArrayList<Object>();
        byte[] pageBytes = TestParquetUtils.generatePlainValuesPage(valueCount, 32, new Random(89L), expectedValues);
        TestValuesDecoders.int32BatchReadWithSkipHelper(valueCount, 0, valueCount, TestValuesDecoders.int32Plain(pageBytes), expectedValues);
        TestValuesDecoders.int32BatchReadWithSkipHelper(29, 0, valueCount, TestValuesDecoders.int32Plain(pageBytes), expectedValues);
        TestValuesDecoders.int32BatchReadWithSkipHelper(89, 0, valueCount, TestValuesDecoders.int32Plain(pageBytes), expectedValues);
        TestValuesDecoders.int32BatchReadWithSkipHelper(1024, 0, valueCount, TestValuesDecoders.int32Plain(pageBytes), expectedValues);
        TestValuesDecoders.int32BatchReadWithSkipHelper(256, 29, valueCount, TestValuesDecoders.int32Plain(pageBytes), expectedValues);
        TestValuesDecoders.int32BatchReadWithSkipHelper(89, 29, valueCount, TestValuesDecoders.int32Plain(pageBytes), expectedValues);
        TestValuesDecoders.int32BatchReadWithSkipHelper(1024, 1024, valueCount, TestValuesDecoders.int32Plain(pageBytes), expectedValues);
    }

    @Test
    public void testInt32RLEDictionary() throws IOException {
        Random random = new Random(83L);
        int valueCount = 2048;
        int dictionarySize = 29;
        ArrayList<Object> dictionary = new ArrayList<Object>();
        ArrayList<Integer> dictionaryIds = new ArrayList<Integer>();
        byte[] dictionaryPage = TestParquetUtils.generatePlainValuesPage(dictionarySize, 32, random, dictionary);
        byte[] dataPage = TestParquetUtils.generateDictionaryIdPage2048(dictionarySize - 1, random, dictionaryIds);
        ArrayList<Object> expectedValues = new ArrayList<Object>();
        for (Integer dictionaryId : dictionaryIds) {
            expectedValues.add(dictionary.get(dictionaryId));
        }
        IntegerDictionary integerDictionary = new IntegerDictionary(new DictionaryPage(Slices.wrappedBuffer((byte[])dictionaryPage), dictionarySize, ParquetEncoding.PLAIN_DICTIONARY));
        TestValuesDecoders.int32BatchReadWithSkipHelper(valueCount, 0, valueCount, TestValuesDecoders.int32Dictionary(dataPage, dictionarySize, integerDictionary), expectedValues);
        TestValuesDecoders.int32BatchReadWithSkipHelper(29, 0, valueCount, TestValuesDecoders.int32Dictionary(dataPage, dictionarySize, integerDictionary), expectedValues);
        TestValuesDecoders.int32BatchReadWithSkipHelper(89, 0, valueCount, TestValuesDecoders.int32Dictionary(dataPage, dictionarySize, integerDictionary), expectedValues);
        TestValuesDecoders.int32BatchReadWithSkipHelper(1024, 0, valueCount, TestValuesDecoders.int32Dictionary(dataPage, dictionarySize, integerDictionary), expectedValues);
        TestValuesDecoders.int32BatchReadWithSkipHelper(256, 29, valueCount, TestValuesDecoders.int32Dictionary(dataPage, dictionarySize, integerDictionary), expectedValues);
        TestValuesDecoders.int32BatchReadWithSkipHelper(89, 29, valueCount, TestValuesDecoders.int32Dictionary(dataPage, dictionarySize, integerDictionary), expectedValues);
        TestValuesDecoders.int32BatchReadWithSkipHelper(1024, 1024, valueCount, TestValuesDecoders.int32Dictionary(dataPage, dictionarySize, integerDictionary), expectedValues);
    }

    @Test
    public void testBinaryPlain() throws IOException {
        int valueCount = 2048;
        ArrayList<Object> expectedValues = new ArrayList<Object>();
        byte[] pageBytes = TestParquetUtils.generatePlainValuesPage(valueCount, -1, new Random(113L), expectedValues);
        TestValuesDecoders.binaryBatchReadWithSkipHelper(valueCount, 0, valueCount, TestValuesDecoders.binaryPlain(pageBytes), expectedValues);
        TestValuesDecoders.binaryBatchReadWithSkipHelper(29, 0, valueCount, TestValuesDecoders.binaryPlain(pageBytes), expectedValues);
        TestValuesDecoders.binaryBatchReadWithSkipHelper(89, 0, valueCount, TestValuesDecoders.binaryPlain(pageBytes), expectedValues);
        TestValuesDecoders.binaryBatchReadWithSkipHelper(1024, 0, valueCount, TestValuesDecoders.binaryPlain(pageBytes), expectedValues);
        TestValuesDecoders.binaryBatchReadWithSkipHelper(256, 29, valueCount, TestValuesDecoders.binaryPlain(pageBytes), expectedValues);
        TestValuesDecoders.binaryBatchReadWithSkipHelper(89, 29, valueCount, TestValuesDecoders.binaryPlain(pageBytes), expectedValues);
        TestValuesDecoders.binaryBatchReadWithSkipHelper(1024, 1024, valueCount, TestValuesDecoders.binaryPlain(pageBytes), expectedValues);
    }

    @Test
    public void testBinaryRLEDictionary() throws IOException {
        Random random = new Random(83L);
        int valueCount = 2048;
        int dictionarySize = 29;
        ArrayList<Object> dictionary = new ArrayList<Object>();
        ArrayList<Integer> dictionaryIds = new ArrayList<Integer>();
        byte[] dictionaryPage = TestParquetUtils.generatePlainValuesPage(dictionarySize, -1, random, dictionary);
        byte[] dataPage = TestParquetUtils.generateDictionaryIdPage2048(dictionarySize - 1, random, dictionaryIds);
        ArrayList<Object> expectedValues = new ArrayList<Object>();
        for (Integer dictionaryId : dictionaryIds) {
            expectedValues.add(dictionary.get(dictionaryId));
        }
        BinaryBatchDictionary binaryDictionary = new BinaryBatchDictionary(new DictionaryPage(Slices.wrappedBuffer((byte[])dictionaryPage), dictionarySize, ParquetEncoding.PLAIN_DICTIONARY));
        TestValuesDecoders.binaryBatchReadWithSkipHelper(valueCount, 0, valueCount, TestValuesDecoders.binaryDictionary(dataPage, dictionarySize, binaryDictionary), expectedValues);
        TestValuesDecoders.binaryBatchReadWithSkipHelper(29, 0, valueCount, TestValuesDecoders.binaryDictionary(dataPage, dictionarySize, binaryDictionary), expectedValues);
        TestValuesDecoders.binaryBatchReadWithSkipHelper(89, 0, valueCount, TestValuesDecoders.binaryDictionary(dataPage, dictionarySize, binaryDictionary), expectedValues);
        TestValuesDecoders.binaryBatchReadWithSkipHelper(1024, 0, valueCount, TestValuesDecoders.binaryDictionary(dataPage, dictionarySize, binaryDictionary), expectedValues);
        TestValuesDecoders.binaryBatchReadWithSkipHelper(256, 29, valueCount, TestValuesDecoders.binaryDictionary(dataPage, dictionarySize, binaryDictionary), expectedValues);
        TestValuesDecoders.binaryBatchReadWithSkipHelper(89, 29, valueCount, TestValuesDecoders.binaryDictionary(dataPage, dictionarySize, binaryDictionary), expectedValues);
        TestValuesDecoders.binaryBatchReadWithSkipHelper(1024, 1024, valueCount, TestValuesDecoders.binaryDictionary(dataPage, dictionarySize, binaryDictionary), expectedValues);
    }

    @Test
    public void testInt64Plain() throws IOException {
        int valueCount = 2048;
        ArrayList<Object> expectedValues = new ArrayList<Object>();
        byte[] pageBytes = TestParquetUtils.generatePlainValuesPage(valueCount, 64, new Random(89L), expectedValues);
        TestValuesDecoders.int64BatchReadWithSkipHelper(valueCount, 0, valueCount, TestValuesDecoders.int64Plain(pageBytes), expectedValues);
        TestValuesDecoders.int64BatchReadWithSkipHelper(29, 0, valueCount, TestValuesDecoders.int64Plain(pageBytes), expectedValues);
        TestValuesDecoders.int64BatchReadWithSkipHelper(89, 0, valueCount, TestValuesDecoders.int64Plain(pageBytes), expectedValues);
        TestValuesDecoders.int64BatchReadWithSkipHelper(1024, 0, valueCount, TestValuesDecoders.int64Plain(pageBytes), expectedValues);
        TestValuesDecoders.int64BatchReadWithSkipHelper(256, 29, valueCount, TestValuesDecoders.int64Plain(pageBytes), expectedValues);
        TestValuesDecoders.int64BatchReadWithSkipHelper(89, 29, valueCount, TestValuesDecoders.int64Plain(pageBytes), expectedValues);
        TestValuesDecoders.int64BatchReadWithSkipHelper(1024, 1024, valueCount, TestValuesDecoders.int64Plain(pageBytes), expectedValues);
        List<Object> expectedTimestampValues = expectedValues.stream().map(v -> (Long)v / 1000L).collect(Collectors.toList());
        TestValuesDecoders.int64BatchReadWithSkipHelper(valueCount, 0, valueCount, TestValuesDecoders.int64TimestampMicrosPlain(pageBytes), expectedTimestampValues);
        TestValuesDecoders.int64BatchReadWithSkipHelper(29, 0, valueCount, TestValuesDecoders.int64TimestampMicrosPlain(pageBytes), expectedTimestampValues);
        TestValuesDecoders.int64BatchReadWithSkipHelper(89, 0, valueCount, TestValuesDecoders.int64TimestampMicrosPlain(pageBytes), expectedTimestampValues);
        TestValuesDecoders.int64BatchReadWithSkipHelper(1024, 0, valueCount, TestValuesDecoders.int64TimestampMicrosPlain(pageBytes), expectedTimestampValues);
        TestValuesDecoders.int64BatchReadWithSkipHelper(256, 29, valueCount, TestValuesDecoders.int64TimestampMicrosPlain(pageBytes), expectedTimestampValues);
        TestValuesDecoders.int64BatchReadWithSkipHelper(89, 29, valueCount, TestValuesDecoders.int64TimestampMicrosPlain(pageBytes), expectedTimestampValues);
        TestValuesDecoders.int64BatchReadWithSkipHelper(1024, 1024, valueCount, TestValuesDecoders.int64TimestampMicrosPlain(pageBytes), expectedTimestampValues);
    }

    @Test
    public void testInt64RLEDictionary() throws IOException {
        Random random = new Random(83L);
        int valueCount = 2048;
        int dictionarySize = 29;
        ArrayList<Object> dictionary = new ArrayList<Object>();
        ArrayList<Integer> dictionaryIds = new ArrayList<Integer>();
        byte[] dictionaryPage = TestParquetUtils.generatePlainValuesPage(dictionarySize, 64, random, dictionary);
        byte[] dataPage = TestParquetUtils.generateDictionaryIdPage2048(dictionarySize - 1, random, dictionaryIds);
        ArrayList<Object> expectedValues = new ArrayList<Object>();
        for (Integer dictionaryId : dictionaryIds) {
            expectedValues.add(dictionary.get(dictionaryId));
        }
        LongDictionary longDictionary = new LongDictionary(new DictionaryPage(Slices.wrappedBuffer((byte[])dictionaryPage), dictionarySize, ParquetEncoding.PLAIN_DICTIONARY));
        TestValuesDecoders.int64BatchReadWithSkipHelper(valueCount, 0, valueCount, TestValuesDecoders.int64Dictionary(dataPage, dictionarySize, longDictionary), expectedValues);
        TestValuesDecoders.int64BatchReadWithSkipHelper(29, 0, valueCount, TestValuesDecoders.int64Dictionary(dataPage, dictionarySize, longDictionary), expectedValues);
        TestValuesDecoders.int64BatchReadWithSkipHelper(89, 0, valueCount, TestValuesDecoders.int64Dictionary(dataPage, dictionarySize, longDictionary), expectedValues);
        TestValuesDecoders.int64BatchReadWithSkipHelper(1024, 0, valueCount, TestValuesDecoders.int64Dictionary(dataPage, dictionarySize, longDictionary), expectedValues);
        TestValuesDecoders.int64BatchReadWithSkipHelper(256, 29, valueCount, TestValuesDecoders.int64Dictionary(dataPage, dictionarySize, longDictionary), expectedValues);
        TestValuesDecoders.int64BatchReadWithSkipHelper(89, 29, valueCount, TestValuesDecoders.int64Dictionary(dataPage, dictionarySize, longDictionary), expectedValues);
        TestValuesDecoders.int64BatchReadWithSkipHelper(1024, 1024, valueCount, TestValuesDecoders.int64Dictionary(dataPage, dictionarySize, longDictionary), expectedValues);
        List<Object> expectedTimestampValues = expectedValues.stream().map(v -> (Long)v / 1000L).collect(Collectors.toList());
        TestValuesDecoders.int64BatchReadWithSkipHelper(valueCount, 0, valueCount, TestValuesDecoders.int64TimestampMicrosDictionary(dataPage, dictionarySize, longDictionary), expectedTimestampValues);
        TestValuesDecoders.int64BatchReadWithSkipHelper(29, 0, valueCount, TestValuesDecoders.int64TimestampMicrosDictionary(dataPage, dictionarySize, longDictionary), expectedTimestampValues);
        TestValuesDecoders.int64BatchReadWithSkipHelper(89, 0, valueCount, TestValuesDecoders.int64TimestampMicrosDictionary(dataPage, dictionarySize, longDictionary), expectedTimestampValues);
        TestValuesDecoders.int64BatchReadWithSkipHelper(1024, 0, valueCount, TestValuesDecoders.int64TimestampMicrosDictionary(dataPage, dictionarySize, longDictionary), expectedTimestampValues);
        TestValuesDecoders.int64BatchReadWithSkipHelper(256, 29, valueCount, TestValuesDecoders.int64TimestampMicrosDictionary(dataPage, dictionarySize, longDictionary), expectedTimestampValues);
        TestValuesDecoders.int64BatchReadWithSkipHelper(89, 29, valueCount, TestValuesDecoders.int64TimestampMicrosDictionary(dataPage, dictionarySize, longDictionary), expectedTimestampValues);
        TestValuesDecoders.int64BatchReadWithSkipHelper(1024, 1024, valueCount, TestValuesDecoders.int64TimestampMicrosDictionary(dataPage, dictionarySize, longDictionary), expectedTimestampValues);
    }

    @Test
    public void testTimestampPlain() throws IOException {
        int valueCount = 2048;
        ArrayList<Object> expectedValues = new ArrayList<Object>();
        byte[] pageBytes = TestParquetUtils.generatePlainValuesPage(valueCount, 96, new Random(83L), expectedValues);
        TestValuesDecoders.timestampBatchReadWithSkipHelper(valueCount, 0, valueCount, TestValuesDecoders.timestampPlain(pageBytes), expectedValues);
        TestValuesDecoders.timestampBatchReadWithSkipHelper(29, 0, valueCount, TestValuesDecoders.timestampPlain(pageBytes), expectedValues);
        TestValuesDecoders.timestampBatchReadWithSkipHelper(89, 0, valueCount, TestValuesDecoders.timestampPlain(pageBytes), expectedValues);
        TestValuesDecoders.timestampBatchReadWithSkipHelper(1024, 0, valueCount, TestValuesDecoders.timestampPlain(pageBytes), expectedValues);
        TestValuesDecoders.timestampBatchReadWithSkipHelper(256, 29, valueCount, TestValuesDecoders.timestampPlain(pageBytes), expectedValues);
        TestValuesDecoders.timestampBatchReadWithSkipHelper(89, 29, valueCount, TestValuesDecoders.timestampPlain(pageBytes), expectedValues);
        TestValuesDecoders.timestampBatchReadWithSkipHelper(1024, 1024, valueCount, TestValuesDecoders.timestampPlain(pageBytes), expectedValues);
    }

    @Test
    public void testTimestampRLEDictionary() throws IOException {
        Random random = new Random(83L);
        int valueCount = 2048;
        int dictionarySize = 29;
        ArrayList<Object> dictionary = new ArrayList<Object>();
        ArrayList<Integer> dictionaryIds = new ArrayList<Integer>();
        byte[] dictionaryPage = TestParquetUtils.generatePlainValuesPage(dictionarySize, 96, random, dictionary);
        byte[] dataPage = TestParquetUtils.generateDictionaryIdPage2048(dictionarySize - 1, random, dictionaryIds);
        ArrayList<Object> expectedValues = new ArrayList<Object>();
        for (Integer dictionaryId : dictionaryIds) {
            expectedValues.add(dictionary.get(dictionaryId));
        }
        TimestampDictionary tsDictionary = new TimestampDictionary(new DictionaryPage(Slices.wrappedBuffer((byte[])dictionaryPage), dictionarySize, ParquetEncoding.PLAIN_DICTIONARY));
        TestValuesDecoders.timestampBatchReadWithSkipHelper(valueCount, 0, valueCount, TestValuesDecoders.timestampDictionary(dataPage, dictionarySize, tsDictionary), expectedValues);
        TestValuesDecoders.timestampBatchReadWithSkipHelper(29, 0, valueCount, TestValuesDecoders.timestampDictionary(dataPage, dictionarySize, tsDictionary), expectedValues);
        TestValuesDecoders.timestampBatchReadWithSkipHelper(89, 0, valueCount, TestValuesDecoders.timestampDictionary(dataPage, dictionarySize, tsDictionary), expectedValues);
        TestValuesDecoders.timestampBatchReadWithSkipHelper(1024, 0, valueCount, TestValuesDecoders.timestampDictionary(dataPage, dictionarySize, tsDictionary), expectedValues);
        TestValuesDecoders.timestampBatchReadWithSkipHelper(256, 29, valueCount, TestValuesDecoders.timestampDictionary(dataPage, dictionarySize, tsDictionary), expectedValues);
        TestValuesDecoders.timestampBatchReadWithSkipHelper(89, 29, valueCount, TestValuesDecoders.timestampDictionary(dataPage, dictionarySize, tsDictionary), expectedValues);
        TestValuesDecoders.timestampBatchReadWithSkipHelper(1024, 1024, valueCount, TestValuesDecoders.timestampDictionary(dataPage, dictionarySize, tsDictionary), expectedValues);
    }

    @Test
    public void testBooleanPlain() {
        int valueCount = 2048;
        ArrayList<Object> expectedValues = new ArrayList<Object>();
        byte[] pageBytes = TestParquetUtils.generatePlainValuesPage(valueCount, 1, new Random(83L), expectedValues);
        TestValuesDecoders.booleanBatchReadWithSkipHelper(valueCount, 0, valueCount, TestValuesDecoders.booleanPlain(pageBytes), expectedValues);
        TestValuesDecoders.booleanBatchReadWithSkipHelper(29, 0, valueCount, TestValuesDecoders.booleanPlain(pageBytes), expectedValues);
        TestValuesDecoders.booleanBatchReadWithSkipHelper(89, 0, valueCount, TestValuesDecoders.booleanPlain(pageBytes), expectedValues);
        TestValuesDecoders.booleanBatchReadWithSkipHelper(1024, 0, valueCount, TestValuesDecoders.booleanPlain(pageBytes), expectedValues);
        TestValuesDecoders.booleanBatchReadWithSkipHelper(256, 29, valueCount, TestValuesDecoders.booleanPlain(pageBytes), expectedValues);
        TestValuesDecoders.booleanBatchReadWithSkipHelper(89, 29, valueCount, TestValuesDecoders.booleanPlain(pageBytes), expectedValues);
        TestValuesDecoders.booleanBatchReadWithSkipHelper(1024, 1024, valueCount, TestValuesDecoders.booleanPlain(pageBytes), expectedValues);
    }

    @Test
    public void testBooleanRLE() {
        Random random = new Random(111L);
        int valueCount = 2048;
        ArrayList<Integer> values = new ArrayList<Integer>();
        byte[] dataPage = TestParquetUtils.generateDictionaryIdPage2048(1, random, values);
        ArrayList<Object> expectedValues = new ArrayList<Object>();
        for (Integer value : values) {
            expectedValues.add((int)value);
        }
        TestValuesDecoders.booleanBatchReadWithSkipHelper(valueCount, 0, valueCount, TestValuesDecoders.booleanRLE(dataPage), expectedValues);
        TestValuesDecoders.booleanBatchReadWithSkipHelper(29, 0, valueCount, TestValuesDecoders.booleanRLE(dataPage), expectedValues);
        TestValuesDecoders.booleanBatchReadWithSkipHelper(89, 0, valueCount, TestValuesDecoders.booleanRLE(dataPage), expectedValues);
        TestValuesDecoders.booleanBatchReadWithSkipHelper(1024, 0, valueCount, TestValuesDecoders.booleanRLE(dataPage), expectedValues);
        TestValuesDecoders.booleanBatchReadWithSkipHelper(256, 29, valueCount, TestValuesDecoders.booleanRLE(dataPage), expectedValues);
        TestValuesDecoders.booleanBatchReadWithSkipHelper(89, 29, valueCount, TestValuesDecoders.booleanRLE(dataPage), expectedValues);
        TestValuesDecoders.booleanBatchReadWithSkipHelper(1024, 1024, valueCount, TestValuesDecoders.booleanRLE(dataPage), expectedValues);
    }
}

