/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.predicate;

import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.parquet.DictionaryPage;
import com.facebook.presto.parquet.ParquetEncoding;
import com.facebook.presto.parquet.predicate.DictionaryDescriptor;
import com.facebook.presto.parquet.predicate.TupleDomainParquetPredicate;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.schema.PrimitiveType;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.testng.annotations.Test;

@Fork(value=1)
@Warmup(iterations=5)
@Measurement(iterations=10)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkTupleDomainParquetPredicate {
    @Benchmark
    public List<?> domainFromDictionary(Data data) {
        ArrayList<Domain> result = new ArrayList<Domain>(data.bigintDictionaries.size());
        for (DictionaryDescriptor dictionary : data.bigintDictionaries) {
            result.add(TupleDomainParquetPredicate.getDomain((Type)BigintType.BIGINT, (DictionaryDescriptor)dictionary));
        }
        return result;
    }

    @Test
    public void test() {
        Data data = new Data();
        data.init();
        this.domainFromDictionary(data);
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkTupleDomainParquetPredicate.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class Data {
        public List<DictionaryDescriptor> bigintDictionaries;

        @Setup(value=Level.Iteration)
        public void init() {
            this.bigintDictionaries = new ArrayList<DictionaryDescriptor>();
            for (int i = 0; i < 1000; ++i) {
                this.bigintDictionaries.add(this.createBigintDictionary());
            }
        }

        private DictionaryDescriptor createBigintDictionary() {
            Slice slice;
            int size = 1000;
            try (DynamicSliceOutput sliceOutput = new DynamicSliceOutput(0);){
                for (int i = 0; i < size; ++i) {
                    sliceOutput.appendLong(ThreadLocalRandom.current().nextLong());
                }
                slice = sliceOutput.slice();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return new DictionaryDescriptor(new ColumnDescriptor(new String[]{"path"}, PrimitiveType.PrimitiveTypeName.INT64, 0, 0), Optional.of(new DictionaryPage(slice, slice.length(), size, ParquetEncoding.PLAIN)));
        }
    }
}

