/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.predicate;

import com.facebook.presto.parquet.predicate.PredicateUtils;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.EncodingStats;
import org.apache.parquet.column.statistics.BinaryStatistics;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.schema.PrimitiveType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPredicateUtils {
    @Test
    public void testDictionaryEncodingV1() {
        ImmutableSet required = ImmutableSet.of((Object)Encoding.BIT_PACKED);
        ImmutableSet optional = ImmutableSet.of((Object)Encoding.BIT_PACKED, (Object)Encoding.RLE);
        ImmutableSet repeated = ImmutableSet.of((Object)Encoding.RLE);
        ImmutableSet notDictionary = ImmutableSet.of((Object)Encoding.PLAIN);
        ImmutableSet mixedDictionary = ImmutableSet.of((Object)Encoding.PLAIN_DICTIONARY, (Object)Encoding.PLAIN);
        ImmutableSet dictionary = ImmutableSet.of((Object)Encoding.PLAIN_DICTIONARY);
        Assert.assertFalse((boolean)PredicateUtils.isOnlyDictionaryEncodingPages((ColumnChunkMetaData)this.createColumnMetaDataV1((Set<Encoding>)Sets.union((Set)required, (Set)notDictionary))), (String)"required notDictionary");
        Assert.assertFalse((boolean)PredicateUtils.isOnlyDictionaryEncodingPages((ColumnChunkMetaData)this.createColumnMetaDataV1((Set<Encoding>)Sets.union((Set)optional, (Set)notDictionary))), (String)"optional notDictionary");
        Assert.assertFalse((boolean)PredicateUtils.isOnlyDictionaryEncodingPages((ColumnChunkMetaData)this.createColumnMetaDataV1((Set<Encoding>)Sets.union((Set)repeated, (Set)notDictionary))), (String)"repeated notDictionary");
        Assert.assertFalse((boolean)PredicateUtils.isOnlyDictionaryEncodingPages((ColumnChunkMetaData)this.createColumnMetaDataV1((Set<Encoding>)Sets.union((Set)required, (Set)mixedDictionary))), (String)"required mixedDictionary");
        Assert.assertFalse((boolean)PredicateUtils.isOnlyDictionaryEncodingPages((ColumnChunkMetaData)this.createColumnMetaDataV1((Set<Encoding>)Sets.union((Set)optional, (Set)mixedDictionary))), (String)"optional mixedDictionary");
        Assert.assertFalse((boolean)PredicateUtils.isOnlyDictionaryEncodingPages((ColumnChunkMetaData)this.createColumnMetaDataV1((Set<Encoding>)Sets.union((Set)repeated, (Set)mixedDictionary))), (String)"repeated mixedDictionary");
        Assert.assertTrue((boolean)PredicateUtils.isOnlyDictionaryEncodingPages((ColumnChunkMetaData)this.createColumnMetaDataV1((Set<Encoding>)Sets.union((Set)required, (Set)dictionary))), (String)"required dictionary");
        Assert.assertTrue((boolean)PredicateUtils.isOnlyDictionaryEncodingPages((ColumnChunkMetaData)this.createColumnMetaDataV1((Set<Encoding>)Sets.union((Set)optional, (Set)dictionary))), (String)"optional dictionary");
        Assert.assertTrue((boolean)PredicateUtils.isOnlyDictionaryEncodingPages((ColumnChunkMetaData)this.createColumnMetaDataV1((Set<Encoding>)Sets.union((Set)repeated, (Set)dictionary))), (String)"repeated dictionary");
    }

    @Test
    public void testDictionaryEncodingV2() {
        Assert.assertTrue((boolean)PredicateUtils.isOnlyDictionaryEncodingPages((ColumnChunkMetaData)this.createColumnMetaDataV2(Encoding.RLE_DICTIONARY)));
        Assert.assertTrue((boolean)PredicateUtils.isOnlyDictionaryEncodingPages((ColumnChunkMetaData)this.createColumnMetaDataV2(Encoding.PLAIN_DICTIONARY)));
        Assert.assertFalse((boolean)PredicateUtils.isOnlyDictionaryEncodingPages((ColumnChunkMetaData)this.createColumnMetaDataV2(Encoding.PLAIN)));
        Assert.assertFalse((boolean)PredicateUtils.isOnlyDictionaryEncodingPages((ColumnChunkMetaData)this.createColumnMetaDataV2(Encoding.RLE_DICTIONARY, Encoding.PLAIN)));
    }

    private ColumnChunkMetaData createColumnMetaDataV2(Encoding ... dataEncodings) {
        EncodingStats encodingStats = new EncodingStats.Builder().withV2Pages().addDictEncoding(Encoding.PLAIN).addDataEncodings((Collection)ImmutableSet.copyOf((Object[])dataEncodings)).build();
        return ColumnChunkMetaData.get((ColumnPath)ColumnPath.fromDotString((String)"column"), (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (CompressionCodecName)CompressionCodecName.UNCOMPRESSED, (EncodingStats)encodingStats, (Set)encodingStats.getDataEncodings(), (Statistics)new BinaryStatistics(), (long)0L, (long)0L, (long)1L, (long)1L, (long)1L);
    }

    private ColumnChunkMetaData createColumnMetaDataV1(Set<Encoding> encodings) {
        return ColumnChunkMetaData.get((ColumnPath)ColumnPath.fromDotString((String)"column"), (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (CompressionCodecName)CompressionCodecName.UNCOMPRESSED, encodings, (Statistics)new BinaryStatistics(), (long)0L, (long)0L, (long)1L, (long)1L, (long)1L);
    }
}

