/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.reader;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.parquet.crypto.ColumnEncryptionProperties;
import org.apache.parquet.crypto.DecryptionKeyRetriever;
import org.apache.parquet.crypto.FileDecryptionProperties;
import org.apache.parquet.crypto.FileEncryptionProperties;
import org.apache.parquet.crypto.KeyAccessDeniedException;
import org.apache.parquet.crypto.ParquetCipher;
import org.apache.parquet.hadoop.metadata.ColumnPath;

public class EncryptDecryptUtil {
    private static final String FOOTER_KEY_METADATA = "footkey";
    private static final String COL_KEY_METADATA = "col";
    private static final String COL_KEY_MASKING_TEST_METADATA = "col_access_deny_for_decryption";
    private static final byte[] FOOTER_KEY = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
    private static final byte[] FOOTER_KEY_METADATA_BYTES = "footkey".getBytes(StandardCharsets.UTF_8);
    private static final byte[] COL_KEY = new byte[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17};
    private static final byte[] COL_KEY_ACCESS_DENY_FOR_DECRYPTION = new byte[]{3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18};
    private static final byte[] COL_KEY_METADATA_BYTES = "col".getBytes(StandardCharsets.UTF_8);
    private static final byte[] COL_KEY_MASKING_TEST_METADATA_BYTES = "col_access_deny_for_decryption".getBytes(StandardCharsets.UTF_8);

    private EncryptDecryptUtil() {
    }

    public static FileDecryptionProperties getFileDecryptionProperties() {
        DecryptionKeyRetrieverMock keyRetriever = new DecryptionKeyRetrieverMock();
        keyRetriever.putKey(FOOTER_KEY_METADATA, FOOTER_KEY);
        keyRetriever.putKey(COL_KEY_METADATA, COL_KEY);
        keyRetriever.putKey(COL_KEY_MASKING_TEST_METADATA, COL_KEY_ACCESS_DENY_FOR_DECRYPTION);
        return FileDecryptionProperties.builder().withPlaintextFilesAllowed().withKeyRetriever((DecryptionKeyRetriever)keyRetriever).build();
    }

    public static FileEncryptionProperties getFileEncryptionProperties(List<String> encryptColumns, ParquetCipher cipher, Boolean encryptFooter, Boolean dataMaskingTest) {
        if (encryptColumns.size() == 0) {
            return null;
        }
        HashMap<ColumnPath, ColumnEncryptionProperties> columnPropertyMap = new HashMap<ColumnPath, ColumnEncryptionProperties>();
        byte[] keyMetaData = dataMaskingTest != false ? COL_KEY_MASKING_TEST_METADATA_BYTES : COL_KEY_METADATA_BYTES;
        for (String encryptColumn : encryptColumns) {
            ColumnPath columnPath = ColumnPath.fromDotString((String)encryptColumn);
            ColumnEncryptionProperties columnEncryptionProperties = ColumnEncryptionProperties.builder((ColumnPath)columnPath).withKey(COL_KEY).withKeyMetaData(keyMetaData).build();
            columnPropertyMap.put(columnPath, columnEncryptionProperties);
        }
        FileEncryptionProperties.Builder encryptionPropertiesBuilder = FileEncryptionProperties.builder((byte[])FOOTER_KEY).withFooterKeyMetadata(FOOTER_KEY_METADATA_BYTES).withAlgorithm(cipher).withEncryptedColumns(columnPropertyMap);
        if (!encryptFooter.booleanValue()) {
            encryptionPropertiesBuilder.withPlaintextFooter();
        }
        return encryptionPropertiesBuilder.build();
    }

    private static class DecryptionKeyRetrieverMock
    implements DecryptionKeyRetriever {
        private final Map<String, byte[]> keyMap = new HashMap<String, byte[]>();

        private DecryptionKeyRetrieverMock() {
        }

        public DecryptionKeyRetrieverMock putKey(String keyId, byte[] keyBytes) {
            this.keyMap.put(keyId, keyBytes);
            return this;
        }

        public byte[] getKey(byte[] keyMetaData) {
            String keyId = new String(keyMetaData, StandardCharsets.UTF_8);
            if (EncryptDecryptUtil.COL_KEY_MASKING_TEST_METADATA.equals(new String(keyMetaData))) {
                throw new KeyAccessDeniedException();
            }
            return this.keyMap.get(keyId);
        }
    }
}

