/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.reader;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.example.data.simple.SimpleGroup;

public class EncryptionTestFile {
    private final String fileName;
    private final SimpleGroup[] fileContent;

    public EncryptionTestFile(String fileName, SimpleGroup[] fileContent) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)fileName) ? 1 : 0) != 0, (Object)"file name cannot be null or empty");
        this.fileName = fileName;
        Preconditions.checkArgument((fileContent != null && fileContent.length > 0 ? 1 : 0) != 0, (Object)"file content cannot be null or empty");
        this.fileContent = fileContent;
    }

    public String getFileName() {
        return this.fileName;
    }

    public SimpleGroup[] getFileContent() {
        return this.fileContent;
    }

    public long getFileSize() throws IOException {
        Path path = new Path(this.fileName);
        return path.getFileSystem(new Configuration()).getFileStatus(path).getLen();
    }
}

