/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.reader;

import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.fs.FSDataInputStream;

public final class MockInputStreamTail {
    public static final int MAX_SUPPORTED_PADDING_BYTES = 64;
    private static final int MAXIMUM_READ_LENGTH = 2147483582;
    private final Slice tailSlice;
    private final long fileSize;

    private MockInputStreamTail(long fileSize, Slice tailSlice) {
        this.tailSlice = Objects.requireNonNull(tailSlice, "tailSlice is null");
        this.fileSize = fileSize;
        Preconditions.checkArgument((fileSize >= 0L ? 1 : 0) != 0, (String)"fileSize is negative: %s", (long)fileSize);
        Preconditions.checkArgument(((long)tailSlice.length() <= fileSize ? 1 : 0) != 0, (String)"length (%s) is greater than fileSize (%s)", (int)tailSlice.length(), (long)fileSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MockInputStreamTail readTail(String path, long paddedFileSize, FSDataInputStream inputStream, int length) throws IOException {
        int bytesRead;
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (String)"length is negative: %s", (int)length);
        Preconditions.checkArgument((length <= 2147483582 ? 1 : 0) != 0, (String)"length (%s) exceeds maximum (%s)", (int)length, (int)2147483582);
        long readSize = Math.min(paddedFileSize, (long)(length + 64));
        long position = paddedFileSize - readSize;
        byte[] buffer = new byte[Math.toIntExact(readSize + 1L)];
        long startPos = inputStream.getPos();
        try {
            int n;
            inputStream.seek(position);
            for (bytesRead = 0; bytesRead < buffer.length; bytesRead += n) {
                n = inputStream.read(buffer, bytesRead, buffer.length - bytesRead);
                if (n >= 0) continue;
                break;
            }
        }
        finally {
            inputStream.seek(startPos);
        }
        if ((long)bytesRead > readSize) {
            throw MockInputStreamTail.rejectInvalidFileSize(path, paddedFileSize);
        }
        return new MockInputStreamTail(position + (long)bytesRead, Slices.wrappedBuffer((byte[])buffer, (int)Math.max(0, bytesRead - length), (int)Math.min(bytesRead, length)));
    }

    public static long readTailForFileSize(String path, long paddedFileSize, FSDataInputStream inputStream) throws IOException {
        long maxEOFAt = paddedFileSize + 1L;
        long startPos = inputStream.getPos();
        try {
            long position;
            inputStream.seek(position);
            for (position = Math.max(paddedFileSize - 64L, 0L); position < maxEOFAt; ++position) {
                int c = inputStream.read();
                if (c >= 0) continue;
                long l = position;
                return l;
            }
            throw MockInputStreamTail.rejectInvalidFileSize(path, paddedFileSize);
        }
        finally {
            inputStream.seek(startPos);
        }
    }

    private static IOException rejectInvalidFileSize(String path, long reportedSize) throws IOException {
        throw new IOException(String.format("Incorrect file size (%s) for file (end of stream not reached): %s", reportedSize, path));
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public Slice getTailSlice() {
        return this.tailSlice;
    }
}

