/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.reader;

import com.facebook.presto.common.NotSupportedException;
import com.facebook.presto.parquet.ParquetDataSource;
import com.facebook.presto.parquet.ParquetDataSourceId;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.internal.column.columnindex.ColumnIndex;
import org.apache.parquet.internal.column.columnindex.OffsetIndex;

public class MockParquetDataSource
implements ParquetDataSource {
    private final ParquetDataSourceId id;
    private final long estimatedSize;
    private final FSDataInputStream inputStream;
    private long readTimeNanos;
    private long readBytes;

    public MockParquetDataSource(ParquetDataSourceId id, long estimatedSize, FSDataInputStream inputStream) {
        this.id = Objects.requireNonNull(id, "id is null");
        this.estimatedSize = estimatedSize;
        this.inputStream = inputStream;
    }

    public ParquetDataSourceId getId() {
        return this.id;
    }

    public final long getReadBytes() {
        return this.readBytes;
    }

    public long getReadTimeNanos() {
        return this.readTimeNanos;
    }

    public void close() throws IOException {
        this.inputStream.close();
    }

    public final void readFully(long position, byte[] buffer) {
        this.readFully(position, buffer, 0, buffer.length);
    }

    public void readFully(long position, byte[] buffer, int bufferOffset, int bufferLength) {
        this.readBytes += (long)bufferLength;
        long start = System.nanoTime();
        try {
            this.inputStream.readFully(position, buffer, bufferOffset, bufferLength);
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading from %s " + this.id + " at position " + position);
        }
        long currentReadTimeNanos = System.nanoTime() - start;
        this.readTimeNanos += currentReadTimeNanos;
    }

    public Optional<ColumnIndex> readColumnIndex(ColumnChunkMetaData column) throws IOException {
        throw new NotSupportedException("Not supported");
    }

    public Optional<OffsetIndex> readOffsetIndex(ColumnChunkMetaData column) throws IOException {
        throw new NotSupportedException("Not supported");
    }
}

