/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.reader;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.parquet.Field;
import com.facebook.presto.parquet.GroupField;
import com.facebook.presto.parquet.ParquetDataSource;
import com.facebook.presto.parquet.ParquetDataSourceId;
import com.facebook.presto.parquet.ParquetTypeUtils;
import com.facebook.presto.parquet.PrimitiveField;
import com.facebook.presto.parquet.RichColumnDescriptor;
import com.facebook.presto.parquet.cache.MetadataReader;
import com.facebook.presto.parquet.reader.EncryptDecryptUtil;
import com.facebook.presto.parquet.reader.EncryptionTestFile;
import com.facebook.presto.parquet.reader.EncryptionTestFileBuilder;
import com.facebook.presto.parquet.reader.MockParquetDataSource;
import com.facebook.presto.parquet.reader.ParquetReader;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.crypto.FileDecryptionProperties;
import org.apache.parquet.crypto.InternalFileDecryptor;
import org.apache.parquet.crypto.ParquetCipher;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.ColumnIO;
import org.apache.parquet.io.ColumnIOUtil;
import org.apache.parquet.io.GroupColumnIO;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.io.PrimitiveColumnIO;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestEncryption {
    private final Configuration conf = new Configuration(false);

    @Test
    public void testBasicDecryption() throws IOException {
        MessageType schema = this.createSchema();
        String[] encryptColumns = new String[]{"name", "gender"};
        HashMap<String, String> extraMetadata = new HashMap<String, String>(){
            {
                this.put("key1", "value1");
                this.put("key2", "value2");
            }
        };
        EncryptionTestFile inputFile = new EncryptionTestFileBuilder(this.conf, schema).withEncryptColumns(encryptColumns).withNumRecord(10000).withCodec("GZIP").withExtraMeta((Map<String, String>)extraMetadata).withPageSize(1000).withFooterEncryption().build();
        this.decryptAndValidate(inputFile);
    }

    @Test
    public void testAllColumnsDecryption() throws IOException {
        MessageType schema = this.createSchema();
        String[] encryptColumns = new String[]{"id", "name", "gender"};
        EncryptionTestFile inputFile = new EncryptionTestFileBuilder(this.conf, schema).withEncryptColumns(encryptColumns).withNumRecord(10000).withCodec("GZIP").withPageSize(1000).withFooterEncryption().build();
        this.decryptAndValidate(inputFile);
    }

    @Test
    public void testNoColumnsDecryption() throws IOException {
        MessageType schema = this.createSchema();
        String[] encryptColumns = new String[]{};
        EncryptionTestFile inputFile = new EncryptionTestFileBuilder(this.conf, schema).withEncryptColumns(encryptColumns).withNumRecord(10000).withCodec("GZIP").withPageSize(1000).withFooterEncryption().build();
        this.decryptAndValidate(inputFile);
    }

    @Test
    public void testOneRecord() throws IOException {
        MessageType schema = this.createSchema();
        String[] encryptColumns = new String[]{"name", "gender"};
        EncryptionTestFile inputFile = new EncryptionTestFileBuilder(this.conf, schema).withEncryptColumns(encryptColumns).withNumRecord(1).withCodec("GZIP").withPageSize(1000).withFooterEncryption().build();
        this.decryptAndValidate(inputFile);
    }

    @Test
    public void testMillionRows() throws IOException {
        MessageType schema = this.createSchema();
        String[] encryptColumns = new String[]{"name", "gender"};
        EncryptionTestFile inputFile = new EncryptionTestFileBuilder(this.conf, schema).withEncryptColumns(encryptColumns).withNumRecord(1000000).withCodec("GZIP").withPageSize(1000).withFooterEncryption().build();
        this.decryptAndValidate(inputFile);
    }

    @Test
    public void testPlainTextFooter() throws IOException {
        MessageType schema = this.createSchema();
        String[] encryptColumns = new String[]{"name", "gender"};
        EncryptionTestFile inputFile = new EncryptionTestFileBuilder(this.conf, schema).withEncryptColumns(encryptColumns).withNumRecord(10000).withCodec("SNAPPY").withPageSize(1000).build();
        this.decryptAndValidate(inputFile);
    }

    @Test
    public void testLargePageSize() throws IOException {
        MessageType schema = this.createSchema();
        String[] encryptColumns = new String[]{"name", "gender"};
        EncryptionTestFile inputFile = new EncryptionTestFileBuilder(this.conf, schema).withEncryptColumns(encryptColumns).withNumRecord(100000).withCodec("GZIP").withPageSize(100000).withFooterEncryption().build();
        this.decryptAndValidate(inputFile);
    }

    @Test
    public void testAesGcmCtr() throws IOException {
        MessageType schema = this.createSchema();
        String[] encryptColumns = new String[]{"name", "gender"};
        EncryptionTestFile inputFile = new EncryptionTestFileBuilder(this.conf, schema).withEncryptColumns(encryptColumns).withNumRecord(100000).withCodec("GZIP").withPageSize(1000).withEncrytionAlgorithm(ParquetCipher.AES_GCM_CTR_V1).build();
        this.decryptAndValidate(inputFile);
    }

    @Test
    public void testDataMaskingSingleColumn() throws IOException {
        MessageType schema = this.createSchema();
        String[] encryptColumns = new String[]{"name"};
        String[] maskingColumn = new String[]{"name"};
        EncryptionTestFile inputFile = new EncryptionTestFileBuilder(this.conf, schema).withEncryptColumns(encryptColumns).withNumRecord(10000).withCodec("GZIP").withPageSize(1000).withFooterEncryption().withDataMaskingTest().build();
        this.validateMasking(inputFile, maskingColumn);
    }

    @Test
    public void testDataMaskingMultipleColumns() throws IOException {
        MessageType schema = this.createSchema();
        String[] encryptColumns = new String[]{"name", "gender"};
        String[] maskingColumn = new String[]{"name", "gender"};
        HashMap<String, String> extraMetadata = new HashMap<String, String>(){
            {
                this.put("key1", "value1");
                this.put("key2", "value2");
            }
        };
        EncryptionTestFile inputFile = new EncryptionTestFileBuilder(this.conf, schema).withEncryptColumns(encryptColumns).withNumRecord(10000).withCodec("GZIP").withExtraMeta((Map<String, String>)extraMetadata).withPageSize(1000).withFooterEncryption().withDataMaskingTest().build();
        this.validateMasking(inputFile, maskingColumn);
    }

    @Test
    public void testDataMaskingEncryptedFooter() throws IOException {
        MessageType schema = this.createSchema();
        String[] encryptColumns = new String[]{"name", "gender"};
        String[] maskingColumn = new String[]{"name", "gender"};
        HashMap<String, String> extraMetadata = new HashMap<String, String>(){
            {
                this.put("key1", "value1");
                this.put("key2", "value2");
            }
        };
        EncryptionTestFile inputFile = new EncryptionTestFileBuilder(this.conf, schema).withEncryptColumns(encryptColumns).withDataMaskingTest().withCodec("GZIP").withFooterEncryption().build();
        this.validateMasking(inputFile, maskingColumn);
    }

    @Test
    public void testDataMaskingPlaintextFooter() throws IOException {
        MessageType schema = this.createSchema();
        String[] encryptColumns = new String[]{"name", "gender"};
        String[] maskingColumn = new String[]{"name", "gender"};
        HashMap<String, String> extraMetadata = new HashMap<String, String>(){
            {
                this.put("key1", "value1");
                this.put("key2", "value2");
            }
        };
        EncryptionTestFile inputFile = new EncryptionTestFileBuilder(this.conf, schema).withEncryptColumns(encryptColumns).withDataMaskingTest().withCodec("GZIP").build();
        this.validateMasking(inputFile, maskingColumn);
    }

    @Test
    public void testDataMaskingGcmCtr() throws IOException {
        MessageType schema = this.createSchema();
        String[] encryptColumns = new String[]{"name", "gender"};
        String[] maskingColumn = new String[]{"name", "gender"};
        HashMap<String, String> extraMetadata = new HashMap<String, String>(){
            {
                this.put("key1", "value1");
                this.put("key2", "value2");
            }
        };
        EncryptionTestFile inputFile = new EncryptionTestFileBuilder(this.conf, schema).withEncryptColumns(encryptColumns).withDataMaskingTest().withCodec("GZIP").withEncrytionAlgorithm(ParquetCipher.AES_GCM_CTR_V1).build();
        this.validateMasking(inputFile, maskingColumn);
    }

    @Test
    public void testDataMaskingLargePage() throws IOException {
        MessageType schema = this.createSchema();
        String[] encryptColumns = new String[]{"name", "gender"};
        String[] maskingColumn = new String[]{"name", "gender"};
        HashMap<String, String> extraMetadata = new HashMap<String, String>(){
            {
                this.put("key1", "value1");
                this.put("key2", "value2");
            }
        };
        EncryptionTestFile inputFile = new EncryptionTestFileBuilder(this.conf, schema).withEncryptColumns(encryptColumns).withDataMaskingTest().withCodec("GZIP").withPageSize(100000).build();
        this.validateMasking(inputFile, maskingColumn);
    }

    @Test
    public void testDataMaskingOneRecord() throws IOException {
        MessageType schema = this.createSchema();
        String[] encryptColumns = new String[]{"name", "gender"};
        String[] maskingColumn = new String[]{"name", "gender"};
        HashMap<String, String> extraMetadata = new HashMap<String, String>(){
            {
                this.put("key1", "value1");
                this.put("key2", "value2");
            }
        };
        EncryptionTestFile inputFile = new EncryptionTestFileBuilder(this.conf, schema).withEncryptColumns(encryptColumns).withNumRecord(1).withDataMaskingTest().withCodec("GZIP").build();
        this.validateMasking(inputFile, maskingColumn);
    }

    @Test
    public void testDataMaskingAllColumns() throws IOException {
        MessageType schema = this.createSchema();
        String[] encryptColumns = new String[]{"id", "name", "gender"};
        String[] maskingColumn = new String[]{"id", "name", "gender"};
        HashMap<String, String> extraMetadata = new HashMap<String, String>(){
            {
                this.put("key1", "value1");
                this.put("key2", "value2");
            }
        };
        EncryptionTestFile inputFile = new EncryptionTestFileBuilder(this.conf, schema).withEncryptColumns(encryptColumns).withNumRecord(10000).withDataMaskingTest().withCodec("GZIP").build();
        this.validateMasking(inputFile, maskingColumn);
    }

    private MessageType createSchema() {
        return new MessageType("schema", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT64, "id"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "name"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "gender")});
    }

    private void decryptAndValidate(EncryptionTestFile inputFile) throws IOException {
        Path path = new Path(inputFile.getFileName());
        FileSystem fileSystem = path.getFileSystem(this.conf);
        FSDataInputStream inputStream = fileSystem.open(path);
        long fileSize = fileSystem.getFileStatus(path).getLen();
        Optional<InternalFileDecryptor> fileDecryptor = this.createFileDecryptor();
        MockParquetDataSource dataSource = new MockParquetDataSource(new ParquetDataSourceId(path.toString()), fileSize, inputStream);
        ParquetMetadata parquetMetadata = MetadataReader.readFooter((ParquetDataSource)dataSource, (long)inputFile.getFileSize(), fileDecryptor, (boolean)false).getParquetMetadata();
        FileMetaData fileMetaData = parquetMetadata.getFileMetaData();
        MessageType fileSchema = fileMetaData.getSchema();
        MessageColumnIO messageColumn = ParquetTypeUtils.getColumnIO((MessageType)fileSchema, (MessageType)fileSchema);
        ParquetReader parquetReader = this.createParquetReader(parquetMetadata, messageColumn, dataSource, fileDecryptor);
        this.validateFile(parquetReader, messageColumn, inputFile);
    }

    private void validateMasking(EncryptionTestFile inputFile, String[] maskingColumn) throws IOException {
        Path path = new Path(inputFile.getFileName());
        FileSystem fileSystem = path.getFileSystem(this.conf);
        FSDataInputStream inputStream = fileSystem.open(path);
        long fileSize = fileSystem.getFileStatus(path).getLen();
        Optional<InternalFileDecryptor> fileDecryptor = this.createFileDecryptor();
        MockParquetDataSource dataSource = new MockParquetDataSource(new ParquetDataSourceId(path.toString()), fileSize, inputStream);
        ParquetMetadata parquetMetadata = MetadataReader.readFooter((ParquetDataSource)dataSource, (long)inputFile.getFileSize(), fileDecryptor, (boolean)true).getParquetMetadata();
        FileMetaData fileMetaData = parquetMetadata.getFileMetaData();
        MessageType fileSchema = fileMetaData.getSchema();
        MessageColumnIO messageColumn = ParquetTypeUtils.getColumnIO((MessageType)fileSchema, (MessageType)fileSchema);
        ParquetReader parquetReader = this.createParquetReader(parquetMetadata, messageColumn, dataSource, fileDecryptor);
        this.validateFile(parquetReader, messageColumn, inputFile, maskingColumn);
    }

    private Optional<InternalFileDecryptor> createFileDecryptor() {
        FileDecryptionProperties fileDecryptionProperties = EncryptDecryptUtil.getFileDecryptionProperties();
        if (fileDecryptionProperties != null) {
            return Optional.of(new InternalFileDecryptor(fileDecryptionProperties));
        }
        return Optional.empty();
    }

    private ParquetReader createParquetReader(ParquetMetadata parquetMetadata, MessageColumnIO messageColumn, ParquetDataSource dataSource, Optional<InternalFileDecryptor> fileDecryptor) {
        ImmutableList.Builder blocks = ImmutableList.builder();
        ImmutableList.Builder blockStarts = ImmutableList.builder();
        long nextStart = 0L;
        for (BlockMetaData block : parquetMetadata.getBlocks()) {
            blocks.add((Object)block);
            blockStarts.add((Object)nextStart);
            nextStart += block.getRowCount();
        }
        return new ParquetReader(messageColumn, (List)blocks.build(), Optional.empty(), dataSource, AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), new DataSize(100000.0, DataSize.Unit.BYTE), false, false, null, null, false, fileDecryptor);
    }

    private void validateFile(ParquetReader parquetReader, MessageColumnIO messageColumn, EncryptionTestFile inputFile) throws IOException {
        String[] maskingColumn = new String[]{};
        this.validateFile(parquetReader, messageColumn, inputFile, maskingColumn);
    }

    private void validateFile(ParquetReader parquetReader, MessageColumnIO messageColumn, EncryptionTestFile inputFile, String[] maskingColumn) throws IOException {
        int rowIndex = 0;
        int batchSize = parquetReader.nextBatch();
        while (batchSize > 0) {
            this.validateColumn("id", (com.facebook.presto.common.type.Type)BigintType.BIGINT, rowIndex, parquetReader, messageColumn, inputFile, maskingColumn);
            this.validateColumn("name", (com.facebook.presto.common.type.Type)VarcharType.VARCHAR, rowIndex, parquetReader, messageColumn, inputFile, maskingColumn);
            this.validateColumn("gender", (com.facebook.presto.common.type.Type)VarcharType.VARCHAR, rowIndex, parquetReader, messageColumn, inputFile, maskingColumn);
            rowIndex += batchSize;
            batchSize = parquetReader.nextBatch();
        }
    }

    private void validateColumn(String name, com.facebook.presto.common.type.Type type, int rowIndex, ParquetReader parquetReader, MessageColumnIO messageColumn, EncryptionTestFile inputFile, String[] maskingColumn) throws IOException {
        HashSet<String> maskingColumnSet = new HashSet<String>(Arrays.asList(maskingColumn));
        if (maskingColumnSet.contains(name)) {
            Field columnIO = this.constructField(type, ParquetTypeUtils.lookupColumnByName((GroupColumnIO)messageColumn, (String)name)).orElse(null);
            Assert.assertNull((Object)columnIO);
        } else {
            Block block = parquetReader.readBlock((Field)this.constructField(type, ParquetTypeUtils.lookupColumnByName((GroupColumnIO)messageColumn, (String)name)).orElse(null));
            for (int i = 0; i < block.getPositionCount(); ++i) {
                if (type.equals(BigintType.BIGINT)) {
                    Assert.assertEquals((long)inputFile.getFileContent()[rowIndex++].getLong(name, 0), (long)block.getLong(i));
                    continue;
                }
                if (type.equals(PrimitiveType.PrimitiveTypeName.INT32)) {
                    Assert.assertEquals((int)inputFile.getFileContent()[rowIndex++].getInteger(name, 0), (int)block.getInt(i));
                    continue;
                }
                if (!type.equals(VarcharType.VARCHAR)) continue;
                Assert.assertEquals((String)inputFile.getFileContent()[rowIndex++].getString(name, 0), (String)block.getSlice(i, 0, block.getSliceLength(i)).toStringUtf8());
            }
        }
    }

    private Optional<Field> constructField(com.facebook.presto.common.type.Type type, ColumnIO columnIO) {
        if (columnIO == null) {
            return Optional.empty();
        }
        boolean required = columnIO.getType().getRepetition() != Type.Repetition.OPTIONAL;
        int repetitionLevel = ColumnIOUtil.columnRepetitionLevel((ColumnIO)columnIO);
        int definitionLevel = ColumnIOUtil.columnDefinitionLevel((ColumnIO)columnIO);
        if (type instanceof RowType) {
            RowType rowType = (RowType)type;
            GroupColumnIO groupColumnIO = (GroupColumnIO)columnIO;
            ImmutableList.Builder fieldsBuilder = ImmutableList.builder();
            List fields = rowType.getFields();
            boolean structHasParameters = false;
            for (int i = 0; i < fields.size(); ++i) {
                RowType.Field rowField = (RowType.Field)fields.get(i);
                String name = ((String)rowField.getName().get()).toLowerCase(Locale.ENGLISH);
                Optional<Field> field = this.constructField(rowField.getType(), ParquetTypeUtils.lookupColumnByName((GroupColumnIO)groupColumnIO, (String)name));
                structHasParameters |= field.isPresent();
                fieldsBuilder.add(field);
            }
            if (structHasParameters) {
                return Optional.of(new GroupField(type, repetitionLevel, definitionLevel, required, fieldsBuilder.build()));
            }
            return Optional.empty();
        }
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            GroupColumnIO groupColumnIO = (GroupColumnIO)columnIO;
            GroupColumnIO keyValueColumnIO = ParquetTypeUtils.getMapKeyValueColumn((GroupColumnIO)groupColumnIO);
            if (keyValueColumnIO.getChildrenCount() != 2) {
                return Optional.empty();
            }
            Optional<Field> keyField = this.constructField(mapType.getKeyType(), keyValueColumnIO.getChild(0));
            Optional<Field> valueField = this.constructField(mapType.getValueType(), keyValueColumnIO.getChild(1));
            return Optional.of(new GroupField(type, repetitionLevel, definitionLevel, required, ImmutableList.of(keyField, valueField)));
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            GroupColumnIO groupColumnIO = (GroupColumnIO)columnIO;
            if (groupColumnIO.getChildrenCount() != 1) {
                return Optional.empty();
            }
            Optional<Field> field = this.constructField(arrayType.getElementType(), ParquetTypeUtils.getArrayElementColumn((ColumnIO)groupColumnIO.getChild(0)));
            return Optional.of(new GroupField(type, repetitionLevel, definitionLevel, required, ImmutableList.of(field)));
        }
        PrimitiveColumnIO primitiveColumnIO = (PrimitiveColumnIO)columnIO;
        RichColumnDescriptor column = new RichColumnDescriptor(primitiveColumnIO.getColumnDescriptor(), columnIO.getType().asPrimitiveType());
        return Optional.of(new PrimitiveField(type, repetitionLevel, definitionLevel, required, column, primitiveColumnIO.getId()));
    }
}

