/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.reader;

import java.util.Collections;
import java.util.Set;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.crypto.HiddenColumnChunkMetaData;
import org.apache.parquet.crypto.HiddenColumnException;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.schema.PrimitiveType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestHiddenColumnChunkMetaData {
    @Test
    public void testIsHiddenColumn() {
        HiddenColumnChunkMetaData column = new HiddenColumnChunkMetaData(ColumnPath.fromDotString((String)"a.b.c"), "hdfs:/foo/bar/a.parquet");
        Assert.assertTrue((boolean)HiddenColumnChunkMetaData.isHiddenColumn((ColumnChunkMetaData)column));
    }

    @Test
    public void testIsNotHiddenColumn() {
        Set<Encoding> encodingSet = Collections.singleton(Encoding.RLE);
        ColumnChunkMetaData column = ColumnChunkMetaData.get((ColumnPath)ColumnPath.fromDotString((String)"a.b.c"), (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (CompressionCodecName)CompressionCodecName.GZIP, encodingSet, (long)-1L, (long)-1L, (long)-1L, (long)-1L, (long)-1L);
        Assert.assertFalse((boolean)HiddenColumnChunkMetaData.isHiddenColumn((ColumnChunkMetaData)column));
    }

    @Test(expectedExceptions={HiddenColumnException.class})
    public void testHiddenColumnException() {
        HiddenColumnChunkMetaData column = new HiddenColumnChunkMetaData(ColumnPath.fromDotString((String)"a.b.c"), "hdfs:/foo/bar/a.parquet");
        column.getStatistics();
    }

    @Test
    public void testNoHiddenColumnException() {
        Set<Encoding> encodingSet = Collections.singleton(Encoding.RLE);
        ColumnChunkMetaData column = ColumnChunkMetaData.get((ColumnPath)ColumnPath.fromDotString((String)"a.b.c"), (PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY, (CompressionCodecName)CompressionCodecName.GZIP, encodingSet, (long)-1L, (long)-1L, (long)-1L, (long)-1L, (long)-1L);
        column.getStatistics();
    }
}

