/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.reader;

import java.util.HashSet;
import org.apache.parquet.crypto.ParquetCryptoMetaDataUtils;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestParquetCryptoMetaDataUtils {
    @Test
    public void testRemoveColumnsInSchema() {
        MessageType schema = new MessageType("schema", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "DocId"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "Name"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "Gender"), new GroupType(Type.Repetition.OPTIONAL, "Links", new Type[]{new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.INT64, "Backward"), new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.INT64, "Forward")})});
        HashSet<ColumnPath> paths = new HashSet<ColumnPath>();
        paths.add(ColumnPath.fromDotString((String)"Name"));
        MessageType newSchema = ParquetCryptoMetaDataUtils.removeColumnsInSchema((MessageType)schema, paths);
        String[] docId = new String[]{"DocId"};
        Assert.assertTrue((boolean)newSchema.containsPath(docId));
        String[] gender = new String[]{"Gender"};
        Assert.assertTrue((boolean)newSchema.containsPath(gender));
        String[] linkForward = new String[]{"Links", "Forward"};
        Assert.assertTrue((boolean)newSchema.containsPath(linkForward));
        String[] name = new String[]{"Name"};
        Assert.assertFalse((boolean)newSchema.containsPath(name));
    }

    @Test
    public void testRemoveNestedColumnsInSchema() {
        MessageType schema = new MessageType("schema", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "DocId"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "Name"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "Gender"), new GroupType(Type.Repetition.OPTIONAL, "Links", new Type[]{new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.INT64, "Backward"), new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.INT64, "Forward")})});
        HashSet<ColumnPath> paths = new HashSet<ColumnPath>();
        paths.add(ColumnPath.fromDotString((String)"Links.Backward"));
        MessageType newSchema = ParquetCryptoMetaDataUtils.removeColumnsInSchema((MessageType)schema, paths);
        String[] docId = new String[]{"DocId"};
        Assert.assertTrue((boolean)newSchema.containsPath(docId));
        String[] gender = new String[]{"Gender"};
        Assert.assertTrue((boolean)newSchema.containsPath(gender));
        String[] name = new String[]{"Name"};
        Assert.assertTrue((boolean)newSchema.containsPath(name));
        String[] linkForward = new String[]{"Links", "Forward"};
        Assert.assertTrue((boolean)newSchema.containsPath(linkForward));
        String[] linkBackward = new String[]{"Links", "Backward"};
        Assert.assertFalse((boolean)newSchema.containsPath(linkBackward));
    }
}

