/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.writer;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.parquet.writer.ParquetSchemaConverter;
import com.facebook.presto.tests.StructuralTestUtil;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestParquetSchemaConverter {
    @Test
    public void testMapKeyRepetitionLevel() {
        ParquetSchemaConverter schemaConverter = new ParquetSchemaConverter((List)ImmutableList.of((Object)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)IntegerType.INTEGER)), (List)ImmutableList.of((Object)"test"));
        GroupType mapType = schemaConverter.getMessageType().getType(0).asGroupType();
        GroupType keyValueValue = mapType.getType(0).asGroupType();
        Assert.assertEquals((boolean)keyValueValue.isRepetition(Type.Repetition.REPEATED), (boolean)true);
        PrimitiveType keyType = keyValueValue.getType(0).asPrimitiveType();
        Assert.assertEquals((boolean)keyType.isRepetition(Type.Repetition.REQUIRED), (boolean)true);
        PrimitiveType valueType = keyValueValue.getType(1).asPrimitiveType();
        Assert.assertEquals((boolean)valueType.isRepetition(Type.Repetition.OPTIONAL), (boolean)true);
        schemaConverter = new ParquetSchemaConverter((List)ImmutableList.of((Object)StructuralTestUtil.mapType((Type)RowType.from(Arrays.asList(RowType.field((String)"a", (Type)VarcharType.VARCHAR), RowType.field((String)"b", (Type)BigintType.BIGINT))), (Type)IntegerType.INTEGER)), (List)ImmutableList.of((Object)"test"));
        mapType = schemaConverter.getMessageType().getType(0).asGroupType();
        keyValueValue = mapType.getType(0).asGroupType();
        Assert.assertEquals((boolean)keyValueValue.isRepetition(Type.Repetition.REPEATED), (boolean)true);
        keyType = keyValueValue.getType(0).asGroupType();
        Assert.assertEquals((boolean)keyType.isRepetition(Type.Repetition.REQUIRED), (boolean)true);
        Assert.assertEquals((boolean)keyType.asGroupType().getType(0).asPrimitiveType().isRepetition(Type.Repetition.OPTIONAL), (boolean)true);
        Assert.assertEquals((boolean)keyType.asGroupType().getType(1).asPrimitiveType().isRepetition(Type.Repetition.OPTIONAL), (boolean)true);
        valueType = keyValueValue.getType(1).asPrimitiveType();
        Assert.assertEquals((boolean)valueType.isRepetition(Type.Repetition.OPTIONAL), (boolean)true);
    }
}

