/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet;

import com.facebook.presto.parquet.Page;
import com.facebook.presto.parquet.ParquetEncoding;
import com.google.common.base.MoreObjects;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Objects;

public class DictionaryPage
extends Page {
    private final Slice slice;
    private final int dictionarySize;
    private final ParquetEncoding encoding;

    public DictionaryPage(Slice slice, int dictionarySize, ParquetEncoding encoding) {
        this(Objects.requireNonNull(slice, "slice is null"), slice.length(), dictionarySize, Objects.requireNonNull(encoding, "encoding is null"));
    }

    public DictionaryPage(Slice slice, int uncompressedSize, int dictionarySize, ParquetEncoding encoding) {
        super(Objects.requireNonNull(slice, "slice is null").length(), uncompressedSize);
        this.slice = slice;
        this.dictionarySize = dictionarySize;
        this.encoding = Objects.requireNonNull(encoding, "encoding is null");
    }

    @Override
    public Slice getSlice() {
        return this.slice;
    }

    public int getDictionarySize() {
        return this.dictionarySize;
    }

    public ParquetEncoding getEncoding() {
        return this.encoding;
    }

    public DictionaryPage copy() {
        return new DictionaryPage(Slices.copyOf((Slice)this.slice), this.getUncompressedSize(), this.dictionarySize, this.encoding);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("slice", (Object)this.slice).add("dictionarySize", this.dictionarySize).add("encoding", (Object)this.encoding).add("compressedSize", this.compressedSize).add("uncompressedSize", this.uncompressedSize).toString();
    }
}

