/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.writer;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.parquet.writer.levels.DefinitionLevelIterable;
import com.facebook.presto.parquet.writer.levels.RepetitionLevelIterable;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public class ColumnChunk {
    private final Block block;
    private final List<DefinitionLevelIterable> definitionLevelIterables;
    private final List<RepetitionLevelIterable> repetitionLevelIterables;

    public ColumnChunk(Block block) {
        this(block, (List<DefinitionLevelIterable>)ImmutableList.of(), (List<RepetitionLevelIterable>)ImmutableList.of());
    }

    public ColumnChunk(Block block, List<DefinitionLevelIterable> definitionLevelIterables, List<RepetitionLevelIterable> repetitionLevelIterables) {
        this.block = Objects.requireNonNull(block, "block is null");
        this.definitionLevelIterables = ImmutableList.copyOf(definitionLevelIterables);
        this.repetitionLevelIterables = ImmutableList.copyOf(repetitionLevelIterables);
    }

    public List<DefinitionLevelIterable> getDefinitionLevelIterables() {
        return this.definitionLevelIterables;
    }

    public List<RepetitionLevelIterable> getRepetitionLevelIterables() {
        return this.repetitionLevelIterables;
    }

    public Block getBlock() {
        return this.block;
    }
}

