/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.batchreader.decoders.delta;

import com.facebook.presto.parquet.batchreader.decoders.ValuesDecoder;
import java.io.IOException;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.column.values.delta.DeltaBinaryPackingValuesReader;
import org.openjdk.jol.info.ClassLayout;

public class Int32DeltaBinaryPackedValuesDecoder
implements ValuesDecoder.Int32ValuesDecoder {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(Int32DeltaBinaryPackedValuesDecoder.class).instanceSize();
    private final DeltaBinaryPackingValuesReader innerReader = new DeltaBinaryPackingValuesReader();

    public Int32DeltaBinaryPackedValuesDecoder(int valueCount, ByteBufferInputStream bufferInputStream) throws IOException {
        this.innerReader.initFromPage(valueCount, bufferInputStream);
    }

    @Override
    public void readNext(int[] values, int offset, int length) {
        int endOffset = offset + length;
        for (int i = offset; i < endOffset; ++i) {
            values[i] = this.innerReader.readInteger();
        }
    }

    @Override
    public void skip(int length) {
        while (length > 0) {
            this.innerReader.skip();
            --length;
        }
    }

    @Override
    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE;
    }
}

