/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.batchreader.decoders.rle;

import com.facebook.presto.parquet.batchreader.decoders.ValuesDecoder;
import com.facebook.presto.parquet.batchreader.decoders.rle.BaseRLEBitPackedDecoder;
import com.facebook.presto.parquet.dictionary.LongDictionary;
import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import java.io.IOException;
import java.io.InputStream;
import org.apache.parquet.io.ParquetDecodingException;
import org.openjdk.jol.info.ClassLayout;

public class Int64RLEDictionaryValuesDecoder
extends BaseRLEBitPackedDecoder
implements ValuesDecoder.Int64ValuesDecoder {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(Int64RLEDictionaryValuesDecoder.class).instanceSize();
    private final LongDictionary dictionary;

    public Int64RLEDictionaryValuesDecoder(int bitWidth, InputStream inputStream, LongDictionary dictionary) {
        super(Integer.MAX_VALUE, bitWidth, inputStream);
        this.dictionary = dictionary;
    }

    @Override
    public void readNext(long[] values, int offset, int length) throws IOException {
        int remainingToCopy;
        int numEntriesToFill;
        int destinationIndex = offset;
        for (remainingToCopy = length; remainingToCopy > 0 && (this.currentCount != 0 || this.decode()); remainingToCopy -= numEntriesToFill) {
            numEntriesToFill = Math.min(remainingToCopy, this.currentCount);
            int endIndex = destinationIndex + numEntriesToFill;
            switch (this.mode) {
                case RLE: {
                    int rleValue = this.currentValue;
                    long rleDictionaryValue = this.dictionary.decodeToLong(rleValue);
                    while (destinationIndex < endIndex) {
                        values[destinationIndex++] = rleDictionaryValue;
                    }
                    break;
                }
                case PACKED: {
                    int[] localBuffer = this.currentBuffer;
                    LongDictionary localDictionary = this.dictionary;
                    int srcIndex = this.currentBuffer.length - this.currentCount;
                    while (destinationIndex < endIndex) {
                        long dictionaryValue = localDictionary.decodeToLong(localBuffer[srcIndex]);
                        values[destinationIndex++] = dictionaryValue;
                        ++srcIndex;
                    }
                    break;
                }
                default: {
                    throw new ParquetDecodingException("not a valid mode " + (Object)((Object)this.mode));
                }
            }
            this.currentCount -= numEntriesToFill;
        }
        Preconditions.checkState((remainingToCopy == 0 ? 1 : 0) != 0, (Object)"End of stream: Invalid read size request");
    }

    @Override
    public void skip(int length) throws IOException {
        int remaining;
        int chunkSize;
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (String)"invalid length %s", (int)length);
        for (remaining = length; remaining > 0 && (this.currentCount != 0 || this.decode()); remaining -= chunkSize) {
            chunkSize = Math.min(remaining, this.currentCount);
            this.currentCount -= chunkSize;
        }
        Preconditions.checkState((remaining == 0 ? 1 : 0) != 0, (String)"End of stream: Invalid skip size request: %s", (int)length);
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + (this.dictionary == null ? 0L : this.dictionary.getRetainedSizeInBytes()) + SizeOf.sizeOf((int[])this.currentBuffer);
    }
}

