/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.reader;

import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.parquet.DataPage;
import com.facebook.presto.parquet.DataPageV1;
import com.facebook.presto.parquet.DataPageV2;
import com.facebook.presto.parquet.DictionaryPage;
import com.facebook.presto.parquet.Page;
import com.facebook.presto.parquet.ParquetCorruptionException;
import com.facebook.presto.parquet.ParquetTypeUtils;
import com.facebook.presto.parquet.cache.MetadataReader;
import com.facebook.presto.parquet.reader.ColumnChunkDescriptor;
import com.facebook.presto.parquet.reader.PageReader;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.EncodingStats;
import org.apache.parquet.crypto.AesCipher;
import org.apache.parquet.crypto.InternalColumnDecryptionSetup;
import org.apache.parquet.crypto.InternalFileDecryptor;
import org.apache.parquet.crypto.ModuleCipherFactory;
import org.apache.parquet.format.BlockCipher;
import org.apache.parquet.format.DataPageHeader;
import org.apache.parquet.format.DataPageHeaderV2;
import org.apache.parquet.format.DictionaryPageHeader;
import org.apache.parquet.format.PageHeader;
import org.apache.parquet.format.Util;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.internal.column.columnindex.OffsetIndex;
import org.openjdk.jol.info.ClassLayout;

public class ParquetColumnChunk
implements Closeable {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(ParquetColumnChunk.class).instanceSize();
    private final ColumnChunkDescriptor descriptor;
    private final ColumnChunkBufferedInputStream stream;
    private final OffsetIndex offsetIndex;
    private final LocalMemoryContext memoryContext;

    public ParquetColumnChunk(ColumnChunkDescriptor descriptor, ColumnChunkBufferedInputStream stream, Optional<OffsetIndex> offsetIndex, LocalMemoryContext memoryContext) {
        this.descriptor = Objects.requireNonNull(descriptor);
        this.stream = stream;
        this.offsetIndex = Objects.requireNonNull(offsetIndex).orElse(null);
        this.memoryContext = Objects.requireNonNull(memoryContext, "ParquetColumnChunk memoryContext is null");
    }

    public ColumnChunkDescriptor getDescriptor() {
        return this.descriptor;
    }

    protected PageHeader readPageHeader(BlockCipher.Decryptor headerBlockDecryptor, byte[] pageHeaderAAD) throws IOException {
        return Util.readPageHeader((InputStream)this.stream, (BlockCipher.Decryptor)headerBlockDecryptor, (byte[])pageHeaderAAD);
    }

    public PageReader buildPageReader(Optional<InternalFileDecryptor> fileDecryptor, int rowGroupOrdinal, int columnOrdinal) throws IOException {
        byte[] dataPageHeaderAdditionalAuthenticationData = null;
        BlockCipher.Decryptor headerBlockDecryptor = null;
        InternalColumnDecryptionSetup columnDecryptionSetup = null;
        if (fileDecryptor.isPresent()) {
            ColumnPath columnPath = ColumnPath.get((String[])this.descriptor.getColumnDescriptor().getPath());
            columnDecryptionSetup = fileDecryptor.get().getColumnSetup(columnPath);
            headerBlockDecryptor = columnDecryptionSetup.getMetaDataDecryptor();
            if (headerBlockDecryptor != null) {
                dataPageHeaderAdditionalAuthenticationData = AesCipher.createModuleAAD((byte[])fileDecryptor.get().getFileAAD(), (ModuleCipherFactory.ModuleType)ModuleCipherFactory.ModuleType.DataPageHeader, (int)rowGroupOrdinal, (int)columnOrdinal, (int)0);
            }
        }
        DictionaryPage dictionaryPage = null;
        if (this.hasDictionaryPage(this.descriptor.getColumnChunkMetaData())) {
            byte[] pageHeaderAAD = headerBlockDecryptor != null ? AesCipher.createModuleAAD((byte[])fileDecryptor.get().getFileAAD(), (ModuleCipherFactory.ModuleType)ModuleCipherFactory.ModuleType.DictionaryPageHeader, (int)rowGroupOrdinal, (int)columnOrdinal, (int)-1) : null;
            PageHeader pageHeader = this.readPageHeader(headerBlockDecryptor, pageHeaderAAD);
            int uncompressedPageSize = pageHeader.getUncompressed_page_size();
            int compressedPageSize = pageHeader.getCompressed_page_size();
            dictionaryPage = this.readDictionaryPage(pageHeader, uncompressedPageSize, compressedPageSize);
        }
        Iterator<DataPage> dataPageIterator = this.getDataPageIterator(dataPageHeaderAdditionalAuthenticationData, headerBlockDecryptor, dictionaryPage);
        byte[] fileAdditionalAuthenticationData = fileDecryptor.map(InternalFileDecryptor::getFileAAD).orElse(null);
        Optional<BlockCipher.Decryptor> dataDecryptor = this.getDataDecryptor(columnDecryptionSetup);
        long totalValueCount = this.descriptor.getColumnChunkMetaData().getValueCount();
        return new PageReader(this.descriptor.getColumnChunkMetaData().getCodec(), dataPageIterator, totalValueCount, dictionaryPage, this.offsetIndex, dataDecryptor, fileAdditionalAuthenticationData, rowGroupOrdinal, columnOrdinal);
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
        this.memoryContext.close();
    }

    private Iterator<DataPage> getDataPageIterator(final byte[] dataPageHeaderAdditionalAuthenticationData, final BlockCipher.Decryptor headerBlockDecryptor, final DictionaryPage dictionaryPage) {
        return new Iterator<DataPage>(){
            private int valueCount;
            private int dataPageCount;
            private int pageOrdinal;

            @Override
            public boolean hasNext() {
                return ParquetColumnChunk.this.hasMorePages(this.valueCount, this.dataPageCount);
            }

            @Override
            public DataPage next() {
                Page readPage = null;
                try {
                    byte[] pageHeaderAadditionalAuthenticationData = dataPageHeaderAdditionalAuthenticationData;
                    if (headerBlockDecryptor != null) {
                        AesCipher.quickUpdatePageAAD((byte[])dataPageHeaderAdditionalAuthenticationData, (int)this.pageOrdinal);
                    }
                    PageHeader pageHeader = ParquetColumnChunk.this.readPageHeader(headerBlockDecryptor, pageHeaderAadditionalAuthenticationData);
                    int uncompressedPageSize = pageHeader.getUncompressed_page_size();
                    int compressedPageSize = pageHeader.getCompressed_page_size();
                    switch (pageHeader.type) {
                        case DICTIONARY_PAGE: {
                            if (dictionaryPage == null) break;
                            throw new ParquetCorruptionException("%s has more than one dictionary page in column chunk", ParquetColumnChunk.this.descriptor.getColumnDescriptor());
                        }
                        case DATA_PAGE: {
                            long firstRowIndex = PageReader.getFirstRowIndex(this.dataPageCount, ParquetColumnChunk.this.offsetIndex);
                            readPage = ParquetColumnChunk.this.readDataPageV1(pageHeader, uncompressedPageSize, compressedPageSize, firstRowIndex);
                            this.valueCount += pageHeader.getData_page_header().getNum_values();
                            ++this.dataPageCount;
                            ++this.pageOrdinal;
                            break;
                        }
                        case DATA_PAGE_V2: {
                            long firstRowIndex = PageReader.getFirstRowIndex(this.dataPageCount, ParquetColumnChunk.this.offsetIndex);
                            readPage = ParquetColumnChunk.this.readDataPageV2(pageHeader, uncompressedPageSize, compressedPageSize, firstRowIndex);
                            this.valueCount += pageHeader.getData_page_header_v2().getNum_values();
                            ++this.dataPageCount;
                            ++this.pageOrdinal;
                            break;
                        }
                        default: {
                            ParquetColumnChunk.this.stream.skip(compressedPageSize);
                        }
                    }
                    ParquetColumnChunk.this.memoryContext.setBytes(ParquetColumnChunk.this.getRetainedSizeInBytes() + SizeOf.sizeOf((byte[])pageHeaderAadditionalAuthenticationData) + readPage.getRetainedSizeInBytes());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return readPage;
            }
        };
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.stream.getRetainedSizeInBytes();
    }

    private Optional<BlockCipher.Decryptor> getDataDecryptor(InternalColumnDecryptionSetup columnDecryptionSetup) {
        if (columnDecryptionSetup == null || columnDecryptionSetup.getDataDecryptor() == null) {
            return Optional.empty();
        }
        return Optional.of(columnDecryptionSetup.getDataDecryptor());
    }

    private Slice getSlice(int size) throws IOException {
        byte[] buffer = new byte[size];
        this.stream.read(buffer);
        return Slices.wrappedBuffer((byte[])buffer, (int)0, (int)size);
    }

    private DictionaryPage readDictionaryPage(PageHeader pageHeader, int uncompressedPageSize, int compressedPageSize) throws IOException {
        DictionaryPageHeader dictHeader = pageHeader.getDictionary_page_header();
        return new DictionaryPage(this.getSlice(compressedPageSize), uncompressedPageSize, dictHeader.getNum_values(), ParquetTypeUtils.getParquetEncoding(Encoding.valueOf((String)dictHeader.getEncoding().name())));
    }

    private DataPageV1 readDataPageV1(PageHeader pageHeader, int uncompressedPageSize, int compressedPageSize, long firstRowIndex) throws IOException {
        DataPageHeader dataHeaderV1 = pageHeader.getData_page_header();
        return new DataPageV1(this.getSlice(compressedPageSize), dataHeaderV1.getNum_values(), uncompressedPageSize, firstRowIndex, MetadataReader.readStats(dataHeaderV1.getStatistics(), this.descriptor.getColumnDescriptor().getType()), ParquetTypeUtils.getParquetEncoding(Encoding.valueOf((String)dataHeaderV1.getRepetition_level_encoding().name())), ParquetTypeUtils.getParquetEncoding(Encoding.valueOf((String)dataHeaderV1.getDefinition_level_encoding().name())), ParquetTypeUtils.getParquetEncoding(Encoding.valueOf((String)dataHeaderV1.getEncoding().name())));
    }

    private DataPageV2 readDataPageV2(PageHeader pageHeader, int uncompressedPageSize, int compressedPageSize, long firstRowIndex) throws IOException {
        DataPageHeaderV2 dataHeaderV2 = pageHeader.getData_page_header_v2();
        int dataSize = compressedPageSize - dataHeaderV2.getRepetition_levels_byte_length() - dataHeaderV2.getDefinition_levels_byte_length();
        return new DataPageV2(dataHeaderV2.getNum_rows(), dataHeaderV2.getNum_nulls(), dataHeaderV2.getNum_values(), firstRowIndex, this.getSlice(dataHeaderV2.getRepetition_levels_byte_length()), this.getSlice(dataHeaderV2.getDefinition_levels_byte_length()), ParquetTypeUtils.getParquetEncoding(Encoding.valueOf((String)dataHeaderV2.getEncoding().name())), this.getSlice(dataSize), uncompressedPageSize, MetadataReader.readStats(dataHeaderV2.getStatistics(), this.descriptor.getColumnDescriptor().getType()), dataHeaderV2.isIs_compressed());
    }

    private boolean hasMorePages(long valuesCount, int pagesCount) {
        return this.offsetIndex == null ? valuesCount < this.descriptor.getColumnChunkMetaData().getValueCount() : pagesCount < this.offsetIndex.getPageCount();
    }

    private boolean hasDictionaryPage(ColumnChunkMetaData columnChunkMetaData) {
        EncodingStats stats = columnChunkMetaData.getEncodingStats();
        if (stats != null) {
            return stats.hasDictionaryPages() && stats.hasDictionaryEncodedPages();
        }
        Set encodings = columnChunkMetaData.getEncodings();
        return encodings.contains(Encoding.PLAIN_DICTIONARY) || encodings.contains(Encoding.RLE_DICTIONARY);
    }

    static class ColumnChunkBufferedInputStream
    extends BufferedInputStream {
        private int bufferSize;

        ColumnChunkBufferedInputStream(InputStream inputStream, int bufferSize) {
            super(Objects.requireNonNull(inputStream), bufferSize);
            this.bufferSize = bufferSize;
        }

        long getRetainedSizeInBytes() {
            return this.bufferSize;
        }
    }
}

