/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.writer;

import io.airlift.units.DataSize;
import java.util.Objects;

public class ParquetWriterOptions {
    private static final DataSize DEFAULT_MAX_ROW_GROUP_SIZE = DataSize.valueOf((String)"128MB");
    private static final DataSize DEFAULT_MAX_PAGE_SIZE = DataSize.valueOf((String)"1MB");
    private final int maxRowGroupSize;
    private final int maxPageSize;

    public static Builder builder() {
        return new Builder();
    }

    private ParquetWriterOptions(DataSize maxRowGroupSize, DataSize maxPageSize) {
        this.maxRowGroupSize = Math.toIntExact(Objects.requireNonNull(maxRowGroupSize, "maxRowGroupSize is null").toBytes());
        this.maxPageSize = Math.toIntExact(Objects.requireNonNull(maxPageSize, "maxPageSize is null").toBytes());
    }

    public int getMaxRowGroupSize() {
        return this.maxRowGroupSize;
    }

    public int getMaxPageSize() {
        return this.maxPageSize;
    }

    static /* synthetic */ DataSize access$000() {
        return DEFAULT_MAX_ROW_GROUP_SIZE;
    }

    static /* synthetic */ DataSize access$100() {
        return DEFAULT_MAX_PAGE_SIZE;
    }

    public static class Builder {
        private DataSize maxBlockSize = ParquetWriterOptions.access$000();
        private DataSize maxPageSize = ParquetWriterOptions.access$100();

        public Builder setMaxBlockSize(DataSize maxBlockSize) {
            this.maxBlockSize = maxBlockSize;
            return this;
        }

        public Builder setMaxPageSize(DataSize maxPageSize) {
            this.maxPageSize = maxPageSize;
            return this;
        }

        public ParquetWriterOptions build() {
            return new ParquetWriterOptions(this.maxBlockSize, this.maxPageSize);
        }
    }
}

