/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.writer;

import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.CharType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.parquet.writer.ArrayColumnWriter;
import com.facebook.presto.parquet.writer.ColumnWriter;
import com.facebook.presto.parquet.writer.MapColumnWriter;
import com.facebook.presto.parquet.writer.ParquetTypeVisitor;
import com.facebook.presto.parquet.writer.PrimitiveColumnWriter;
import com.facebook.presto.parquet.writer.StructColumnWriter;
import com.facebook.presto.parquet.writer.valuewriter.BigintValueWriter;
import com.facebook.presto.parquet.writer.valuewriter.BooleanValueWriter;
import com.facebook.presto.parquet.writer.valuewriter.CharValueWriter;
import com.facebook.presto.parquet.writer.valuewriter.DateValueWriter;
import com.facebook.presto.parquet.writer.valuewriter.DecimalValueWriter;
import com.facebook.presto.parquet.writer.valuewriter.DoubleValueWriter;
import com.facebook.presto.parquet.writer.valuewriter.IntegerValueWriter;
import com.facebook.presto.parquet.writer.valuewriter.PrimitiveValueWriter;
import com.facebook.presto.parquet.writer.valuewriter.RealValueWriter;
import com.facebook.presto.parquet.writer.valuewriter.TimestampValueWriter;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

class ParquetWriters {
    private ParquetWriters() {
    }

    static List<ColumnWriter> getColumnWriters(MessageType messageType, Map<List<String>, com.facebook.presto.common.type.Type> prestoTypes, ParquetProperties parquetProperties, CompressionCodecName compressionCodecName) {
        WriterBuilder writeBuilder = new WriterBuilder(messageType, prestoTypes, parquetProperties, compressionCodecName);
        ParquetTypeVisitor.visit((Type)messageType, writeBuilder);
        return writeBuilder.build();
    }

    private static PrimitiveValueWriter getValueWriter(ValuesWriter valuesWriter, com.facebook.presto.common.type.Type type, PrimitiveType parquetType) {
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return new BooleanValueWriter(valuesWriter, parquetType);
        }
        if (IntegerType.INTEGER.equals((Object)type) || SmallintType.SMALLINT.equals((Object)type) || TinyintType.TINYINT.equals((Object)type)) {
            return new IntegerValueWriter(valuesWriter, type, parquetType);
        }
        if (type instanceof DecimalType) {
            return new DecimalValueWriter(valuesWriter, type, parquetType);
        }
        if (DateType.DATE.equals((Object)type)) {
            return new DateValueWriter(valuesWriter, parquetType);
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return new BigintValueWriter(valuesWriter, type, parquetType);
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return new DoubleValueWriter(valuesWriter, parquetType);
        }
        if (RealType.REAL.equals((Object)type)) {
            return new RealValueWriter(valuesWriter, parquetType);
        }
        if (TimestampType.TIMESTAMP.equals((Object)type)) {
            return new TimestampValueWriter(valuesWriter, type, parquetType);
        }
        if (type instanceof VarcharType || type instanceof CharType || type instanceof VarbinaryType) {
            return new CharValueWriter(valuesWriter, type, parquetType);
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported type for Parquet writer: %s", type));
    }

    private static class WriterBuilder
    extends ParquetTypeVisitor<ColumnWriter> {
        private final MessageType type;
        private final Map<List<String>, com.facebook.presto.common.type.Type> prestoTypes;
        private final ParquetProperties parquetProperties;
        private final CompressionCodecName compressionCodecName;
        private final ImmutableList.Builder<ColumnWriter> builder = ImmutableList.builder();

        WriterBuilder(MessageType messageType, Map<List<String>, com.facebook.presto.common.type.Type> prestoTypes, ParquetProperties parquetProperties, CompressionCodecName compressionCodecName) {
            this.type = Objects.requireNonNull(messageType, "messageType is null");
            this.prestoTypes = Objects.requireNonNull(prestoTypes, "prestoTypes is null");
            this.parquetProperties = Objects.requireNonNull(parquetProperties, "parquetProperties is null");
            this.compressionCodecName = Objects.requireNonNull(compressionCodecName, "compressionCodecName is null");
        }

        List<ColumnWriter> build() {
            return this.builder.build();
        }

        @Override
        public ColumnWriter message(MessageType message, List<ColumnWriter> fields) {
            this.builder.addAll(fields);
            return super.message(message, fields);
        }

        @Override
        public ColumnWriter struct(GroupType struct, List<ColumnWriter> fields) {
            String[] path = this.currentPath();
            int fieldDefinitionLevel = this.type.getMaxDefinitionLevel(path);
            int fieldRepetitionLevel = this.type.getMaxRepetitionLevel(path);
            return new StructColumnWriter((List<ColumnWriter>)ImmutableList.copyOf(fields), fieldDefinitionLevel, fieldRepetitionLevel);
        }

        @Override
        public ColumnWriter list(GroupType array, ColumnWriter element) {
            String[] path = this.currentPath();
            int fieldDefinitionLevel = this.type.getMaxDefinitionLevel(path);
            int fieldRepetitionLevel = this.type.getMaxRepetitionLevel(path);
            return new ArrayColumnWriter(element, fieldDefinitionLevel, fieldRepetitionLevel);
        }

        @Override
        public ColumnWriter map(GroupType map, ColumnWriter key, ColumnWriter value) {
            String[] path = this.currentPath();
            int fieldDefinitionLevel = this.type.getMaxDefinitionLevel(path);
            int fieldRepetitionLevel = this.type.getMaxRepetitionLevel(path);
            return new MapColumnWriter(key, value, fieldDefinitionLevel, fieldRepetitionLevel);
        }

        @Override
        public ColumnWriter primitive(PrimitiveType primitive) {
            Object[] path = this.currentPath();
            int fieldDefinitionLevel = this.type.getMaxDefinitionLevel((String[])path);
            int fieldRepetitionLevel = this.type.getMaxRepetitionLevel((String[])path);
            ColumnDescriptor columnDescriptor = new ColumnDescriptor((String[])path, primitive, fieldRepetitionLevel, fieldDefinitionLevel);
            com.facebook.presto.common.type.Type prestoType = Objects.requireNonNull(this.prestoTypes.get(ImmutableList.copyOf((Object[])path)), " presto type is null");
            return new PrimitiveColumnWriter(prestoType, columnDescriptor, ParquetWriters.getValueWriter(this.parquetProperties.newValuesWriter(columnDescriptor), prestoType, columnDescriptor.getPrimitiveType()), this.parquetProperties.newDefinitionLevelEncoder(columnDescriptor), this.parquetProperties.newRepetitionLevelEncoder(columnDescriptor), this.compressionCodecName, this.parquetProperties.getPageSizeThreshold());
        }

        private String[] currentPath() {
            String[] path = new String[this.fieldNames.size()];
            if (!this.fieldNames.isEmpty()) {
                Iterator iter = this.fieldNames.descendingIterator();
                int i = 0;
                while (iter.hasNext()) {
                    path[i] = (String)iter.next();
                    ++i;
                }
            }
            return path;
        }
    }
}

