/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.writer.levels;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.ColumnarArray;
import com.facebook.presto.common.block.ColumnarMap;
import com.facebook.presto.common.block.ColumnarRow;
import com.facebook.presto.parquet.writer.levels.DefinitionLevelIterable;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;

public class DefinitionLevelIterables {
    private DefinitionLevelIterables() {
    }

    public static DefinitionLevelIterable of(Block block, int maxDefinitionLevel) {
        return new PrimitiveDefinitionLevelIterable(block, maxDefinitionLevel);
    }

    public static DefinitionLevelIterable of(ColumnarRow columnarRow, int maxDefinitionLevel) {
        return new ColumnRowDefinitionLevelIterable(columnarRow, maxDefinitionLevel);
    }

    public static DefinitionLevelIterable of(ColumnarArray columnarArray, int maxDefinitionLevel) {
        return new ColumnArrayDefinitionLevelIterable(columnarArray, maxDefinitionLevel);
    }

    public static DefinitionLevelIterable of(ColumnarMap columnarMap, int maxDefinitionLevel) {
        return new ColumnMapDefinitionLevelIterable(columnarMap, maxDefinitionLevel);
    }

    public static Iterator<Integer> getIterator(List<DefinitionLevelIterable> iterables) {
        return new NestedDefinitionLevelIterator(iterables);
    }

    static class NestedDefinitionLevelIterator
    extends AbstractIterator<Integer> {
        private final List<DefinitionLevelIterable.DefinitionLevelIterator> iterators;
        private int iteratorIndex;

        NestedDefinitionLevelIterator(List<DefinitionLevelIterable> iterables) {
            this.iterators = (List)iterables.stream().map(DefinitionLevelIterable::getIterator).collect(ImmutableList.toImmutableList());
        }

        protected Integer computeNext() {
            DefinitionLevelIterable.DefinitionLevelIterator current = this.iterators.get(this.iteratorIndex);
            while (this.iteratorIndex > 0 && current.end()) {
                --this.iteratorIndex;
                current = this.iterators.get(this.iteratorIndex);
            }
            while (current.hasNext()) {
                OptionalInt next = (OptionalInt)current.next();
                if (next.isPresent()) {
                    return next.getAsInt();
                }
                ++this.iteratorIndex;
                current = this.iterators.get(this.iteratorIndex);
            }
            Preconditions.checkState((boolean)this.iterators.stream().noneMatch(AbstractIterator::hasNext));
            return (Integer)this.endOfData();
        }
    }

    static class ColumnArrayDefinitionLevelIterable
    implements DefinitionLevelIterable {
        private final ColumnarArray columnarArray;
        private final int maxDefinitionLevel;

        ColumnArrayDefinitionLevelIterable(ColumnarArray columnarArray, int maxDefinitionLevel) {
            this.columnarArray = Objects.requireNonNull(columnarArray, "columnarArray is null");
            this.maxDefinitionLevel = maxDefinitionLevel;
        }

        @Override
        public DefinitionLevelIterable.DefinitionLevelIterator getIterator() {
            return new DefinitionLevelIterable.DefinitionLevelIterator(){
                private int position = -1;
                private Iterator<OptionalInt> iterator;

                @Override
                boolean end() {
                    return this.iterator == null || !this.iterator.hasNext();
                }

                protected OptionalInt computeNext() {
                    if (this.iterator != null && this.iterator.hasNext()) {
                        return this.iterator.next();
                    }
                    ++this.position;
                    if (this.position == columnarArray.getPositionCount()) {
                        return (OptionalInt)this.endOfData();
                    }
                    if (columnarArray.isNull(this.position)) {
                        return OptionalInt.of(maxDefinitionLevel - 2);
                    }
                    int arrayLength = columnarArray.getLength(this.position);
                    if (arrayLength == 0) {
                        return OptionalInt.of(maxDefinitionLevel - 1);
                    }
                    this.iterator = Collections.nCopies(arrayLength, OptionalInt.empty()).iterator();
                    return this.iterator.next();
                }
            };
        }
    }

    static class ColumnMapDefinitionLevelIterable
    implements DefinitionLevelIterable {
        private final ColumnarMap columnarMap;
        private final int maxDefinitionLevel;

        ColumnMapDefinitionLevelIterable(ColumnarMap columnarMap, int maxDefinitionLevel) {
            this.columnarMap = Objects.requireNonNull(columnarMap, "columnarMap is null");
            this.maxDefinitionLevel = maxDefinitionLevel;
        }

        @Override
        public DefinitionLevelIterable.DefinitionLevelIterator getIterator() {
            return new DefinitionLevelIterable.DefinitionLevelIterator(){
                private int position = -1;
                private Iterator<OptionalInt> iterator;

                @Override
                boolean end() {
                    return this.iterator == null || !this.iterator.hasNext();
                }

                protected OptionalInt computeNext() {
                    if (this.iterator != null && this.iterator.hasNext()) {
                        return this.iterator.next();
                    }
                    ++this.position;
                    if (this.position == columnarMap.getPositionCount()) {
                        return (OptionalInt)this.endOfData();
                    }
                    if (columnarMap.isNull(this.position)) {
                        return OptionalInt.of(maxDefinitionLevel - 2);
                    }
                    int arrayLength = columnarMap.getEntryCount(this.position);
                    if (arrayLength == 0) {
                        return OptionalInt.of(maxDefinitionLevel - 1);
                    }
                    this.iterator = Collections.nCopies(arrayLength, OptionalInt.empty()).iterator();
                    return this.iterator.next();
                }
            };
        }
    }

    static class ColumnRowDefinitionLevelIterable
    implements DefinitionLevelIterable {
        private final ColumnarRow columnarRow;
        private final int maxDefinitionLevel;

        ColumnRowDefinitionLevelIterable(ColumnarRow columnarRow, int maxDefinitionLevel) {
            this.columnarRow = Objects.requireNonNull(columnarRow, "columnarRow is null");
            this.maxDefinitionLevel = maxDefinitionLevel;
        }

        @Override
        public DefinitionLevelIterable.DefinitionLevelIterator getIterator() {
            return new DefinitionLevelIterable.DefinitionLevelIterator(){
                private int position = -1;

                @Override
                boolean end() {
                    return true;
                }

                protected OptionalInt computeNext() {
                    ++this.position;
                    if (this.position == columnarRow.getPositionCount()) {
                        return (OptionalInt)this.endOfData();
                    }
                    if (columnarRow.isNull(this.position)) {
                        return OptionalInt.of(maxDefinitionLevel - 1);
                    }
                    return OptionalInt.empty();
                }
            };
        }
    }

    static class PrimitiveDefinitionLevelIterable
    implements DefinitionLevelIterable {
        private final Block block;
        private final int maxDefinitionLevel;

        PrimitiveDefinitionLevelIterable(Block block, int maxDefinitionLevel) {
            this.block = Objects.requireNonNull(block, "block is null");
            this.maxDefinitionLevel = maxDefinitionLevel;
        }

        @Override
        public DefinitionLevelIterable.DefinitionLevelIterator getIterator() {
            return new DefinitionLevelIterable.DefinitionLevelIterator(){
                private int position = -1;

                @Override
                boolean end() {
                    return true;
                }

                protected OptionalInt computeNext() {
                    ++this.position;
                    if (this.position == block.getPositionCount()) {
                        return (OptionalInt)this.endOfData();
                    }
                    if (block.isNull(this.position)) {
                        return OptionalInt.of(maxDefinitionLevel - 1);
                    }
                    return OptionalInt.of(maxDefinitionLevel);
                }
            };
        }
    }
}

