/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.batchreader;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.block.VariableWidthBlock;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.parquet.ColumnReader;
import com.facebook.presto.parquet.DataPage;
import com.facebook.presto.parquet.DictionaryPage;
import com.facebook.presto.parquet.Field;
import com.facebook.presto.parquet.ParquetErrorCode;
import com.facebook.presto.parquet.RichColumnDescriptor;
import com.facebook.presto.parquet.batchreader.ValuesDecoderContext;
import com.facebook.presto.parquet.batchreader.decoders.Decoders;
import com.facebook.presto.parquet.batchreader.decoders.FlatDefinitionLevelDecoder;
import com.facebook.presto.parquet.batchreader.decoders.ValuesDecoder;
import com.facebook.presto.parquet.batchreader.dictionary.Dictionaries;
import com.facebook.presto.parquet.dictionary.Dictionary;
import com.facebook.presto.parquet.reader.ColumnChunk;
import com.facebook.presto.parquet.reader.PageReader;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import org.apache.parquet.internal.filter2.columnindex.RowRanges;
import org.openjdk.jol.info.ClassLayout;

public class BinaryFlatBatchReader
implements ColumnReader {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(BinaryFlatBatchReader.class).instanceSize();
    private final RichColumnDescriptor columnDescriptor;
    protected Field field;
    protected int nextBatchSize;
    protected FlatDefinitionLevelDecoder definitionLevelDecoder;
    protected ValuesDecoder.BinaryValuesDecoder valuesDecoder;
    protected int remainingCountInPage;
    private Dictionary dictionary;
    private int readOffset;
    private PageReader pageReader;

    public BinaryFlatBatchReader(RichColumnDescriptor columnDescriptor) {
        this.columnDescriptor = Objects.requireNonNull(columnDescriptor, "columnDescriptor is null");
    }

    @Override
    public boolean isInitialized() {
        return this.pageReader != null && this.field != null;
    }

    @Override
    public void init(PageReader pageReader, Field field, RowRanges rowRanges) {
        Preconditions.checkArgument((!this.isInitialized() ? 1 : 0) != 0, (Object)"Parquet batch reader already initialized");
        this.pageReader = Objects.requireNonNull(pageReader, "pageReader is null");
        Preconditions.checkArgument((pageReader.getValueCountInColumnChunk() > 0L ? 1 : 0) != 0, (Object)"page is empty");
        this.field = Objects.requireNonNull(field, "field is null");
        DictionaryPage dictionaryPage = pageReader.readDictionaryPage();
        if (dictionaryPage != null) {
            this.dictionary = Dictionaries.createDictionary(this.columnDescriptor, dictionaryPage);
        }
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public ColumnChunk readNext() {
        ColumnChunk columnChunk = null;
        try {
            this.seek();
            columnChunk = this.field.isRequired() ? this.readWithoutNull() : this.readWithNull();
        }
        catch (IOException ex) {
            throw new PrestoException((ErrorCodeSupplier)ParquetErrorCode.PARQUET_IO_READ_ERROR, "Error reading Parquet column " + (Object)((Object)this.columnDescriptor), (Throwable)ex);
        }
        this.readOffset = 0;
        this.nextBatchSize = 0;
        return columnChunk;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + (this.definitionLevelDecoder == null ? 0L : this.definitionLevelDecoder.getRetainedSizeInBytes()) + (this.valuesDecoder == null ? 0L : this.valuesDecoder.getRetainedSizeInBytes()) + (this.dictionary == null ? 0L : this.dictionary.getRetainedSizeInBytes()) + (this.pageReader == null ? 0L : this.pageReader.getRetainedSizeInBytes());
    }

    protected boolean readNextPage() {
        this.definitionLevelDecoder = null;
        this.valuesDecoder = null;
        this.remainingCountInPage = 0;
        DataPage page = this.pageReader.readPage();
        if (page == null) {
            return false;
        }
        Decoders.FlatDecoders flatDecoders = Decoders.readFlatPage(page, this.columnDescriptor, this.dictionary);
        this.definitionLevelDecoder = flatDecoders.getDefinitionLevelDecoder();
        this.valuesDecoder = (ValuesDecoder.BinaryValuesDecoder)flatDecoders.getValuesDecoder();
        this.remainingCountInPage = page.getValueCount();
        return true;
    }

    private ColumnChunk readWithNull() throws IOException {
        boolean[] isNull = new boolean[this.nextBatchSize];
        ArrayList<ValuesDecoder.BinaryValuesDecoder.ValueBuffer> valueBuffers = new ArrayList<ValuesDecoder.BinaryValuesDecoder.ValueBuffer>();
        ArrayList<ValuesDecoderContext<ValuesDecoder.BinaryValuesDecoder>> valuesDecoderContexts = new ArrayList<ValuesDecoderContext<ValuesDecoder.BinaryValuesDecoder>>();
        int bufferSize = 0;
        int totalNonNullCount = 0;
        int remainingInBatch = this.nextBatchSize;
        int startOffset = 0;
        while (remainingInBatch > 0 && (this.remainingCountInPage != 0 || this.readNextPage())) {
            int readChunkSize = Math.min(this.remainingCountInPage, remainingInBatch);
            int nonNullCount = this.definitionLevelDecoder.readNext(isNull, startOffset, readChunkSize);
            totalNonNullCount += nonNullCount;
            ValuesDecoder.BinaryValuesDecoder.ValueBuffer valueBuffer = this.valuesDecoder.readNext(nonNullCount);
            bufferSize += valueBuffer.getBufferSize();
            valueBuffers.add(valueBuffer);
            ValuesDecoderContext<ValuesDecoder.BinaryValuesDecoder> valuesDecoderContext = new ValuesDecoderContext<ValuesDecoder.BinaryValuesDecoder>(this.valuesDecoder, startOffset, startOffset + readChunkSize);
            valuesDecoderContext.setValueCount(readChunkSize);
            valuesDecoderContext.setNonNullCount(nonNullCount);
            valuesDecoderContexts.add(valuesDecoderContext);
            startOffset += readChunkSize;
            remainingInBatch -= readChunkSize;
            this.remainingCountInPage -= readChunkSize;
        }
        if (totalNonNullCount == 0) {
            Block block = RunLengthEncodedBlock.create((Type)this.field.getType(), null, (int)this.nextBatchSize);
            return new ColumnChunk(block, new int[0], new int[0]);
        }
        byte[] byteBuffer = new byte[bufferSize];
        int[] offsets = new int[this.nextBatchSize + 1];
        int i = 0;
        int bufferIndex = 0;
        int offsetIndex = 0;
        for (ValuesDecoderContext valuesDecoderContext : valuesDecoderContexts) {
            ValuesDecoder.BinaryValuesDecoder binaryValuesDecoder = (ValuesDecoder.BinaryValuesDecoder)valuesDecoderContext.getValuesDecoder();
            ValuesDecoder.BinaryValuesDecoder.ValueBuffer value = (ValuesDecoder.BinaryValuesDecoder.ValueBuffer)valueBuffers.get(i);
            bufferIndex = binaryValuesDecoder.readIntoBuffer(byteBuffer, bufferIndex, offsets, offsetIndex, value);
            offsetIndex += valuesDecoderContext.getValueCount();
            ++i;
        }
        Collections.reverse(valuesDecoderContexts);
        for (ValuesDecoderContext valuesDecoderContext : valuesDecoderContexts) {
            int sourceIndex = valuesDecoderContext.getStart() + valuesDecoderContext.getNonNullCount() - 1;
            offsets[destinationIndex + 1] = offsets[sourceIndex + 1];
            for (int destinationIndex = valuesDecoderContext.getEnd() - 1; destinationIndex >= valuesDecoderContext.getStart(); --destinationIndex) {
                if (isNull[destinationIndex]) {
                    offsets[destinationIndex] = offsets[sourceIndex + 1];
                    continue;
                }
                offsets[destinationIndex] = offsets[sourceIndex];
                --sourceIndex;
            }
        }
        Slice buffer = Slices.wrappedBuffer((byte[])byteBuffer, (int)0, (int)bufferSize);
        boolean bl = totalNonNullCount == this.nextBatchSize;
        VariableWidthBlock block = new VariableWidthBlock(this.nextBatchSize, buffer, offsets, bl ? Optional.empty() : Optional.of(isNull));
        return new ColumnChunk((Block)block, new int[0], new int[0]);
    }

    private ColumnChunk readWithoutNull() throws IOException {
        boolean[] isNull = new boolean[this.nextBatchSize];
        ArrayList<ValuesDecoder.BinaryValuesDecoder.ValueBuffer> valueBuffers = new ArrayList<ValuesDecoder.BinaryValuesDecoder.ValueBuffer>();
        ArrayList<ValuesDecoderContext<ValuesDecoder.BinaryValuesDecoder>> valuesDecoderContexts = new ArrayList<ValuesDecoderContext<ValuesDecoder.BinaryValuesDecoder>>();
        int bufferSize = 0;
        int remainingInBatch = this.nextBatchSize;
        int startOffset = 0;
        while (remainingInBatch > 0 && (this.remainingCountInPage != 0 || this.readNextPage())) {
            int readChunkSize = Math.min(this.remainingCountInPage, remainingInBatch);
            ValuesDecoder.BinaryValuesDecoder.ValueBuffer valueBuffer = this.valuesDecoder.readNext(readChunkSize);
            bufferSize += valueBuffer.getBufferSize();
            valueBuffers.add(valueBuffer);
            ValuesDecoderContext<ValuesDecoder.BinaryValuesDecoder> valuesDecoderContext = new ValuesDecoderContext<ValuesDecoder.BinaryValuesDecoder>(this.valuesDecoder, startOffset, startOffset + readChunkSize);
            valuesDecoderContext.setValueCount(readChunkSize);
            valuesDecoderContext.setNonNullCount(readChunkSize);
            valuesDecoderContexts.add(valuesDecoderContext);
            startOffset += readChunkSize;
            remainingInBatch -= readChunkSize;
            this.remainingCountInPage -= readChunkSize;
        }
        byte[] byteBuffer = new byte[bufferSize];
        int[] offsets = new int[this.nextBatchSize + 1];
        int i = 0;
        int bufferIndex = 0;
        int offsetIndex = 0;
        for (ValuesDecoderContext valuesDecoderContext : valuesDecoderContexts) {
            ValuesDecoder.BinaryValuesDecoder binaryValuesDecoder = (ValuesDecoder.BinaryValuesDecoder)valuesDecoderContext.getValuesDecoder();
            ValuesDecoder.BinaryValuesDecoder.ValueBuffer value = (ValuesDecoder.BinaryValuesDecoder.ValueBuffer)valueBuffers.get(i);
            bufferIndex = binaryValuesDecoder.readIntoBuffer(byteBuffer, bufferIndex, offsets, offsetIndex, value);
            offsetIndex += valuesDecoderContext.getValueCount();
            ++i;
        }
        Slice buffer = Slices.wrappedBuffer((byte[])byteBuffer, (int)0, (int)bufferSize);
        VariableWidthBlock variableWidthBlock = new VariableWidthBlock(this.nextBatchSize, buffer, offsets, Optional.of(isNull));
        return new ColumnChunk((Block)variableWidthBlock, new int[0], new int[0]);
    }

    private void seek() throws IOException {
        if (this.readOffset == 0) {
            return;
        }
        int remainingInBatch = this.readOffset;
        int startOffset = 0;
        while (remainingInBatch > 0 && (this.remainingCountInPage != 0 || this.readNextPage())) {
            int chunkSize;
            int skipSize = chunkSize = Math.min(this.remainingCountInPage, remainingInBatch);
            if (!this.columnDescriptor.isRequired()) {
                int nonNullCount;
                boolean[] isNull = new boolean[this.readOffset];
                skipSize = nonNullCount = this.definitionLevelDecoder.readNext(isNull, startOffset, chunkSize);
                startOffset += chunkSize;
            }
            this.valuesDecoder.skip(skipSize);
            remainingInBatch -= chunkSize;
            this.remainingCountInPage -= chunkSize;
        }
    }
}

