/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.batchreader;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.LongArrayBlock;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.parquet.RichColumnDescriptor;
import com.facebook.presto.parquet.batchreader.AbstractNestedBatchReader;
import com.facebook.presto.parquet.batchreader.DefinitionLevelDecodingContext;
import com.facebook.presto.parquet.batchreader.RepetitionLevelDecodingContext;
import com.facebook.presto.parquet.batchreader.ValuesDecoderContext;
import com.facebook.presto.parquet.batchreader.decoders.ValuesDecoder;
import com.facebook.presto.parquet.reader.ColumnChunk;
import java.io.IOException;
import java.util.Optional;

public class Int64NestedBatchReader
extends AbstractNestedBatchReader {
    public Int64NestedBatchReader(RichColumnDescriptor columnDescriptor) {
        super(columnDescriptor);
    }

    @Override
    protected ColumnChunk readNestedWithNull() throws IOException {
        int maxDefinitionLevel = this.columnDescriptor.getMaxDefinitionLevel();
        RepetitionLevelDecodingContext repetitionLevelDecodingContext = this.readRepetitionLevels(this.nextBatchSize);
        DefinitionLevelDecodingContext definitionLevelDecodingContext = this.readDefinitionLevels(repetitionLevelDecodingContext.getDLValuesDecoderContexts(), repetitionLevelDecodingContext.getRepetitionLevels().length);
        int[] definitionLevels = definitionLevelDecodingContext.getDefinitionLevels();
        int newBatchSize = 0;
        int batchNonNullCount = 0;
        for (ValuesDecoderContext valuesDecoderContext : definitionLevelDecodingContext.getValuesDecoderContexts()) {
            int nonNullCount = 0;
            int valueCount = 0;
            for (int i = valuesDecoderContext.getStart(); i < valuesDecoderContext.getEnd(); ++i) {
                nonNullCount += definitionLevels[i] == maxDefinitionLevel ? 1 : 0;
                valueCount += definitionLevels[i] >= maxDefinitionLevel - 1 ? 1 : 0;
            }
            batchNonNullCount += nonNullCount;
            newBatchSize += valueCount;
            valuesDecoderContext.setNonNullCount(nonNullCount);
            valuesDecoderContext.setValueCount(valueCount);
        }
        if (batchNonNullCount == 0) {
            Block block = RunLengthEncodedBlock.create((Type)this.field.getType(), null, (int)newBatchSize);
            return new ColumnChunk(block, definitionLevels, repetitionLevelDecodingContext.getRepetitionLevels());
        }
        long[] values = new long[newBatchSize];
        boolean[] isNull = new boolean[newBatchSize];
        int offset = 0;
        for (ValuesDecoderContext valuesDecoderContext : definitionLevelDecodingContext.getValuesDecoderContexts()) {
            ((ValuesDecoder.Int64ValuesDecoder)valuesDecoderContext.getValuesDecoder()).readNext(values, offset, valuesDecoderContext.getNonNullCount());
            int valueDestinationIndex = offset + valuesDecoderContext.getValueCount() - 1;
            int valueSourceIndex = offset + valuesDecoderContext.getNonNullCount() - 1;
            int definitionLevelIndex = valuesDecoderContext.getEnd() - 1;
            while (valueDestinationIndex >= offset) {
                if (definitionLevels[definitionLevelIndex] == maxDefinitionLevel) {
                    values[valueDestinationIndex--] = values[valueSourceIndex--];
                } else if (definitionLevels[definitionLevelIndex] == maxDefinitionLevel - 1) {
                    values[valueDestinationIndex] = 0L;
                    isNull[valueDestinationIndex] = true;
                    --valueDestinationIndex;
                }
                --definitionLevelIndex;
            }
            offset += valuesDecoderContext.getValueCount();
        }
        boolean hasNoNull = batchNonNullCount == newBatchSize;
        LongArrayBlock block = new LongArrayBlock(newBatchSize, hasNoNull ? Optional.empty() : Optional.of(isNull), values);
        return new ColumnChunk((Block)block, definitionLevels, repetitionLevelDecodingContext.getRepetitionLevels());
    }

    @Override
    protected ColumnChunk readNestedNoNull() throws IOException {
        int maxDefinitionLevel = this.columnDescriptor.getMaxDefinitionLevel();
        RepetitionLevelDecodingContext repetitionLevelDecodingContext = this.readRepetitionLevels(this.nextBatchSize);
        DefinitionLevelDecodingContext definitionLevelDecodingContext = this.readDefinitionLevels(repetitionLevelDecodingContext.getDLValuesDecoderContexts(), repetitionLevelDecodingContext.getRepetitionLevels().length);
        int[] definitionLevels = definitionLevelDecodingContext.getDefinitionLevels();
        int newBatchSize = 0;
        for (ValuesDecoderContext valuesDecoderContext : definitionLevelDecodingContext.getValuesDecoderContexts()) {
            int valueCount = 0;
            for (int i = valuesDecoderContext.getStart(); i < valuesDecoderContext.getEnd(); ++i) {
                valueCount += definitionLevels[i] == maxDefinitionLevel ? 1 : 0;
            }
            newBatchSize += valueCount;
            valuesDecoderContext.setNonNullCount(valueCount);
            valuesDecoderContext.setValueCount(valueCount);
        }
        long[] values = new long[newBatchSize];
        int offset = 0;
        for (ValuesDecoderContext valuesDecoderContext : definitionLevelDecodingContext.getValuesDecoderContexts()) {
            ((ValuesDecoder.Int64ValuesDecoder)valuesDecoderContext.getValuesDecoder()).readNext(values, offset, valuesDecoderContext.getNonNullCount());
            offset += valuesDecoderContext.getValueCount();
        }
        LongArrayBlock block = new LongArrayBlock(newBatchSize, Optional.empty(), values);
        return new ColumnChunk((Block)block, definitionLevels, repetitionLevelDecodingContext.getRepetitionLevels());
    }

    @Override
    protected void seek() throws IOException {
        if (this.readOffset == 0) {
            return;
        }
        int maxDefinitionLevel = this.columnDescriptor.getMaxDefinitionLevel();
        RepetitionLevelDecodingContext repetitionLevelDecodingContext = this.readRepetitionLevels(this.readOffset);
        DefinitionLevelDecodingContext definitionLevelDecodingContext = this.readDefinitionLevels(repetitionLevelDecodingContext.getDLValuesDecoderContexts(), repetitionLevelDecodingContext.getRepetitionLevels().length);
        int[] definitionLevels = definitionLevelDecodingContext.getDefinitionLevels();
        for (ValuesDecoderContext valuesDecoderContext : definitionLevelDecodingContext.getValuesDecoderContexts()) {
            int valueCount = 0;
            for (int i = valuesDecoderContext.getStart(); i < valuesDecoderContext.getEnd(); ++i) {
                valueCount += definitionLevels[i] == maxDefinitionLevel ? 1 : 0;
            }
            ValuesDecoder.Int64ValuesDecoder intValuesDecoder = (ValuesDecoder.Int64ValuesDecoder)valuesDecoderContext.getValuesDecoder();
            intValuesDecoder.skip(valueCount);
        }
    }
}

