/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.batchreader.decoders.plain;

import com.facebook.presto.parquet.batchreader.BytesUtils;
import com.facebook.presto.parquet.batchreader.decoders.ValuesDecoder;
import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import org.openjdk.jol.info.ClassLayout;

public class BinaryPlainValuesDecoder
implements ValuesDecoder.BinaryValuesDecoder {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(BinaryPlainValuesDecoder.class).instanceSize();
    private final byte[] buffer;
    private final int bufEnd;
    private int bufOffset;

    public BinaryPlainValuesDecoder(byte[] buffer, int bufOffset, int bufLength) {
        this.buffer = buffer;
        this.bufEnd = bufOffset + bufLength;
        this.bufOffset = bufOffset;
    }

    @Override
    public ValuesDecoder.BinaryValuesDecoder.ValueBuffer readNext(int length) {
        int[] offsets = new int[length + 1];
        int offsetIndex = 0;
        int bufferSize = 0;
        for (int remaining = length; remaining > 0 && this.bufOffset < this.bufEnd; --remaining) {
            int size = BytesUtils.getInt(this.buffer, this.bufOffset);
            offsets[offsetIndex++] = this.bufOffset;
            this.bufOffset += 4 + size;
            bufferSize += size;
        }
        offsets[offsetIndex] = this.bufOffset;
        return new PlainValueBuffer(bufferSize, offsets);
    }

    @Override
    public int readIntoBuffer(byte[] byteBuffer, int bufferIndex, int[] offsets, int offsetIndex, ValuesDecoder.BinaryValuesDecoder.ValueBuffer valueBuffer) {
        Preconditions.checkArgument((byteBuffer.length - bufferIndex >= valueBuffer.getBufferSize() ? 1 : 0) != 0, (Object)"not enough space in the input buffer");
        PlainValueBuffer plainValueBuffer = (PlainValueBuffer)valueBuffer;
        int[] sourceOffsets = plainValueBuffer.getSourceOffsets();
        int numEntries = sourceOffsets.length - 1;
        for (int i = 0; i < numEntries; ++i) {
            offsets[offsetIndex++] = bufferIndex;
            int length = sourceOffsets[i + 1] - (sourceOffsets[i] + 4);
            System.arraycopy(this.buffer, sourceOffsets[i] + 4, byteBuffer, bufferIndex, length);
            bufferIndex += length;
        }
        offsets[offsetIndex] = bufferIndex;
        return bufferIndex;
    }

    @Override
    public void skip(int length) {
        int remaining;
        for (remaining = length; remaining > 0 && this.bufOffset < this.bufEnd; --remaining) {
            int size = BytesUtils.getInt(this.buffer, this.bufOffset);
            this.bufOffset += 4 + size;
        }
        Preconditions.checkState((remaining == 0 ? 1 : 0) != 0, (Object)"Invalid read size request");
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((byte[])this.buffer);
    }

    public static class PlainValueBuffer
    implements ValuesDecoder.BinaryValuesDecoder.ValueBuffer {
        private final int bufferSize;
        private final int[] sourceOffsets;

        public PlainValueBuffer(int bufferSize, int[] sourceOffsets) {
            this.bufferSize = bufferSize;
            this.sourceOffsets = sourceOffsets;
        }

        @Override
        public int getBufferSize() {
            return this.bufferSize;
        }

        public int[] getSourceOffsets() {
            return this.sourceOffsets;
        }
    }
}

