/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.predicate;

import com.facebook.presto.common.predicate.Domain;
import com.facebook.presto.common.predicate.Range;
import com.facebook.presto.common.predicate.TupleDomain;
import com.facebook.presto.common.predicate.ValueSet;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.Varchars;
import com.facebook.presto.hive.HiveWarningCode;
import com.facebook.presto.parquet.DictionaryPage;
import com.facebook.presto.parquet.ParquetDataSourceId;
import com.facebook.presto.parquet.RichColumnDescriptor;
import com.facebook.presto.parquet.dictionary.Dictionary;
import com.facebook.presto.parquet.predicate.DictionaryDescriptor;
import com.facebook.presto.parquet.predicate.Predicate;
import com.facebook.presto.parquet.predicate.PredicateUtils;
import com.facebook.presto.spi.PrestoWarning;
import com.facebook.presto.spi.WarningCodeSupplier;
import com.facebook.presto.spi.WarningCollector;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.filter2.predicate.Operators;
import org.apache.parquet.filter2.predicate.UserDefinedPredicate;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.internal.column.columnindex.ColumnIndex;
import org.apache.parquet.internal.filter2.columnindex.ColumnIndexStore;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.PrimitiveType;

public class TupleDomainParquetPredicate
implements Predicate {
    private final TupleDomain<ColumnDescriptor> effectivePredicate;
    private final List<RichColumnDescriptor> columns;
    private final ColumnIndexValueConverter converter;

    public TupleDomainParquetPredicate(TupleDomain<ColumnDescriptor> effectivePredicate, List<RichColumnDescriptor> columns) {
        this.effectivePredicate = Objects.requireNonNull(effectivePredicate, "effectivePredicate is null");
        this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
        this.converter = new ColumnIndexValueConverter(columns);
    }

    private static boolean effectivePredicateMatches(Domain effectivePredicateDomain, DictionaryDescriptor dictionary) {
        return !effectivePredicateDomain.intersect(TupleDomainParquetPredicate.getDomain(effectivePredicateDomain.getType(), dictionary)).isNone();
    }

    @VisibleForTesting
    public static Domain getDomain(ColumnDescriptor column, Type type, long rowCount, Statistics<?> statistics, ParquetDataSourceId id, Optional<WarningCollector> warningCollector) {
        boolean hasNullValue;
        if (statistics == null || statistics.isEmpty()) {
            return Domain.all((Type)type);
        }
        if (statistics.getNumNulls() == rowCount) {
            return Domain.onlyNull((Type)type);
        }
        boolean bl = hasNullValue = statistics.getNumNulls() != 0L;
        if (!statistics.hasNonNullValue() || statistics.genericGetMin() == null || statistics.genericGetMax() == null) {
            return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
        }
        try {
            return TupleDomainParquetPredicate.getDomain(column, type, (List<Object>)ImmutableList.of((Object)statistics.genericGetMin()), (List<Object>)ImmutableList.of((Object)statistics.genericGetMax()), hasNullValue);
        }
        catch (Exception exception) {
            if (warningCollector.isPresent()) {
                warningCollector.get().add(new PrestoWarning((WarningCodeSupplier)HiveWarningCode.HIVE_FILE_STATISTICS_CORRUPTION, String.format("Corrupted statistics for column \"%s\" in Parquet file \"%s\": [%s]", column.toString(), id, statistics)));
            }
            return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
        }
    }

    private static Domain getDomain(ColumnDescriptor column, Type type, List<Object> minimums, List<Object> maximums, boolean hasNullValue) {
        Preconditions.checkArgument((minimums.size() == maximums.size() ? 1 : 0) != 0, (Object)"Expected minimums and maximums to have the same size");
        ArrayList<Range> ranges = new ArrayList<Range>();
        if (type.equals(BooleanType.BOOLEAN)) {
            boolean hasFalseValues;
            boolean hasTrueValues = minimums.stream().anyMatch(value -> (Boolean)value) || maximums.stream().anyMatch(value -> (Boolean)value);
            boolean bl = hasFalseValues = minimums.stream().anyMatch(value -> (Boolean)value == false) || maximums.stream().anyMatch(value -> (Boolean)value == false);
            if (hasTrueValues && hasFalseValues) {
                return Domain.all((Type)type);
            }
            if (hasTrueValues) {
                return Domain.create((ValueSet)ValueSet.of((Type)type, (Object)true, (Object[])new Object[0]), (boolean)hasNullValue);
            }
            if (hasFalseValues) {
                return Domain.create((ValueSet)ValueSet.of((Type)type, (Object)false, (Object[])new Object[0]), (boolean)hasNullValue);
            }
            throw new VerifyException("Impossible boolean statistics");
        }
        if (type.equals(BigintType.BIGINT) || type.equals(TinyintType.TINYINT) || type.equals(SmallintType.SMALLINT) || type.equals(IntegerType.INTEGER)) {
            for (int i = 0; i < minimums.size(); ++i) {
                long max;
                long min = TupleDomainParquetPredicate.asLong(minimums.get(i));
                if (PredicateUtils.isStatisticsOverflow(type, min, max = TupleDomainParquetPredicate.asLong(maximums.get(i)))) {
                    return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
                }
                ranges.add(Range.range((Type)type, (Object)min, (boolean)true, (Object)max, (boolean)true));
            }
            Preconditions.checkArgument((!ranges.isEmpty() ? 1 : 0) != 0, (Object)"cannot use empty ranges");
            return Domain.create((ValueSet)ValueSet.ofRanges(ranges), (boolean)hasNullValue);
        }
        if (type.equals(RealType.REAL)) {
            for (int i = 0; i < minimums.size(); ++i) {
                Float min = (Float)minimums.get(i);
                Float max = (Float)maximums.get(i);
                if (min.isNaN() || max.isNaN()) {
                    return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
                }
                ranges.add(Range.range((Type)type, (Object)Float.floatToRawIntBits(min.floatValue()), (boolean)true, (Object)Float.floatToRawIntBits(max.floatValue()), (boolean)true));
            }
            Preconditions.checkArgument((!ranges.isEmpty() ? 1 : 0) != 0, (Object)"cannot use empty ranges");
            return Domain.create((ValueSet)ValueSet.ofRanges(ranges), (boolean)hasNullValue);
        }
        if (type.equals(DoubleType.DOUBLE)) {
            for (int i = 0; i < minimums.size(); ++i) {
                Double min = (Double)minimums.get(i);
                Double max = (Double)maximums.get(i);
                if (min.isNaN() || max.isNaN()) {
                    return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
                }
                ranges.add(Range.range((Type)type, (Object)min, (boolean)true, (Object)max, (boolean)true));
            }
            Preconditions.checkArgument((!ranges.isEmpty() ? 1 : 0) != 0, (Object)"cannot use empty ranges");
            return Domain.create((ValueSet)ValueSet.ofRanges(ranges), (boolean)hasNullValue);
        }
        if (Varchars.isVarcharType((Type)type)) {
            for (int i = 0; i < minimums.size(); ++i) {
                Slice min = Slices.wrappedBuffer((ByteBuffer)((Binary)minimums.get(i)).toByteBuffer());
                Slice max = Slices.wrappedBuffer((ByteBuffer)((Binary)maximums.get(i)).toByteBuffer());
                ranges.add(Range.range((Type)type, (Object)min, (boolean)true, (Object)max, (boolean)true));
            }
            Preconditions.checkArgument((!ranges.isEmpty() ? 1 : 0) != 0, (Object)"cannot use empty ranges");
            return Domain.create((ValueSet)ValueSet.ofRanges(ranges), (boolean)hasNullValue);
        }
        if (type.equals(DateType.DATE)) {
            for (int i = 0; i < minimums.size(); ++i) {
                long max;
                long min = TupleDomainParquetPredicate.asLong(minimums.get(i));
                if (PredicateUtils.isStatisticsOverflow(type, min, max = TupleDomainParquetPredicate.asLong(maximums.get(i)))) {
                    return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
                }
                ranges.add(Range.range((Type)type, (Object)min, (boolean)true, (Object)max, (boolean)true));
            }
            Preconditions.checkArgument((!ranges.isEmpty() ? 1 : 0) != 0, (Object)"cannot use empty ranges");
            return Domain.create((ValueSet)ValueSet.ofRanges(ranges), (boolean)hasNullValue);
        }
        return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
    }

    @VisibleForTesting
    public static Domain getDomain(Type type, DictionaryDescriptor dictionaryDescriptor) {
        Dictionary dictionary;
        if (dictionaryDescriptor == null) {
            return Domain.all((Type)type);
        }
        ColumnDescriptor columnDescriptor = dictionaryDescriptor.getColumnDescriptor();
        Optional<DictionaryPage> dictionaryPage = dictionaryDescriptor.getDictionaryPage();
        if (!dictionaryPage.isPresent()) {
            return Domain.all((Type)type);
        }
        try {
            dictionary = dictionaryPage.get().getEncoding().initDictionary(columnDescriptor, dictionaryPage.get());
        }
        catch (Exception e) {
            return Domain.all((Type)type);
        }
        int dictionarySize = dictionaryPage.get().getDictionarySize();
        DictionaryValueConverter converter = new DictionaryValueConverter(dictionary);
        Function convertFunction = converter.getConverter(columnDescriptor.getPrimitiveType());
        ArrayList<Object> values = new ArrayList<Object>();
        for (int i = 0; i < dictionarySize; ++i) {
            values.add(convertFunction.apply(i));
        }
        return TupleDomainParquetPredicate.getDomain(columnDescriptor, type, values, values, true);
    }

    public static long asLong(Object value) {
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
            return ((Number)value).longValue();
        }
        throw new IllegalArgumentException("Can't convert value to long: " + value.getClass().getName());
    }

    private static <T extends Comparable<T>> Domain createDomain(Type type, ColumnIndex columnIndex, boolean hasNullValue, List<T> mins, List<T> maxs) {
        if (mins.isEmpty() || maxs.isEmpty() || mins.size() != maxs.size()) {
            return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
        }
        int pageCount = columnIndex.getMinValues().size();
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (int i = 0; i < pageCount; ++i) {
            Comparable max;
            Comparable min = (Comparable)mins.get(i);
            if (min.compareTo(max = (Comparable)maxs.get(i)) > 0) {
                return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
            }
            if (min instanceof Long) {
                if (PredicateUtils.isStatisticsOverflow(type, TupleDomainParquetPredicate.asLong(min), TupleDomainParquetPredicate.asLong(max))) {
                    return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
                }
                ranges.add(Range.range((Type)type, (Object)min, (boolean)true, (Object)max, (boolean)true));
                continue;
            }
            if (min instanceof Double) {
                if (((Double)min).isNaN() || ((Double)max).isNaN()) {
                    return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
                }
                ranges.add(Range.range((Type)type, (Object)min, (boolean)true, (Object)max, (boolean)true));
                continue;
            }
            if (!(min instanceof Slice)) continue;
            ranges.add(Range.range((Type)type, (Object)min, (boolean)true, (Object)max, (boolean)true));
        }
        Preconditions.checkArgument((!ranges.isEmpty() ? 1 : 0) != 0, (Object)"cannot use empty ranges");
        return Domain.create((ValueSet)ValueSet.ofRanges(ranges), (boolean)hasNullValue);
    }

    @Override
    public boolean matches(long numberOfRows, Map<ColumnDescriptor, Statistics<?>> statistics, ParquetDataSourceId id, Optional<WarningCollector> warningCollector) {
        if (numberOfRows == 0L) {
            return false;
        }
        if (this.effectivePredicate.isNone()) {
            return false;
        }
        Map effectivePredicateDomains = (Map)this.effectivePredicate.getDomains().orElseThrow(() -> new IllegalStateException("Effective predicate other than none should have domains"));
        for (RichColumnDescriptor column : this.columns) {
            Domain domain;
            Statistics<?> columnStatistics;
            Domain effectivePredicateDomain = (Domain)effectivePredicateDomains.get((Object)column);
            if (effectivePredicateDomain == null || (columnStatistics = statistics.get((Object)column)) == null || columnStatistics.isEmpty() || !effectivePredicateDomain.intersect(domain = TupleDomainParquetPredicate.getDomain(column, effectivePredicateDomain.getType(), numberOfRows, columnStatistics, id, warningCollector)).isNone()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean matches(DictionaryDescriptor dictionary) {
        Objects.requireNonNull(dictionary, "dictionary is null");
        if (this.effectivePredicate.isNone()) {
            return false;
        }
        Map effectivePredicateDomains = (Map)this.effectivePredicate.getDomains().orElseThrow(() -> new IllegalStateException("Effective predicate other than none should have domains"));
        Domain effectivePredicateDomain = (Domain)effectivePredicateDomains.get(dictionary.getColumnDescriptor());
        return effectivePredicateDomain == null || TupleDomainParquetPredicate.effectivePredicateMatches(effectivePredicateDomain, dictionary);
    }

    @Override
    public boolean matches(long numberOfRows, Optional<ColumnIndexStore> columnIndexStore) {
        if (numberOfRows == 0L || !columnIndexStore.isPresent()) {
            return false;
        }
        if (this.effectivePredicate.isNone()) {
            return false;
        }
        Map effectivePredicateDomains = (Map)this.effectivePredicate.getDomains().orElseThrow(() -> new IllegalStateException("Effective predicate other than none should have domains"));
        for (RichColumnDescriptor column : this.columns) {
            Domain domain;
            ColumnIndex columnIndex;
            Domain effectivePredicateDomain = (Domain)effectivePredicateDomains.get((Object)column);
            if (effectivePredicateDomain == null || !columnIndexStore.isPresent() || (columnIndex = columnIndexStore.get().getColumnIndex(ColumnPath.get((String[])column.getPath()))) == null || columnIndex.getMinValues().isEmpty() || columnIndex.getMaxValues().isEmpty() || columnIndex.getMinValues().size() != columnIndex.getMaxValues().size() || !effectivePredicateDomain.intersect(domain = this.getDomain(effectivePredicateDomain.getType(), numberOfRows, columnIndex, column)).isNone()) continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    public Domain getDomain(Type type, long rowCount, ColumnIndex columnIndex, RichColumnDescriptor descriptor) {
        boolean hasNullValue;
        if (columnIndex == null) {
            return Domain.all((Type)type);
        }
        String columnName = descriptor.getPrimitiveType().getName();
        if (this.isCorruptedColumnIndex(columnIndex)) {
            return Domain.all((Type)type);
        }
        if (this.isEmptyColumnIndex(columnIndex)) {
            return Domain.all((Type)type);
        }
        long totalNullCount = columnIndex.getNullCounts().stream().reduce(0L, (a, b) -> a + b);
        if (totalNullCount == rowCount) {
            return Domain.onlyNull((Type)type);
        }
        boolean bl = hasNullValue = totalNullCount > 0L;
        if (descriptor.getType().equals((Object)PrimitiveType.PrimitiveTypeName.BOOLEAN)) {
            return Domain.all((Type)type);
        }
        if (descriptor.getType().equals((Object)PrimitiveType.PrimitiveTypeName.INT32) || descriptor.getType().equals((Object)PrimitiveType.PrimitiveTypeName.INT64) || descriptor.getType().equals((Object)PrimitiveType.PrimitiveTypeName.FLOAT)) {
            List<Long> mins = this.converter.getMinValuesAsLong(type, columnIndex, columnName);
            List<Long> maxs = this.converter.getMaxValuesAsLong(type, columnIndex, columnName);
            return TupleDomainParquetPredicate.createDomain(type, columnIndex, hasNullValue, mins, maxs);
        }
        if (descriptor.getType().equals((Object)PrimitiveType.PrimitiveTypeName.DOUBLE)) {
            List<Double> mins = this.converter.getMinValuesAsDouble(type, columnIndex, columnName);
            List<Double> maxs = this.converter.getMaxValuesAsDouble(type, columnIndex, columnName);
            return TupleDomainParquetPredicate.createDomain(type, columnIndex, hasNullValue, mins, maxs);
        }
        if (descriptor.getType().equals((Object)PrimitiveType.PrimitiveTypeName.BINARY)) {
            List<Slice> mins = this.converter.getMinValuesAsSlice(type, columnIndex);
            List<Slice> maxs = this.converter.getMaxValuesAsSlice(type, columnIndex);
            return TupleDomainParquetPredicate.createDomain(type, columnIndex, hasNullValue, mins, maxs);
        }
        return Domain.create((ValueSet)ValueSet.all((Type)type), (boolean)hasNullValue);
    }

    private boolean isCorruptedColumnIndex(ColumnIndex columnIndex) {
        if (columnIndex.getMaxValues() == null || columnIndex.getMinValues() == null || columnIndex.getNullCounts() == null || columnIndex.getNullPages() == null) {
            return true;
        }
        return columnIndex.getMaxValues().size() != columnIndex.getMinValues().size() || columnIndex.getMaxValues().size() != columnIndex.getNullPages().size() || columnIndex.getMaxValues().size() != columnIndex.getNullCounts().size();
    }

    private boolean isEmptyColumnIndex(ColumnIndex columnIndex) {
        return columnIndex.getMaxValues().isEmpty();
    }

    public FilterPredicate getParquetUserDefinedPredicate() {
        Operators.UserDefined filter = null;
        for (RichColumnDescriptor column : this.columns) {
            Domain domain = (Domain)((Map)this.effectivePredicate.getDomains().get()).get((Object)column);
            if (domain == null || domain.isNone() || domain.isAll()) continue;
            Operators.UserDefined columnFilter = FilterApi.userDefined((Operators.Column)FilterApi.intColumn((String)ColumnPath.get((String[])column.getPath()).toDotString()), new ParquetUserDefinedPredicateTupleDomain(domain));
            if (filter == null) {
                filter = columnFilter;
                continue;
            }
            filter = FilterApi.or((FilterPredicate)filter, (FilterPredicate)columnFilter);
        }
        return filter;
    }

    @VisibleForTesting
    public static Range getRange(Type type, Object min, Object max) {
        if (type.equals(BigintType.BIGINT) || type.equals(IntegerType.INTEGER) || type.equals(SmallintType.SMALLINT) || type.equals(TinyintType.TINYINT)) {
            long minValue = TupleDomainParquetPredicate.asLong(min);
            long maxValue = TupleDomainParquetPredicate.asLong(max);
            return Range.range((Type)type, (Object)minValue, (boolean)true, (Object)maxValue, (boolean)true);
        }
        if (type.equals(RealType.REAL)) {
            long minValue = Float.floatToRawIntBits(((Float)min).floatValue());
            long maxValue = Float.floatToRawIntBits(((Float)max).floatValue());
            return Range.range((Type)type, (Object)minValue, (boolean)true, (Object)maxValue, (boolean)true);
        }
        return Range.range((Type)type, (Object)min, (boolean)true, (Object)max, (boolean)true);
    }

    class ColumnIndexValueConverter {
        private final Map<String, Function<Object, Object>> conversions = new HashMap<String, Function<Object, Object>>();

        private ColumnIndexValueConverter(List<RichColumnDescriptor> columns) {
            for (RichColumnDescriptor column : columns) {
                this.conversions.put(column.getPrimitiveType().getName(), this.getColumnIndexConversions(column.getPrimitiveType()));
            }
        }

        public List<Long> getMinValuesAsLong(Type type, ColumnIndex columnIndex, String column) {
            return this.getValuesAsLong(type, column, columnIndex.getMinValues().size(), columnIndex.getMinValues());
        }

        public List<Long> getMaxValuesAsLong(Type type, ColumnIndex columnIndex, String column) {
            return this.getValuesAsLong(type, column, columnIndex.getMaxValues().size(), columnIndex.getMaxValues());
        }

        public List<Double> getMinValuesAsDouble(Type type, ColumnIndex columnIndex, String column) {
            return this.getValuesAsDouble(type, column, columnIndex.getMinValues().size(), columnIndex.getMinValues());
        }

        public List<Double> getMaxValuesAsDouble(Type type, ColumnIndex columnIndex, String column) {
            return this.getValuesAsDouble(type, column, columnIndex.getMaxValues().size(), columnIndex.getMaxValues());
        }

        public List<Slice> getMinValuesAsSlice(Type type, ColumnIndex columnIndex) {
            return this.getValuesAsSlice(type, columnIndex.getMinValues().size(), columnIndex.getMinValues());
        }

        public List<Slice> getMaxValuesAsSlice(Type type, ColumnIndex columnIndex) {
            return this.getValuesAsSlice(type, columnIndex.getMaxValues().size(), columnIndex.getMaxValues());
        }

        private List<Long> getValuesAsLong(Type type, String column, int pageCount, List<ByteBuffer> values) {
            ArrayList<Long> result;
            block4: {
                block5: {
                    block3: {
                        result = new ArrayList<Long>();
                        if (!TinyintType.TINYINT.equals((Object)type) && !SmallintType.SMALLINT.equals((Object)type) && !IntegerType.INTEGER.equals((Object)type)) break block3;
                        for (int i = 0; i < pageCount; ++i) {
                            result.add((long)((Long)TupleDomainParquetPredicate.this.converter.convert(values.get(i), column)));
                        }
                        break block4;
                    }
                    if (!BigintType.BIGINT.equals((Object)type)) break block5;
                    for (int i = 0; i < pageCount; ++i) {
                        result.add((long)((Long)TupleDomainParquetPredicate.this.converter.convert(values.get(i), column)));
                    }
                    break block4;
                }
                if (!RealType.REAL.equals((Object)type)) break block4;
                for (int i = 0; i < pageCount; ++i) {
                    result.add(Long.valueOf(Float.floatToRawIntBits(((Float)TupleDomainParquetPredicate.this.converter.convert(values.get(i), column)).floatValue())));
                }
            }
            return result;
        }

        private List<Double> getValuesAsDouble(Type type, String column, int pageCount, List<ByteBuffer> values) {
            ArrayList<Double> result = new ArrayList<Double>();
            if (DoubleType.DOUBLE.equals((Object)type)) {
                for (int i = 0; i < pageCount; ++i) {
                    result.add((Double)TupleDomainParquetPredicate.this.converter.convert(values.get(i), column));
                }
            }
            return result;
        }

        private List<Slice> getValuesAsSlice(Type type, int pageCount, List<ByteBuffer> values) {
            ArrayList<Slice> result = new ArrayList<Slice>();
            if (Varchars.isVarcharType((Type)type)) {
                for (int i = 0; i < pageCount; ++i) {
                    result.add(Slices.wrappedBuffer((ByteBuffer)values.get(i)));
                }
            }
            return result;
        }

        private <T> T convert(ByteBuffer buffer, String name) {
            return (T)this.conversions.get(name).apply(buffer);
        }

        private Function<Object, Object> getColumnIndexConversions(PrimitiveType type) {
            switch (type.getPrimitiveTypeName()) {
                case BOOLEAN: {
                    return buffer -> ((ByteBuffer)buffer).get(0) != 0;
                }
                case INT32: {
                    return buffer -> (long)((ByteBuffer)buffer).order(ByteOrder.LITTLE_ENDIAN).getInt(0);
                }
                case INT64: {
                    return buffer -> ((ByteBuffer)buffer).order(ByteOrder.LITTLE_ENDIAN).getLong(0);
                }
                case FLOAT: {
                    return buffer -> Float.valueOf(((ByteBuffer)buffer).order(ByteOrder.LITTLE_ENDIAN).getFloat(0));
                }
                case DOUBLE: {
                    return buffer -> ((ByteBuffer)buffer).order(ByteOrder.LITTLE_ENDIAN).getDouble(0);
                }
                case FIXED_LEN_BYTE_ARRAY: 
                case BINARY: 
                case INT96: {
                    return binary -> ByteBuffer.wrap(((Binary)binary).getBytes());
                }
            }
            throw new IllegalArgumentException("Unsupported Parquet type: " + type.getPrimitiveTypeName());
        }
    }

    static class ParquetUserDefinedPredicateTupleDomain<T extends Comparable<T>>
    extends UserDefinedPredicate<T>
    implements Serializable {
        private Domain columnDomain;

        ParquetUserDefinedPredicateTupleDomain(Domain domain) {
            this.columnDomain = domain;
        }

        public boolean keep(T value) {
            return value != null || this.columnDomain.isNullAllowed();
        }

        public boolean canDrop(org.apache.parquet.filter2.predicate.Statistics<T> statistic) {
            if (statistic == null) {
                return false;
            }
            ArrayList<Range> ranges = new ArrayList<Range>();
            ranges.add(TupleDomainParquetPredicate.getRange(this.columnDomain.getType(), statistic.getMin(), statistic.getMax()));
            return this.canDropWithRangeStatistics(ranges);
        }

        public boolean inverseCanDrop(org.apache.parquet.filter2.predicate.Statistics<T> statistics) {
            return false;
        }

        private boolean canDropWithRangeStatistics(List<Range> ranges) {
            Preconditions.checkArgument((!ranges.isEmpty() ? 1 : 0) != 0, (Object)"cannot use empty ranges");
            Domain domain = Domain.create((ValueSet)ValueSet.ofRanges(ranges), (boolean)true);
            return this.columnDomain.intersect(domain).isNone();
        }
    }

    private static class DictionaryValueConverter {
        private final Dictionary dictionary;

        private DictionaryValueConverter(Dictionary dictionary) {
            this.dictionary = dictionary;
        }

        private Function<Integer, Object> getConverter(PrimitiveType primitiveType) {
            switch (primitiveType.getPrimitiveTypeName()) {
                case INT32: {
                    return i -> this.dictionary.decodeToInt((int)i);
                }
                case INT64: {
                    return i -> this.dictionary.decodeToLong((int)i);
                }
                case FLOAT: {
                    return i -> Float.valueOf(this.dictionary.decodeToFloat((int)i));
                }
                case DOUBLE: {
                    return i -> this.dictionary.decodeToDouble((int)i);
                }
                case FIXED_LEN_BYTE_ARRAY: 
                case BINARY: 
                case INT96: {
                    return i -> this.dictionary.decodeToBinary((int)i);
                }
            }
            throw new IllegalArgumentException("Unsupported Parquet primitive type: " + primitiveType.getPrimitiveTypeName());
        }
    }
}

