/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.reader;

import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.parquet.ColumnReader;
import com.facebook.presto.parquet.DataPage;
import com.facebook.presto.parquet.DataPageV1;
import com.facebook.presto.parquet.DataPageV2;
import com.facebook.presto.parquet.DictionaryPage;
import com.facebook.presto.parquet.Field;
import com.facebook.presto.parquet.ParquetEncoding;
import com.facebook.presto.parquet.ParquetTypeUtils;
import com.facebook.presto.parquet.RichColumnDescriptor;
import com.facebook.presto.parquet.ValuesType;
import com.facebook.presto.parquet.dictionary.Dictionary;
import com.facebook.presto.parquet.reader.ColumnChunk;
import com.facebook.presto.parquet.reader.LevelNullReader;
import com.facebook.presto.parquet.reader.LevelRLEReader;
import com.facebook.presto.parquet.reader.LevelReader;
import com.facebook.presto.parquet.reader.LevelValuesReader;
import com.facebook.presto.parquet.reader.PageReader;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.function.Consumer;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.column.values.rle.RunLengthBitPackingHybridDecoder;
import org.apache.parquet.internal.filter2.columnindex.RowRanges;
import org.apache.parquet.io.ParquetDecodingException;
import org.openjdk.jol.info.ClassLayout;

public abstract class AbstractColumnReader
implements ColumnReader {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(AbstractColumnReader.class).instanceSize();
    private static final int EMPTY_LEVEL_VALUE = -1;
    protected final RichColumnDescriptor columnDescriptor;
    protected int definitionLevel = -1;
    protected int repetitionLevel = -1;
    protected ValuesReader valuesReader;
    private Field field;
    private int nextBatchSize;
    private LevelReader repetitionReader;
    private LevelReader definitionReader;
    private PageReader pageReader;
    private Dictionary dictionary;
    private long valueCountInColumnChunk;
    private int currentValueCount;
    private DataPage page;
    private int remainingValueCountInPage;
    private int readOffset;
    private PrimitiveIterator.OfLong indexIterator;
    private long currentRow;
    private long targetRow;

    public AbstractColumnReader(RichColumnDescriptor columnDescriptor) {
        this.columnDescriptor = Objects.requireNonNull(columnDescriptor, "columnDescriptor");
        this.pageReader = null;
        this.targetRow = Long.MIN_VALUE;
        this.indexIterator = null;
    }

    protected abstract void readValue(BlockBuilder var1, Type var2);

    protected abstract void skipValue();

    protected boolean isValueNull() {
        return ParquetTypeUtils.isValueNull(this.columnDescriptor.isRequired(), this.definitionLevel, this.columnDescriptor.getMaxDefinitionLevel());
    }

    @Override
    public boolean isInitialized() {
        return this.pageReader != null && this.field != null;
    }

    @Override
    public void init(PageReader pageReader, Field field, RowRanges rowRanges) {
        this.pageReader = Objects.requireNonNull(pageReader, "pageReader is null");
        this.field = Objects.requireNonNull(field, "field is null");
        DictionaryPage dictionaryPage = pageReader.readDictionaryPage();
        if (dictionaryPage != null) {
            try {
                this.dictionary = dictionaryPage.getEncoding().initDictionary(this.columnDescriptor, dictionaryPage);
            }
            catch (IOException e) {
                throw new ParquetDecodingException("could not decode the dictionary for " + (Object)((Object)this.columnDescriptor), (Throwable)e);
            }
        } else {
            this.dictionary = null;
        }
        Preconditions.checkArgument((pageReader.getValueCountInColumnChunk() > 0L ? 1 : 0) != 0, (Object)"page is empty");
        this.valueCountInColumnChunk = pageReader.getValueCountInColumnChunk();
        this.indexIterator = rowRanges == null ? null : rowRanges.iterator();
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public ColumnChunk readNext() {
        int valuesToRead;
        IntArrayList definitionLevels = new IntArrayList();
        IntArrayList repetitionLevels = new IntArrayList();
        this.seek();
        BlockBuilder blockBuilder = this.field.getType().createBlockBuilder(null, this.nextBatchSize);
        for (int valueCount = 0; valueCount < this.nextBatchSize; valueCount += valuesToRead) {
            if (this.page == null) {
                this.readNextPage();
            }
            if ((valuesToRead = Math.min(this.remainingValueCountInPage, this.nextBatchSize - valueCount)) == 0) break;
            this.readValues(blockBuilder, valuesToRead, this.field.getType(), (IntList)definitionLevels, (IntList)repetitionLevels);
        }
        this.readOffset = 0;
        this.nextBatchSize = 0;
        return new ColumnChunk(blockBuilder.build(), definitionLevels.toIntArray(), repetitionLevels.toIntArray());
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + (this.pageReader == null ? 0L : this.pageReader.getRetainedSizeInBytes()) + (this.dictionary == null ? 0L : this.dictionary.getRetainedSizeInBytes()) + (this.page == null ? 0L : this.page.getRetainedSizeInBytes());
    }

    private void readValues(BlockBuilder blockBuilder, int valuesToRead, Type type, IntList definitionLevels, IntList repetitionLevels) {
        this.processValues(valuesToRead, ignored -> {
            this.readValue(blockBuilder, type);
            definitionLevels.add(this.definitionLevel);
            repetitionLevels.add(this.repetitionLevel);
        }, this.indexIterator != null);
    }

    private void skipValues(int valuesToRead) {
        this.processValues(valuesToRead, ignored -> this.skipValue(), false);
    }

    private void processValues(int valuesToRead, Consumer<Void> valueConsumer, boolean indexEnabled) {
        if (this.definitionLevel == -1 && this.repetitionLevel == -1) {
            this.definitionLevel = this.definitionReader.readLevel();
            this.repetitionLevel = this.repetitionReader.readLevel();
        }
        int valueCount = 0;
        int skipCount = 0;
        int i = 0;
        while (i < valuesToRead) {
            boolean consumed = false;
            do {
                if (this.skipRL(this.repetitionLevel, indexEnabled)) {
                    this.skipValue();
                    ++skipCount;
                } else {
                    valueConsumer.accept(null);
                    ++valueCount;
                    consumed = true;
                }
                if (valueCount + skipCount == this.remainingValueCountInPage) {
                    this.updateValueCounts(valueCount, skipCount);
                    if (!this.readNextPage()) {
                        return;
                    }
                    valueCount = 0;
                    skipCount = 0;
                }
                this.repetitionLevel = this.repetitionReader.readLevel();
                this.definitionLevel = this.definitionReader.readLevel();
            } while (this.repetitionLevel != 0);
            if (!consumed) continue;
            ++i;
        }
        this.updateValueCounts(valueCount, skipCount);
    }

    private void seek() {
        int valuePosition;
        int offset;
        Preconditions.checkArgument(((long)this.currentValueCount <= this.valueCountInColumnChunk ? 1 : 0) != 0, (Object)"Already read all values in column chunk");
        if (this.readOffset == 0) {
            return;
        }
        for (valuePosition = 0; valuePosition < this.readOffset; valuePosition += offset) {
            if (this.page == null) {
                this.readNextPage();
            }
            offset = Math.min(this.remainingValueCountInPage, this.readOffset - valuePosition);
            this.skipValues(offset);
        }
        Preconditions.checkArgument((valuePosition == this.readOffset ? 1 : 0) != 0, (String)"valuePosition %s must be equal to readOffset %s", (int)valuePosition, (int)this.readOffset);
    }

    private boolean readNextPage() {
        Verify.verify((this.page == null ? 1 : 0) != 0, (String)"readNextPage has to be called when page is null", (Object[])new Object[0]);
        this.page = this.pageReader.readPage();
        if (this.page == null) {
            return false;
        }
        this.remainingValueCountInPage = this.page.getValueCount();
        this.valuesReader = this.page instanceof DataPageV1 ? this.readPageV1((DataPageV1)this.page) : this.readPageV2((DataPageV2)this.page);
        return true;
    }

    private void updateValueCounts(int valuesRead, int skipCount) {
        int totalCount = valuesRead + skipCount;
        if (totalCount == this.remainingValueCountInPage) {
            this.page = null;
            this.valuesReader = null;
        }
        this.remainingValueCountInPage -= totalCount;
        this.currentValueCount += valuesRead;
    }

    private ValuesReader readPageV1(DataPageV1 page) {
        ValuesReader repetitionLevelReader = page.getRepetitionLevelEncoding().getValuesReader(this.columnDescriptor, ValuesType.REPETITION_LEVEL);
        ValuesReader definitionLevelReader = page.getDefinitionLevelEncoding().getValuesReader(this.columnDescriptor, ValuesType.DEFINITION_LEVEL);
        this.repetitionReader = new LevelValuesReader(repetitionLevelReader);
        this.definitionReader = new LevelValuesReader(definitionLevelReader);
        try {
            ByteBufferInputStream bufferInputStream = ByteBufferInputStream.wrap((ByteBuffer[])new ByteBuffer[]{page.getSlice().toByteBuffer()});
            repetitionLevelReader.initFromPage(page.getValueCount(), bufferInputStream);
            definitionLevelReader.initFromPage(page.getValueCount(), bufferInputStream);
            long firstRowIndex = page.getFirstRowIndex().orElse(-1L);
            return this.initDataReader(page.getValueEncoding(), bufferInputStream, page.getValueCount(), firstRowIndex);
        }
        catch (IOException e) {
            throw new ParquetDecodingException("Error reading parquet page " + page + " in column " + (Object)((Object)this.columnDescriptor), (Throwable)e);
        }
    }

    private ValuesReader readPageV2(DataPageV2 page) {
        this.repetitionReader = this.buildLevelRLEReader(this.columnDescriptor.getMaxRepetitionLevel(), page.getRepetitionLevels());
        this.definitionReader = this.buildLevelRLEReader(this.columnDescriptor.getMaxDefinitionLevel(), page.getDefinitionLevels());
        long firstRowIndex = page.getFirstRowIndex().orElse(-1L);
        return this.initDataReader(page.getDataEncoding(), ByteBufferInputStream.wrap((List)ImmutableList.of((Object)page.getSlice().toByteBuffer())), page.getValueCount(), firstRowIndex);
    }

    private LevelReader buildLevelRLEReader(int maxLevel, Slice slice) {
        if (maxLevel == 0) {
            return new LevelNullReader();
        }
        return new LevelRLEReader(new RunLengthBitPackingHybridDecoder(BytesUtils.getWidthFromMaxInt((int)maxLevel), (InputStream)slice.getInput()));
    }

    private ValuesReader initDataReader(ParquetEncoding dataEncoding, ByteBufferInputStream inputStream, int valueCount, long firstRowIndex) {
        ValuesReader valuesReader;
        if (dataEncoding.usesDictionary()) {
            if (this.dictionary == null) {
                throw new ParquetDecodingException("Dictionary is missing for Page");
            }
            valuesReader = dataEncoding.getDictionaryBasedValuesReader(this.columnDescriptor, ValuesType.VALUES, this.dictionary);
        } else {
            valuesReader = dataEncoding.getValuesReader(this.columnDescriptor, ValuesType.VALUES);
        }
        try {
            valuesReader.initFromPage(valueCount, inputStream);
            this.currentRow = firstRowIndex != -1L ? firstRowIndex - 1L : -1L;
            return valuesReader;
        }
        catch (IOException e) {
            throw new ParquetDecodingException("Error reading parquet page in column " + (Object)((Object)this.columnDescriptor), (Throwable)e);
        }
    }

    private boolean skipRL(int repetitionLevel, boolean indexEnabled) {
        if (!indexEnabled || this.indexIterator == null) {
            return false;
        }
        if (repetitionLevel == 0) {
            ++this.currentRow;
            if (this.currentRow > this.targetRow) {
                this.targetRow = this.indexIterator.hasNext() ? this.indexIterator.nextLong() : Long.MAX_VALUE;
            }
        }
        return this.currentRow < this.targetRow;
    }
}

