/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.reader;

import com.facebook.presto.common.block.ArrayBlock;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.IntArrayBlock;
import com.facebook.presto.common.block.LongArrayBlock;
import com.facebook.presto.common.block.RowBlock;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.parquet.ColumnReader;
import com.facebook.presto.parquet.ColumnReaderFactory;
import com.facebook.presto.parquet.Field;
import com.facebook.presto.parquet.GroupField;
import com.facebook.presto.parquet.ParquetCorruptionException;
import com.facebook.presto.parquet.ParquetDataSource;
import com.facebook.presto.parquet.ParquetResultVerifierUtils;
import com.facebook.presto.parquet.ParquetValidationUtils;
import com.facebook.presto.parquet.PrimitiveField;
import com.facebook.presto.parquet.RichColumnDescriptor;
import com.facebook.presto.parquet.predicate.Predicate;
import com.facebook.presto.parquet.predicate.TupleDomainParquetPredicate;
import com.facebook.presto.parquet.reader.ColumnChunk;
import com.facebook.presto.parquet.reader.ColumnChunkDescriptor;
import com.facebook.presto.parquet.reader.ColumnIndexFilterUtils;
import com.facebook.presto.parquet.reader.ListColumnReader;
import com.facebook.presto.parquet.reader.PageReader;
import com.facebook.presto.parquet.reader.ParquetColumnChunk;
import com.facebook.presto.parquet.reader.StructColumnReader;
import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import io.airlift.units.DataSize;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.booleans.BooleanList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.crypto.HiddenColumnChunkMetaData;
import org.apache.parquet.crypto.InternalFileDecryptor;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.internal.column.columnindex.OffsetIndex;
import org.apache.parquet.internal.filter2.columnindex.ColumnIndexFilter;
import org.apache.parquet.internal.filter2.columnindex.ColumnIndexStore;
import org.apache.parquet.internal.filter2.columnindex.RowRanges;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.io.PrimitiveColumnIO;
import org.apache.parquet.schema.PrimitiveType;
import org.openjdk.jol.info.ClassLayout;

public class ParquetReader
implements Closeable {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(ParquetReader.class).instanceSize();
    private static final int MAX_VECTOR_LENGTH = 1024;
    private static final int INITIAL_BATCH_SIZE = 1;
    private static final int BATCH_SIZE_GROWTH_FACTOR = 2;
    private final ColumnReader[] verificationColumnReaders;
    private final ParquetDataSource dataSource;
    private final Optional<InternalFileDecryptor> fileDecryptor;
    private final List<BlockMetaData> blocks;
    private final Optional<List<Long>> firstRowsOfBlocks;
    private final List<PrimitiveColumnIO> columns;
    private final AggregatedMemoryContext systemMemoryContext;
    private final LocalMemoryContext parquetReaderMemoryContext;
    private final LocalMemoryContext pageReaderMemoryContext;
    private final LocalMemoryContext verificationPageReaderMemoryContext;
    private final boolean batchReadEnabled;
    private final boolean enableVerification;
    private final FilterPredicate filter;
    private final ColumnReader[] columnReaders;
    private final long maxReadBlockBytes;
    private final List<ColumnIndexStore> blockIndexStores;
    private final List<RowRanges> blockRowRanges;
    private final Map<ColumnPath, ColumnDescriptor> paths = new HashMap<ColumnPath, ColumnDescriptor>();
    private final boolean columnIndexFilterEnabled;
    private BlockMetaData currentBlockMetadata;
    private Optional<Long> firstRowIndexInGroup = Optional.empty();
    private RowRanges currentGroupRowRanges;
    private long nextRowInGroup;
    private int batchSize;
    private int nextBatchSize = 1;
    private final long[] maxBytesPerCell;
    private long maxCombinedBytesPerRow;
    private int maxBatchSize = 1024;
    private int currentBlock;
    private long currentPosition;
    private long currentGroupRowCount;

    public ParquetReader(MessageColumnIO messageColumnIO, List<BlockMetaData> blocks, Optional<List<Long>> firstRowsOfBlocks, ParquetDataSource dataSource, AggregatedMemoryContext systemMemoryContext, DataSize maxReadBlockSize, boolean batchReadEnabled, boolean enableVerification, Predicate parquetPredicate, List<ColumnIndexStore> blockIndexStores, boolean columnIndexFilterEnabled, Optional<InternalFileDecryptor> fileDecryptor) {
        this.blocks = blocks;
        this.firstRowsOfBlocks = Objects.requireNonNull(firstRowsOfBlocks, "firstRowsOfBlocks is null");
        this.dataSource = Objects.requireNonNull(dataSource, "dataSource is null");
        this.systemMemoryContext = Objects.requireNonNull(systemMemoryContext, "systemMemoryContext is null");
        this.parquetReaderMemoryContext = systemMemoryContext.newLocalMemoryContext("ParquetReader");
        this.pageReaderMemoryContext = systemMemoryContext.newLocalMemoryContext("PageReader");
        this.verificationPageReaderMemoryContext = systemMemoryContext.newLocalMemoryContext("PageReader");
        this.maxReadBlockBytes = Objects.requireNonNull(maxReadBlockSize, "maxReadBlockSize is null").toBytes();
        this.batchReadEnabled = batchReadEnabled;
        this.columns = messageColumnIO.getLeaves();
        this.columnReaders = new ColumnReader[this.columns.size()];
        this.enableVerification = enableVerification;
        this.verificationColumnReaders = enableVerification ? new ColumnReader[this.columns.size()] : null;
        this.maxBytesPerCell = new long[this.columns.size()];
        this.blockIndexStores = blockIndexStores;
        this.blockRowRanges = ParquetReader.listWithNulls(this.blocks.size());
        firstRowsOfBlocks.ifPresent(firstRows -> Preconditions.checkArgument((blocks.size() == firstRows.size() ? 1 : 0) != 0, (Object)"elements of firstRowsOfBlocks must correspond to blocks"));
        for (PrimitiveColumnIO column : this.columns) {
            ColumnDescriptor columnDescriptor = column.getColumnDescriptor();
            this.paths.put(ColumnPath.get((String[])columnDescriptor.getPath()), columnDescriptor);
        }
        this.filter = parquetPredicate != null && columnIndexFilterEnabled && parquetPredicate instanceof TupleDomainParquetPredicate ? ((TupleDomainParquetPredicate)parquetPredicate).getParquetUserDefinedPredicate() : null;
        this.currentBlock = -1;
        this.columnIndexFilterEnabled = columnIndexFilterEnabled;
        Objects.requireNonNull(fileDecryptor, "fileDecryptor is null");
        this.fileDecryptor = fileDecryptor;
    }

    @Override
    public void close() throws IOException {
        this.dataSource.close();
        this.parquetReaderMemoryContext.close();
        this.systemMemoryContext.close();
    }

    public long getPosition() {
        return this.currentPosition;
    }

    public long lastBatchStartRow() {
        long baseIndex = this.firstRowIndexInGroup.orElseThrow(() -> new IllegalStateException("row index unavailable"));
        return baseIndex + this.nextRowInGroup - (long)this.batchSize;
    }

    public int nextBatch() {
        if (this.nextRowInGroup >= this.currentGroupRowCount && !this.advanceToNextRowGroup()) {
            return -1;
        }
        this.batchSize = Math.toIntExact(Math.min(this.nextBatchSize, this.maxBatchSize));
        this.nextBatchSize = Math.min(this.batchSize * 2, 1024);
        this.batchSize = Math.toIntExact(Math.min((long)this.batchSize, this.currentGroupRowCount - this.nextRowInGroup));
        this.nextRowInGroup += (long)this.batchSize;
        this.currentPosition += (long)this.batchSize;
        Arrays.stream(this.columnReaders).forEach(reader -> reader.prepareNextRead(this.batchSize));
        if (this.enableVerification) {
            Arrays.stream(this.verificationColumnReaders).forEach(reader -> reader.prepareNextRead(this.batchSize));
        }
        return this.batchSize;
    }

    public ParquetDataSource getDataSource() {
        return this.dataSource;
    }

    public long getSystemMemoryUsage() {
        return this.systemMemoryContext.getBytes();
    }

    private boolean advanceToNextRowGroup() {
        ColumnIndexStore columnIndexStore;
        ++this.currentBlock;
        if (this.currentBlock == this.blocks.size()) {
            return false;
        }
        this.currentBlockMetadata = this.blocks.get(this.currentBlock);
        this.firstRowIndexInGroup = this.firstRowsOfBlocks.map(firstRows -> (Long)firstRows.get(this.currentBlock));
        if (this.filter != null && this.columnIndexFilterEnabled && (columnIndexStore = this.blockIndexStores.get(this.currentBlock)) != null) {
            this.currentGroupRowRanges = this.getRowRanges(this.currentBlock);
            long rowCount = this.currentGroupRowRanges.rowCount();
            if (rowCount == 0L) {
                return false;
            }
        }
        this.nextRowInGroup = 0L;
        this.currentGroupRowCount = this.currentBlockMetadata.getRowCount();
        this.initializeColumnReaders();
        return true;
    }

    private ColumnChunk readArray(GroupField field) throws IOException {
        List parameters = field.getType().getTypeParameters();
        Preconditions.checkArgument((parameters.size() == 1 ? 1 : 0) != 0, (String)"Arrays must have a single type parameter, found %d", (int)parameters.size());
        Field elementField = field.getChildren().get(0).get();
        ColumnChunk columnChunk = this.readColumnChunk(elementField);
        IntArrayList offsets = new IntArrayList();
        BooleanArrayList valueIsNull = new BooleanArrayList();
        ListColumnReader.calculateCollectionOffsets(field, (IntList)offsets, (BooleanList)valueIsNull, columnChunk.getDefinitionLevels(), columnChunk.getRepetitionLevels());
        Block arrayBlock = ArrayBlock.fromElementBlock((int)valueIsNull.size(), Optional.of(valueIsNull.toBooleanArray()), (int[])offsets.toIntArray(), (Block)columnChunk.getBlock());
        return new ColumnChunk(arrayBlock, columnChunk.getDefinitionLevels(), columnChunk.getRepetitionLevels());
    }

    private ColumnChunk readMap(GroupField field) throws IOException {
        List parameters = field.getType().getTypeParameters();
        Preconditions.checkArgument((parameters.size() == 2 ? 1 : 0) != 0, (String)"Maps must have two type parameters, found %d", (int)parameters.size());
        Block[] blocks = new Block[parameters.size()];
        ColumnChunk columnChunk = this.readColumnChunk(field.getChildren().get(0).get());
        blocks[0] = columnChunk.getBlock();
        blocks[1] = this.readColumnChunk(field.getChildren().get(1).get()).getBlock();
        IntArrayList offsets = new IntArrayList();
        BooleanArrayList valueIsNull = new BooleanArrayList();
        ListColumnReader.calculateCollectionOffsets(field, (IntList)offsets, (BooleanList)valueIsNull, columnChunk.getDefinitionLevels(), columnChunk.getRepetitionLevels());
        Block mapBlock = ((MapType)field.getType()).createBlockFromKeyValue(offsets.size() - 1, Optional.of(valueIsNull.toBooleanArray()), offsets.toIntArray(), blocks[0], blocks[1]);
        return new ColumnChunk(mapBlock, columnChunk.getDefinitionLevels(), columnChunk.getRepetitionLevels());
    }

    private ColumnChunk readStruct(GroupField field) throws IOException {
        int i;
        List fields = field.getType().getTypeSignature().getParameters();
        Block[] blocks = new Block[fields.size()];
        ColumnChunk columnChunk = null;
        List<Optional<Field>> parameters = field.getChildren();
        for (i = 0; i < fields.size(); ++i) {
            Optional<Field> parameter = parameters.get(i);
            if (!parameter.isPresent()) continue;
            columnChunk = this.readColumnChunk(parameter.get());
            blocks[i] = columnChunk.getBlock();
        }
        for (i = 0; i < fields.size(); ++i) {
            if (blocks[i] != null) continue;
            blocks[i] = RunLengthEncodedBlock.create((Type)field.getType(), null, (int)columnChunk.getBlock().getPositionCount());
        }
        BooleanList structIsNull = StructColumnReader.calculateStructOffsets(field, columnChunk.getDefinitionLevels(), columnChunk.getRepetitionLevels());
        boolean[] structIsNullVector = structIsNull.toBooleanArray();
        Block rowBlock = RowBlock.fromFieldBlocks((int)structIsNullVector.length, Optional.of(structIsNullVector), (Block[])blocks);
        return new ColumnChunk(rowBlock, columnChunk.getDefinitionLevels(), columnChunk.getRepetitionLevels());
    }

    private ColumnChunk readPrimitive(PrimitiveField field) throws IOException {
        long bytesPerCell;
        RichColumnDescriptor columnDescriptor = field.getDescriptor();
        int fieldId = field.getId();
        ColumnReader columnReader = this.columnReaders[fieldId];
        if (!columnReader.isInitialized()) {
            ParquetValidationUtils.validateParquet(this.currentBlockMetadata.getRowCount() > 0L, "Row group has 0 rows", new Object[0]);
            ColumnChunkMetaData columnChunkMetaData = this.getColumnChunkMetaData(columnDescriptor);
            long startingPosition = columnChunkMetaData.getStartingPos();
            int columnChunkSize = Math.toIntExact(columnChunkMetaData.getTotalSize());
            if (this.shouldUseColumnIndex(columnChunkMetaData.getPath())) {
                OffsetIndex offsetIndex = this.blockIndexStores.get(this.currentBlock).getOffsetIndex(columnChunkMetaData.getPath());
                OffsetIndex filteredOffsetIndex = ColumnIndexFilterUtils.filterOffsetIndex(offsetIndex, this.currentGroupRowRanges, this.blocks.get(this.currentBlock).getRowCount());
                List<ColumnIndexFilterUtils.OffsetRange> offsetRanges = ColumnIndexFilterUtils.calculateOffsetRanges(filteredOffsetIndex, columnChunkMetaData, offsetIndex.getOffset(0), startingPosition);
                List<ColumnIndexFilterUtils.OffsetRange> consecutiveRanges = this.concatRanges(offsetRanges);
                int consecutiveRangesSize = consecutiveRanges.stream().mapToInt(range -> (int)range.getLength()).sum();
                PageReader pageReader = this.createPageReader(this.dataSourceAsInputStream(startingPosition, consecutiveRanges), consecutiveRangesSize, columnChunkMetaData, columnDescriptor, Optional.of(filteredOffsetIndex), this.pageReaderMemoryContext);
                columnReader.init(pageReader, field, this.currentGroupRowRanges);
                if (this.enableVerification) {
                    ColumnReader verificationColumnReader = this.verificationColumnReaders[field.getId()];
                    PageReader pageReaderVerification = this.createPageReader(this.dataSourceAsInputStream(startingPosition, consecutiveRanges), consecutiveRangesSize, columnChunkMetaData, columnDescriptor, Optional.of(filteredOffsetIndex), this.verificationPageReaderMemoryContext);
                    verificationColumnReader.init(pageReaderVerification, field, this.currentGroupRowRanges);
                }
            } else {
                PageReader pageReader = this.createPageReader(this.dataSourceAsInputStream(startingPosition, columnChunkSize), columnChunkSize, columnChunkMetaData, columnDescriptor, Optional.empty(), this.pageReaderMemoryContext);
                columnReader.init(pageReader, field, null);
                if (this.enableVerification) {
                    ColumnReader verificationColumnReader = this.verificationColumnReaders[field.getId()];
                    PageReader pageReaderVerification = this.createPageReader(this.dataSourceAsInputStream(startingPosition, columnChunkSize), columnChunkSize, columnChunkMetaData, columnDescriptor, Optional.empty(), this.verificationPageReaderMemoryContext);
                    verificationColumnReader.init(pageReaderVerification, field, null);
                }
            }
        }
        ColumnChunk columnChunk = columnReader.readNext();
        columnChunk = ParquetReader.typeCoercion(columnChunk, field.getDescriptor().getPrimitiveType().getPrimitiveTypeName(), field.getType());
        if (this.enableVerification) {
            ColumnReader verificationColumnReader = this.verificationColumnReaders[field.getId()];
            ColumnChunk expected = verificationColumnReader.readNext();
            ParquetResultVerifierUtils.verifyColumnChunks(columnChunk, expected, columnDescriptor.getPath().length > 1, field, this.dataSource.getId());
        }
        if (this.maxBytesPerCell[fieldId] < (bytesPerCell = columnChunk.getBlock().getSizeInBytes() / (long)this.batchSize)) {
            this.maxCombinedBytesPerRow = this.maxCombinedBytesPerRow - this.maxBytesPerCell[fieldId] + bytesPerCell;
            this.maxBatchSize = Math.toIntExact(Math.min((long)this.maxBatchSize, Math.max(1L, this.maxReadBlockBytes / this.maxCombinedBytesPerRow)));
            this.maxBytesPerCell[fieldId] = bytesPerCell;
        }
        return columnChunk;
    }

    private InputStream dataSourceAsInputStream(long startingPosition, List<ColumnIndexFilterUtils.OffsetRange> offsetRanges) {
        ArrayList<InputStream> inputStreams = new ArrayList<InputStream>();
        for (ColumnIndexFilterUtils.OffsetRange r : offsetRanges) {
            InputStream inputStream = this.dataSourceAsInputStream(startingPosition + r.getOffset(), r.getLength());
            inputStreams.add(inputStream);
        }
        return new SequenceInputStream(Collections.enumeration(inputStreams));
    }

    private InputStream dataSourceAsInputStream(final long startingPosition, final long totalSize) {
        InputStream dataSourceAsStream = new InputStream(){
            private long readBytes;
            private long currentPosition;
            {
                this.currentPosition = startingPosition;
            }

            @Override
            public int read() {
                byte[] buffer = new byte[1];
                this.read(buffer, 0, 1);
                return buffer[0];
            }

            @Override
            public int read(byte[] buffer, int offset, int len) {
                if (this.readBytes >= totalSize) {
                    return 0;
                }
                len = (int)Math.min((long)len, totalSize - this.readBytes);
                ParquetReader.this.dataSource.readFully(this.currentPosition, buffer, offset, len);
                this.currentPosition += (long)len;
                this.readBytes += (long)len;
                return len;
            }

            @Override
            public int available() {
                return (int)(totalSize - this.readBytes);
            }

            @Override
            public boolean markSupported() {
                return false;
            }
        };
        return dataSourceAsStream;
    }

    private boolean shouldUseColumnIndex(ColumnPath path) {
        return this.filter != null && this.columnIndexFilterEnabled && this.currentGroupRowRanges != null && this.currentGroupRowRanges.rowCount() < this.currentGroupRowCount && this.blockIndexStores.get(this.currentBlock) != null && this.blockIndexStores.get(this.currentBlock).getColumnIndex(path) != null;
    }

    private PageReader createPageReader(InputStream inputStream, int columnChunkSize, ColumnChunkMetaData columnChunkMetaData, ColumnDescriptor columnDescriptor, Optional<OffsetIndex> offsetIndex, LocalMemoryContext memoryContext) throws IOException {
        ColumnChunkDescriptor descriptor = new ColumnChunkDescriptor(columnDescriptor, columnChunkMetaData, columnChunkSize);
        ParquetColumnChunk columnChunk = new ParquetColumnChunk(descriptor, new ParquetColumnChunk.ColumnChunkBufferedInputStream(Objects.requireNonNull(inputStream), Math.min(columnChunkSize, (int)this.maxReadBlockBytes)), offsetIndex, memoryContext);
        return this.createPageReaderInternal(columnDescriptor, columnChunk, memoryContext);
    }

    private PageReader createPageReaderInternal(ColumnDescriptor columnDescriptor, ParquetColumnChunk columnChunk, LocalMemoryContext memoryContext) throws IOException {
        if (!this.isEncryptedColumn(this.fileDecryptor, columnDescriptor)) {
            return columnChunk.buildPageReader(Optional.empty(), -1, -1);
        }
        int columnOrdinal = this.fileDecryptor.get().getColumnSetup(ColumnPath.get((String[])columnChunk.getDescriptor().getColumnDescriptor().getPath())).getOrdinal();
        return columnChunk.buildPageReader(this.fileDecryptor, this.currentBlock, columnOrdinal);
    }

    private boolean isEncryptedColumn(Optional<InternalFileDecryptor> fileDecryptor, ColumnDescriptor columnDescriptor) {
        ColumnPath columnPath = ColumnPath.get((String[])columnDescriptor.getPath());
        return fileDecryptor.isPresent() && !fileDecryptor.get().plaintextFile() && fileDecryptor.get().getColumnSetup(columnPath).isEncrypted();
    }

    private ColumnChunkMetaData getColumnChunkMetaData(ColumnDescriptor columnDescriptor) throws IOException {
        for (ColumnChunkMetaData metadata : this.currentBlockMetadata.getColumns()) {
            if (HiddenColumnChunkMetaData.isHiddenColumn(metadata) || !metadata.getPath().equals((Object)ColumnPath.get((String[])columnDescriptor.getPath()))) continue;
            return metadata;
        }
        throw new ParquetCorruptionException("Metadata is missing for column: %s", columnDescriptor);
    }

    private void initializeColumnReaders() {
        for (PrimitiveColumnIO columnIO : this.columns) {
            RichColumnDescriptor column = new RichColumnDescriptor(columnIO.getColumnDescriptor(), columnIO.getType().asPrimitiveType());
            this.columnReaders[columnIO.getId()] = ColumnReaderFactory.createReader(column, this.batchReadEnabled);
            if (!this.enableVerification) continue;
            this.verificationColumnReaders[columnIO.getId()] = ColumnReaderFactory.createReader(column, false);
        }
    }

    public Block readBlock(Field field) throws IOException {
        return this.readColumnChunk(field).getBlock();
    }

    private ColumnChunk readColumnChunk(Field field) throws IOException {
        ColumnChunk columnChunk = "row".equals(field.getType().getTypeSignature().getBase()) ? this.readStruct((GroupField)field) : ("map".equals(field.getType().getTypeSignature().getBase()) ? this.readMap((GroupField)field) : ("array".equals(field.getType().getTypeSignature().getBase()) ? this.readArray((GroupField)field) : this.readPrimitive((PrimitiveField)field)));
        this.parquetReaderMemoryContext.setBytes(this.getRetainedSizeInBytes());
        return columnChunk;
    }

    private long getRetainedSizeInBytes() {
        long sizeInBytes = INSTANCE_SIZE;
        for (int i = 0; i < this.columnReaders.length; ++i) {
            sizeInBytes += this.columnReaders[i] == null ? 0L : this.columnReaders[i].getRetainedSizeInBytes();
            if (this.verificationColumnReaders == null) continue;
            sizeInBytes += this.verificationColumnReaders[i] == null ? 0L : this.verificationColumnReaders[i].getRetainedSizeInBytes();
        }
        return sizeInBytes += SizeOf.sizeOf((long[])this.maxBytesPerCell);
    }

    private static ColumnChunk typeCoercion(ColumnChunk columnChunk, PrimitiveType.PrimitiveTypeName physicalDataType, Type outputType) {
        Block newBlock = null;
        if (SmallintType.SMALLINT.equals((Object)outputType) || TinyintType.TINYINT.equals((Object)outputType)) {
            if (columnChunk.getBlock() instanceof IntArrayBlock) {
                newBlock = ParquetReader.rewriteIntegerArrayBlock((IntArrayBlock)columnChunk.getBlock(), outputType);
            } else if (columnChunk.getBlock() instanceof LongArrayBlock) {
                newBlock = ParquetReader.rewriteLongArrayBlock((LongArrayBlock)columnChunk.getBlock(), outputType);
            }
        } else if (IntegerType.INTEGER.equals((Object)outputType) && physicalDataType == PrimitiveType.PrimitiveTypeName.INT64) {
            if (columnChunk.getBlock() instanceof LongArrayBlock) {
                newBlock = ParquetReader.rewriteLongArrayBlock((LongArrayBlock)columnChunk.getBlock(), outputType);
            }
        } else if (BigintType.BIGINT.equals((Object)outputType) && physicalDataType == PrimitiveType.PrimitiveTypeName.INT32 && columnChunk.getBlock() instanceof IntArrayBlock) {
            newBlock = ParquetReader.rewriteIntegerArrayBlock((IntArrayBlock)columnChunk.getBlock(), outputType);
        }
        if (newBlock != null) {
            return new ColumnChunk(newBlock, columnChunk.getDefinitionLevels(), columnChunk.getRepetitionLevels());
        }
        return columnChunk;
    }

    private static Block rewriteIntegerArrayBlock(IntArrayBlock intArrayBlock, Type targetType) {
        int positionCount = intArrayBlock.getPositionCount();
        BlockBuilder newBlockBuilder = targetType.createBlockBuilder(null, positionCount);
        for (int position = 0; position < positionCount; ++position) {
            if (intArrayBlock.isNull(position)) {
                newBlockBuilder.appendNull();
                continue;
            }
            targetType.writeLong(newBlockBuilder, (long)intArrayBlock.getInt(position));
        }
        return newBlockBuilder.build();
    }

    private static Block rewriteLongArrayBlock(LongArrayBlock longArrayBlock, Type targetType) {
        int positionCount = longArrayBlock.getPositionCount();
        BlockBuilder newBlockBuilder = targetType.createBlockBuilder(null, positionCount);
        for (int position = 0; position < positionCount; ++position) {
            if (longArrayBlock.isNull(position)) {
                newBlockBuilder.appendNull();
                continue;
            }
            targetType.writeLong(newBlockBuilder, longArrayBlock.getLong(position, 0));
        }
        return newBlockBuilder.build();
    }

    private static <T> List<T> listWithNulls(int size) {
        return Stream.generate(() -> null).limit(size).collect(Collectors.toCollection(ArrayList::new));
    }

    private RowRanges getRowRanges(int blockIndex) {
        assert (this.filter != null);
        RowRanges rowRanges = this.blockRowRanges.get(blockIndex);
        if (rowRanges == null) {
            rowRanges = ColumnIndexFilter.calculateRowRanges((FilterCompat.Filter)FilterCompat.get((FilterPredicate)this.filter), (ColumnIndexStore)this.blockIndexStores.get(blockIndex), this.paths.keySet(), (long)this.blocks.get(blockIndex).getRowCount());
            this.blockRowRanges.set(blockIndex, rowRanges);
        }
        return rowRanges;
    }

    private List<ColumnIndexFilterUtils.OffsetRange> concatRanges(List<ColumnIndexFilterUtils.OffsetRange> offsetRanges) {
        ArrayList<ColumnIndexFilterUtils.OffsetRange> pageRanges = new ArrayList<ColumnIndexFilterUtils.OffsetRange>();
        ColumnIndexFilterUtils.OffsetRange currentParts = null;
        for (ColumnIndexFilterUtils.OffsetRange range : offsetRanges) {
            long startPosition = range.getOffset();
            if (currentParts == null || currentParts.endPos() != startPosition) {
                currentParts = new ColumnIndexFilterUtils.OffsetRange(startPosition, 0);
            }
            pageRanges.add(currentParts);
            currentParts.extendLength(range.getLength());
        }
        return pageRanges;
    }
}

