/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.writer.levels;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.ColumnarArray;
import com.facebook.presto.common.block.ColumnarMap;
import com.facebook.presto.parquet.writer.levels.RepetitionLevelIterable;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class RepetitionLevelIterables {
    private RepetitionLevelIterables() {
    }

    public static RepetitionLevelIterable of(Block block) {
        return new BlockRepLevel(block);
    }

    public static RepetitionLevelIterable of(ColumnarArray columnarArray, int maxRepLevel) {
        return new ArrayRepLevel(columnarArray, maxRepLevel);
    }

    public static RepetitionLevelIterable of(ColumnarMap columnarMap, int maxRepLevel) {
        return new MapRepLevel(columnarMap, maxRepLevel);
    }

    public static Iterator<Integer> getIterator(List<RepetitionLevelIterable> iterables) {
        return new NestedRepetitionLevelIterator(iterables);
    }

    private static RepetitionLevelIterable.RepetitionLevel nullValue(int value) {
        return new RepetitionLevelIterable.RepetitionLevel(value, true);
    }

    private static RepetitionLevelIterable.RepetitionLevel nonNullValue(int value) {
        return new RepetitionLevelIterable.RepetitionLevel(value, false);
    }

    static class FixedValueIterator
    extends AbstractIterator<RepetitionLevelIterable.RepetitionLevel> {
        private final int length;
        private final int parentValue;
        private final int currentValue;
        private int position = -1;

        FixedValueIterator(int length, int parentValue, int currentValue) {
            this.length = length;
            this.parentValue = parentValue;
            this.currentValue = currentValue;
        }

        protected RepetitionLevelIterable.RepetitionLevel computeNext() {
            ++this.position;
            if (this.position < this.length) {
                if (this.position == 0) {
                    return RepetitionLevelIterables.nonNullValue(this.parentValue);
                }
                return RepetitionLevelIterables.nonNullValue(this.currentValue);
            }
            return (RepetitionLevelIterable.RepetitionLevel)this.endOfData();
        }
    }

    static class NestedRepetitionLevelIterator
    extends AbstractIterator<Integer> {
        private final List<RepetitionLevelIterable.RepetitionValueIterator> repValueIteratorList;
        private int iteratorIndex;

        NestedRepetitionLevelIterator(List<RepetitionLevelIterable> repValueIteratorList) {
            this.repValueIteratorList = (List)repValueIteratorList.stream().map(RepetitionLevelIterable::getIterator).collect(ImmutableList.toImmutableList());
        }

        protected Integer computeNext() {
            RepetitionLevelIterable.RepetitionValueIterator current = this.repValueIteratorList.get(this.iteratorIndex);
            while (this.iteratorIndex > 0 && current.end()) {
                current = this.repValueIteratorList.get(--this.iteratorIndex);
            }
            while (current.hasNext()) {
                RepetitionLevelIterable.RepetitionLevel currentRepValue = (RepetitionLevelIterable.RepetitionLevel)current.next();
                if (currentRepValue.isNull() || this.iteratorIndex == this.repValueIteratorList.size() - 1) {
                    return currentRepValue.value();
                }
                int lastValue = currentRepValue.value();
                current = this.repValueIteratorList.get(this.iteratorIndex + 1);
                current.setBase(lastValue);
                ++this.iteratorIndex;
            }
            Preconditions.checkState((boolean)this.repValueIteratorList.stream().noneMatch(AbstractIterator::hasNext));
            return (Integer)this.endOfData();
        }
    }

    static class MapRepLevel
    implements RepetitionLevelIterable {
        private final ColumnarMap columnarArray;
        private final int maxRepValue;

        MapRepLevel(ColumnarMap columnarArray, int maxRepValue) {
            this.columnarArray = Objects.requireNonNull(columnarArray, "columnarArray is null");
            this.maxRepValue = maxRepValue;
        }

        @Override
        public RepetitionLevelIterable.RepetitionValueIterator getIterator() {
            return new RepetitionLevelIterable.RepetitionValueIterator(){
                private int position = -1;
                private FixedValueIterator iterator;

                @Override
                boolean end() {
                    return this.iterator == null || !this.iterator.hasNext();
                }

                protected RepetitionLevelIterable.RepetitionLevel computeNext() {
                    if (this.iterator != null && this.iterator.hasNext()) {
                        return (RepetitionLevelIterable.RepetitionLevel)this.iterator.next();
                    }
                    ++this.position;
                    if (this.position == columnarArray.getPositionCount()) {
                        return (RepetitionLevelIterable.RepetitionLevel)this.endOfData();
                    }
                    if (columnarArray.isNull(this.position)) {
                        return RepetitionLevelIterables.nullValue(this.getBase());
                    }
                    int arrayLength = columnarArray.getEntryCount(this.position);
                    if (arrayLength == 0) {
                        return RepetitionLevelIterables.nullValue(this.getBase());
                    }
                    this.iterator = new FixedValueIterator(arrayLength, this.getBase(), maxRepValue);
                    return (RepetitionLevelIterable.RepetitionLevel)this.iterator.next();
                }
            };
        }
    }

    static class ArrayRepLevel
    implements RepetitionLevelIterable {
        private final ColumnarArray columnarArray;
        private final int maxRepValue;

        ArrayRepLevel(ColumnarArray columnarArray, int maxRepValue) {
            this.columnarArray = Objects.requireNonNull(columnarArray, "columnarArray is null");
            this.maxRepValue = maxRepValue;
        }

        @Override
        public RepetitionLevelIterable.RepetitionValueIterator getIterator() {
            return new RepetitionLevelIterable.RepetitionValueIterator(){
                private int position = -1;
                private FixedValueIterator iterator;

                @Override
                boolean end() {
                    return this.iterator == null || !this.iterator.hasNext();
                }

                protected RepetitionLevelIterable.RepetitionLevel computeNext() {
                    if (this.iterator != null && this.iterator.hasNext()) {
                        return (RepetitionLevelIterable.RepetitionLevel)this.iterator.next();
                    }
                    ++this.position;
                    if (this.position == columnarArray.getPositionCount()) {
                        return (RepetitionLevelIterable.RepetitionLevel)this.endOfData();
                    }
                    if (columnarArray.isNull(this.position)) {
                        return RepetitionLevelIterables.nullValue(this.getBase());
                    }
                    int arrayLength = columnarArray.getLength(this.position);
                    if (arrayLength == 0) {
                        return RepetitionLevelIterables.nullValue(this.getBase());
                    }
                    this.iterator = new FixedValueIterator(arrayLength, this.getBase(), maxRepValue);
                    return (RepetitionLevelIterable.RepetitionLevel)this.iterator.next();
                }
            };
        }
    }

    static class BlockRepLevel
    implements RepetitionLevelIterable {
        private final Block block;

        BlockRepLevel(Block block) {
            this.block = Objects.requireNonNull(block, "block is null");
        }

        @Override
        public RepetitionLevelIterable.RepetitionValueIterator getIterator() {
            return new RepetitionLevelIterable.RepetitionValueIterator(){
                private int position = -1;

                @Override
                boolean end() {
                    return true;
                }

                protected RepetitionLevelIterable.RepetitionLevel computeNext() {
                    ++this.position;
                    if (this.position == block.getPositionCount()) {
                        return (RepetitionLevelIterable.RepetitionLevel)this.endOfData();
                    }
                    if (block.isNull(this.position)) {
                        return RepetitionLevelIterables.nullValue(this.getBase());
                    }
                    return RepetitionLevelIterables.nonNullValue(this.getBase());
                }
            };
        }
    }
}

