/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.writer.valuewriter;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.parquet.writer.valuewriter.PrimitiveValueWriter;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;

public class TimestampValueWriter
extends PrimitiveValueWriter {
    private final Type type;
    private final boolean writeMicroseconds;

    public TimestampValueWriter(ValuesWriter valuesWriter, Type type, PrimitiveType parquetType) {
        super(parquetType, valuesWriter);
        this.type = Objects.requireNonNull(type, "type is null");
        this.writeMicroseconds = parquetType.isPrimitive() && parquetType.getOriginalType() == OriginalType.TIMESTAMP_MICROS;
    }

    @Override
    public void write(Block block) {
        for (int i = 0; i < block.getPositionCount(); ++i) {
            if (block.isNull(i)) continue;
            long value = this.type.getLong(block, i);
            long scaledValue = this.writeMicroseconds ? TimeUnit.MILLISECONDS.toMicros(value) : value;
            this.getValueWriter().writeLong(scaledValue);
            this.getStatistics().updateStats(scaledValue);
        }
    }
}

