/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.batchreader.decoders;

import com.facebook.presto.parquet.batchreader.decoders.rle.BaseRLEBitPackedDecoder;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import org.apache.parquet.io.ParquetDecodingException;

public class DefinitionLevelDecoder
extends BaseRLEBitPackedDecoder {
    public DefinitionLevelDecoder(int valueCount, int bitWidth, InputStream inputStream) {
        super(valueCount, bitWidth, inputStream);
    }

    public DefinitionLevelDecoder(int rleValue, int valueCount) {
        super(rleValue, valueCount);
    }

    public void readNext(int[] values, int offset, int length) throws IOException {
        int remainingToCopy;
        int chunkSize;
        int destinationIndex = offset;
        for (remainingToCopy = length; remainingToCopy > 0 && (this.currentCount != 0 || this.decode()); remainingToCopy -= chunkSize) {
            chunkSize = Math.min(remainingToCopy, this.currentCount);
            switch (this.mode) {
                case RLE: {
                    int rleValue = this.currentValue;
                    int endIndex = destinationIndex + chunkSize;
                    while (destinationIndex < endIndex) {
                        values[destinationIndex] = rleValue;
                        ++destinationIndex;
                    }
                    break;
                }
                case PACKED: {
                    System.arraycopy(this.currentBuffer, this.currentBuffer.length - this.currentCount, values, destinationIndex, chunkSize);
                    destinationIndex += chunkSize;
                    break;
                }
                default: {
                    throw new ParquetDecodingException("not a valid mode " + (Object)((Object)this.mode));
                }
            }
            this.currentCount -= chunkSize;
        }
        Preconditions.checkState((remainingToCopy == 0 ? 1 : 0) != 0, (Object)"Failed to copy the requested number of DLs");
    }
}

