/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.parquet.writer;

import com.facebook.presto.parquet.writer.ColumnChunk;
import com.facebook.presto.parquet.writer.ColumnWriter;
import com.facebook.presto.parquet.writer.ParquetCompressor;
import com.facebook.presto.parquet.writer.ParquetDataOutput;
import com.facebook.presto.parquet.writer.ParquetTypeConverter;
import com.facebook.presto.parquet.writer.levels.DefinitionLevelIterable;
import com.facebook.presto.parquet.writer.levels.DefinitionLevelIterables;
import com.facebook.presto.parquet.writer.levels.RepetitionLevelIterable;
import com.facebook.presto.parquet.writer.levels.RepetitionLevelIterables;
import com.facebook.presto.parquet.writer.valuewriter.PrimitiveValueWriter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.page.DictionaryPage;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.format.ColumnMetaData;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.schema.Type;

public abstract class PrimitiveColumnWriter
implements ColumnWriter {
    protected final ColumnDescriptor columnDescriptor;
    protected final PrimitiveValueWriter primitiveValueWriter;
    protected final ParquetMetadataConverter parquetMetadataConverter = new ParquetMetadataConverter();
    protected final Set<Encoding> encodings;
    protected final int maxDefinitionLevel;
    protected final List<ParquetDataOutput> pageBuffer = new ArrayList<ParquetDataOutput>();
    @Nullable
    protected final ParquetCompressor compressor;
    protected final int pageSizeThreshold;
    private final com.facebook.presto.common.type.Type type;
    private final CompressionCodecName compressionCodec;
    protected boolean closed;
    protected boolean getDataStreamsCalled;
    protected int valueCount;
    protected int currentPageNullCounts;
    protected long totalCompressedSize;
    protected long totalUnCompressedSize;
    protected long totalValues;
    protected Statistics<?> columnStatistics;

    public PrimitiveColumnWriter(com.facebook.presto.common.type.Type type, ColumnDescriptor columnDescriptor, PrimitiveValueWriter primitiveValueWriter, CompressionCodecName compressionCodecName, int pageSizeThreshold) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.columnDescriptor = Objects.requireNonNull(columnDescriptor, "columnDescriptor is null");
        this.maxDefinitionLevel = columnDescriptor.getMaxDefinitionLevel();
        this.primitiveValueWriter = Objects.requireNonNull(primitiveValueWriter, "primitiveValueWriter is null");
        this.encodings = new HashSet<Encoding>();
        this.compressionCodec = Objects.requireNonNull(compressionCodecName, "compressionCodecName is null");
        this.compressor = ParquetCompressor.getCompressor(compressionCodecName);
        this.pageSizeThreshold = pageSizeThreshold;
        this.columnStatistics = Statistics.createStats((Type)columnDescriptor.getPrimitiveType());
    }

    @Override
    public void writeBlock(ColumnChunk columnChunk) throws IOException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        ColumnChunk current = new ColumnChunk(columnChunk.getBlock(), (List<DefinitionLevelIterable>)ImmutableList.builder().addAll(columnChunk.getDefinitionLevelIterables()).add((Object)DefinitionLevelIterables.of(columnChunk.getBlock(), this.maxDefinitionLevel)).build(), (List<RepetitionLevelIterable>)ImmutableList.builder().addAll(columnChunk.getRepetitionLevelIterables()).add((Object)RepetitionLevelIterables.of(columnChunk.getBlock())).build());
        this.primitiveValueWriter.write(columnChunk.getBlock());
        this.writeDefinitionAndRepetitionLevels(current);
        if (this.getBufferedBytes() >= (long)this.pageSizeThreshold) {
            this.flushCurrentPageToBuffer();
        }
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public List<ColumnWriter.BufferData> getBuffer() throws IOException {
        Preconditions.checkState((boolean)this.closed);
        return ImmutableList.of((Object)new ColumnWriter.BufferData(this.getDataStreams(), this.getColumnMetaData()));
    }

    protected ColumnMetaData getColumnMetaData() {
        Preconditions.checkState((boolean)this.getDataStreamsCalled);
        ColumnMetaData columnMetaData = new ColumnMetaData(ParquetTypeConverter.getType(this.columnDescriptor.getPrimitiveType().getPrimitiveTypeName()), (List)this.encodings.stream().map(arg_0 -> ((ParquetMetadataConverter)this.parquetMetadataConverter).getEncoding(arg_0)).collect(ImmutableList.toImmutableList()), (List)ImmutableList.copyOf((Object[])this.columnDescriptor.getPath()), this.compressionCodec.getParquetCompressionCodec(), this.totalValues, this.totalUnCompressedSize, this.totalCompressedSize, -1L);
        columnMetaData.setStatistics(ParquetMetadataConverter.toParquetStatistics(this.columnStatistics));
        return columnMetaData;
    }

    protected List<ParquetDataOutput> getDataStreams() throws IOException {
        DictionaryPage dictionaryPage;
        ArrayList<ParquetDataOutput> dictPage = new ArrayList<ParquetDataOutput>();
        if (this.valueCount > 0) {
            this.flushCurrentPageToBuffer();
        }
        if ((dictionaryPage = this.primitiveValueWriter.toDictPageAndClose()) != null) {
            BytesInput pageBytes = BytesInput.copy((BytesInput)dictionaryPage.getBytes());
            long uncompressedSize = dictionaryPage.getUncompressedSize();
            ParquetDataOutput pageData = ParquetDataOutput.createDataOutput(pageBytes);
            if (this.compressor != null) {
                pageData = this.compressor.compress(pageBytes);
            }
            long compressedSize = pageData.size();
            ByteArrayOutputStream dictStream = new ByteArrayOutputStream();
            this.parquetMetadataConverter.writeDictionaryPageHeader(Math.toIntExact(uncompressedSize), Math.toIntExact(compressedSize), dictionaryPage.getDictionarySize(), dictionaryPage.getEncoding(), (OutputStream)dictStream);
            ParquetDataOutput pageHeader = ParquetDataOutput.createDataOutput(Slices.wrappedBuffer((byte[])dictStream.toByteArray()));
            dictPage.add(pageHeader);
            dictPage.add(pageData);
            this.totalCompressedSize += pageHeader.size() + compressedSize;
            this.totalUnCompressedSize += pageHeader.size() + uncompressedSize;
            this.primitiveValueWriter.resetDictionary();
        }
        this.getDataStreamsCalled = true;
        return ImmutableList.builder().addAll(dictPage).addAll(this.pageBuffer).build();
    }

    @Override
    public abstract long getBufferedBytes();

    @Override
    public long getRetainedBytes() {
        return 0L;
    }

    @Override
    public void reset() {
        this.pageBuffer.clear();
        this.primitiveValueWriter.reset();
        this.closed = false;
        this.totalCompressedSize = 0L;
        this.totalUnCompressedSize = 0L;
        this.totalValues = 0L;
        this.encodings.clear();
        this.columnStatistics = Statistics.createStats((Type)this.columnDescriptor.getPrimitiveType());
        this.getDataStreamsCalled = false;
    }

    protected abstract void writeDefinitionAndRepetitionLevels(ColumnChunk var1) throws IOException;

    protected abstract void flushCurrentPageToBuffer() throws IOException;
}

